/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import java.util.ArrayList;
import org.eclipse.vex.ui.internal.config.IConfigElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomConfigurationElement
implements IConfigElement {
    private final Element element;

    public DomConfigurationElement(Element element) {
        this.element = element;
    }

    public String getAttribute(String name) {
        return this.element.getAttribute(name);
    }

    public String[] getAttributeNames() {
        int n = this.element.getAttributes().getLength();
        String[] names = new String[n];
        int i = 0;
        while (i < n) {
            Node node = this.element.getAttributes().item(i);
            names[i] = node.getLocalName();
            ++i;
        }
        return names;
    }

    public IConfigElement[] getChildren() {
        return this.getChildren(null);
    }

    public IConfigElement[] getChildren(String name) {
        ArrayList<DomConfigurationElement> children = new ArrayList<DomConfigurationElement>();
        NodeList list = this.element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node instanceof Element && (name == null || name.equals(node.getNodeName()))) {
                children.add(new DomConfigurationElement((Element)node));
            }
            ++i;
        }
        return children.toArray(new IConfigElement[children.size()]);
    }

    public String getName() {
        return this.element.getLocalName();
    }

    public String getValue() {
        StringBuffer sb = new StringBuffer();
        NodeList list = this.element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node instanceof Text) {
                sb.append(node.getNodeValue());
            }
            ++i;
        }
        return sb.toString();
    }
}

