/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.vex.core.internal.css.StyleSheetReader;
import org.eclipse.vex.ui.internal.config.BuildProblem;
import org.eclipse.vex.ui.internal.config.ConfigItem;
import org.eclipse.vex.ui.internal.config.ConfigSource;
import org.eclipse.vex.ui.internal.config.ConfigurationElement;
import org.eclipse.vex.ui.internal.config.IBuildProblemHandler;
import org.eclipse.vex.ui.internal.config.IConfigElement;
import org.eclipse.vex.ui.internal.config.IConfigItemFactory;
import org.eclipse.vex.ui.internal.config.Messages;
import org.eclipse.vex.ui.internal.config.Style;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;

public class StyleFactory
implements IConfigItemFactory {
    private static final String[] EXTS = new String[]{"css"};

    public IConfigElement[] createConfigurationElements(ConfigItem item) {
        Style style = (Style)item;
        ConfigurationElement element = new ConfigurationElement("style");
        element.setAttribute("css", style.getResourceUri().toString());
        for (String publicId : style.getDocumentTypes()) {
            ConfigurationElement child = new ConfigurationElement("doctypeRef");
            child.setAttribute("publicId", publicId);
            element.addChild(child);
        }
        return new IConfigElement[]{element};
    }

    public ConfigItem createItem(ConfigSource config, IConfigElement[] configElements) throws IOException {
        IConfigElement[] doctypeRefs;
        if (configElements.length < 1) {
            return null;
        }
        IConfigElement configElement = configElements[0];
        Style style = new Style(config);
        style.setResourceUri(StyleFactory.newUri(config.resolve(null, configElement.getAttribute("css"))));
        IConfigElement[] iConfigElementArray = doctypeRefs = configElement.getChildren();
        int n = doctypeRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigElement doctypeRef = iConfigElementArray[n2];
            style.addDocumentType(doctypeRef.getAttribute("publicId"));
            ++n2;
        }
        return style;
    }

    private static URI newUri(String uriString) {
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public String getExtensionPointId() {
        return "org.eclipse.vex.ui.styles";
    }

    public String[] getFileExtensions() {
        return EXTS;
    }

    public String getPluralName() {
        return Messages.getString("StyleFactory.pluralName");
    }

    public Object parseResource(ConfigItem item, URL baseUrl, String resourcePath, IBuildProblemHandler problemHandler) throws IOException {
        try {
            return new StyleSheetReader().read(new URL(baseUrl, resourcePath));
        }
        catch (CSSParseException e) {
            if (problemHandler != null) {
                BuildProblem problem = new BuildProblem();
                problem.setSeverity(1);
                problem.setResourcePath(e.getURI());
                problem.setMessage(e.getMessage());
                problem.setLineNumber(e.getLineNumber());
                problemHandler.foundProblem(problem);
            }
            return null;
        }
        catch (CSSException e) {
            if (problemHandler != null) {
                BuildProblem problem = new BuildProblem();
                problem.setSeverity(1);
                problem.setResourcePath(baseUrl.toString());
                problem.setMessage(e.getMessage());
                problemHandler.foundProblem(problem);
            }
            return null;
        }
    }
}

