/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.ConfigEvent;
import org.eclipse.vex.ui.internal.config.ConfigItem;
import org.eclipse.vex.ui.internal.config.DocumentType;
import org.eclipse.vex.ui.internal.config.IConfigListener;
import org.eclipse.vex.ui.internal.config.Messages;
import org.eclipse.vex.ui.internal.config.PluginProject;
import org.eclipse.vex.ui.internal.config.Style;

public class StylePropertyPage
extends PropertyPage {
    private static final int NAME_WIDTH = 150;
    private PluginProject pluginProject;
    private Style style;
    private Composite pane;
    private Text nameText;
    private Table doctypesTable;
    private IConfigListener configListener;

    protected Control createContents(Composite parent) {
        this.pane = new Composite(parent, 0);
        this.pluginProject = new PluginProject(((IFile)this.getElement()).getProject());
        try {
            this.pluginProject.load();
        }
        catch (CoreException e) {
            VexPlugin.getDefault().getLog().log(e.getStatus());
        }
        this.createPropertySheet();
        this.configListener = new IConfigListener(){

            public void configChanged(ConfigEvent event) {
                try {
                    StylePropertyPage.this.pluginProject.load();
                }
                catch (CoreException e) {
                    VexPlugin.getDefault().getLog().log(e.getStatus());
                }
                StylePropertyPage.this.style = (Style)StylePropertyPage.this.pluginProject.getItemForResource((IResource)((IFile)StylePropertyPage.this.getElement()));
                StylePropertyPage.this.populateDoctypes();
            }

            public void configLoaded(ConfigEvent event) {
                StylePropertyPage.this.setMessage(StylePropertyPage.this.getTitle());
                StylePropertyPage.this.populateStyle();
                StylePropertyPage.this.setValid(true);
                try {
                    StylePropertyPage.this.pluginProject.writeConfigXml();
                }
                catch (Exception e) {
                    String message = MessageFormat.format(Messages.getString("StylePropertyPage.writeError"), "vex-plugin.xml");
                    VexPlugin.getDefault().log(4, message, e);
                }
            }
        };
        VexPlugin.getDefault().getConfigurationRegistry().addConfigListener(this.configListener);
        if (VexPlugin.getDefault().getConfigurationRegistry().isLoaded()) {
            this.populateStyle();
            this.populateDoctypes();
        } else {
            this.setValid(false);
            this.setMessage(Messages.getString("StylePropertyPage.loading"));
        }
        return this.pane;
    }

    private void createPropertySheet() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.pane.setLayout((Layout)layout);
        Label label = new Label(this.pane, 0);
        label.setText(Messages.getString("StylePropertyPage.name"));
        this.nameText = new Text(this.pane, 2048);
        GridData gd = new GridData();
        gd.widthHint = 150;
        this.nameText.setLayoutData((Object)gd);
        IFile file = (IFile)this.getElement();
        this.style = (Style)this.pluginProject.getItemForResource((IResource)file);
        if (this.style == null) {
            this.style = new Style(this.pluginProject);
            this.style.setResourceUri(file.getLocationURI());
            this.pluginProject.addItem(this.style);
        }
        if (this.style.getSimpleId() == null || this.style.getSimpleId().length() == 0) {
            this.style.setSimpleId(this.style.generateSimpleId());
        }
        label = new Label(this.pane, 0);
        label.setText(Messages.getString("StylePropertyPage.doctypes"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite tablePane = new Composite(this.pane, 2048);
        gd = new GridData(1808);
        gd.heightHint = 200;
        gd.horizontalSpan = 2;
        tablePane.setLayoutData((Object)gd);
        FillLayout fillLayout = new FillLayout();
        tablePane.setLayout((Layout)fillLayout);
        this.doctypesTable = new Table(tablePane, 32);
    }

    private void populateStyle() {
        StylePropertyPage.setText(this.nameText, this.style.getName());
    }

    private static void setText(Text textBox, String text) {
        textBox.setText(text == null ? "" : text);
    }

    private void populateDoctypes() {
        TreeSet<String> selectedDoctypes = new TreeSet<String>(this.style.getDocumentTypes());
        this.doctypesTable.removeAll();
        Object[] documentTypes = VexPlugin.getDefault().getConfigurationRegistry().getDocumentTypes();
        Arrays.sort(documentTypes);
        Object[] objectArray = documentTypes;
        int n = documentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Object documentType = objectArray[n2];
            TableItem item = new TableItem(this.doctypesTable, 0);
            item.setText(((ConfigItem)documentType).getName());
            if (selectedDoctypes.contains(((DocumentType)documentType).getPublicId())) {
                item.setChecked(true);
            }
            ++n2;
        }
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    public void performApply() {
        this.style.setName(this.nameText.getText());
        ArrayList<String> selectedDoctypes = new ArrayList<String>();
        TableItem[] tableItemArray = this.doctypesTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                selectedDoctypes.add(item.getText());
            }
            ++n2;
        }
        this.style.removeAllDocumentTypes();
        Object[] documentTypes = VexPlugin.getDefault().getConfigurationRegistry().getDocumentTypes();
        Arrays.sort(documentTypes);
        Object[] objectArray = documentTypes;
        int n3 = documentTypes.length;
        n = 0;
        while (n < n3) {
            Object documentType = objectArray[n];
            if (selectedDoctypes.contains(((ConfigItem)documentType).getName())) {
                this.style.addDocumentType(((DocumentType)documentType).getPublicId());
            }
            ++n;
        }
        try {
            this.pluginProject.writeConfigXml();
        }
        catch (Exception e) {
            String message = MessageFormat.format(Messages.getString("StylePropertyPage.writeError"), "vex-plugin.xml");
            VexPlugin.getDefault().log(4, message, e);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.populateStyle();
        this.populateDoctypes();
    }

    public void dispose() {
        super.dispose();
        if (this.configListener != null) {
            VexPlugin.getDefault().getConfigurationRegistry().removeConfigListener(this.configListener);
        }
    }
}

