/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.editor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.swt.graphics.Point;

public abstract class AbstractRegExFindReplaceTarget
implements IFindReplaceTarget,
IFindReplaceTargetExtension3 {
    private Matcher replacer;

    protected abstract int getSelectionStart();

    protected abstract int getSelectionEnd();

    protected abstract void setSelection(int var1, int var2);

    protected abstract CharSequence getDocument();

    protected abstract void inDocumentReplaceSelection(CharSequence var1);

    public boolean canPerformFind() {
        return true;
    }

    public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return this.findAndSelect(offset, findString, searchForward, caseSensitive, wholeWord, false);
    }

    public Point getSelection() {
        int offset = this.getSelectionStart();
        int length = this.getSelectionEnd() - this.getSelectionStart();
        return new Point(offset, length);
    }

    public String getSelectionText() {
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        return this.getDocument().subSequence(start, end).toString();
    }

    public boolean isEditable() {
        return true;
    }

    public void replaceSelection(String text) {
        this.replaceSelection(text, false);
    }

    public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        String patternString;
        this.replacer = null;
        int correctedOffset = offset;
        if (correctedOffset < 0) {
            correctedOffset = searchForward ? 0 : this.getDocument().length();
        }
        String string = patternString = regExSearch ? findString : Pattern.quote(findString);
        if (wholeWord) {
            patternString = "\\b" + patternString + "\\b";
        }
        int flagCaseSensitive = caseSensitive ? 0 : 2;
        Pattern pattern = Pattern.compile(patternString, flagCaseSensitive);
        Matcher matcher = pattern.matcher(this.getDocument());
        if (searchForward) {
            boolean success = matcher.find(correctedOffset);
            if (success) {
                this.setSelection(matcher.start(), matcher.end());
                this.replacer = matcher;
            }
            return success ? matcher.end() : -1;
        }
        boolean success = false;
        int start = 0;
        int end = 0;
        int i = 0;
        while (i < correctedOffset) {
            boolean currentFound = matcher.find(i);
            if (!currentFound || matcher.end() > correctedOffset) break;
            i = matcher.start() + 1;
            success = true;
            start = matcher.start();
            end = matcher.end();
        }
        if (success) {
            this.setSelection(start, end);
            this.replacer = matcher;
        }
        return success ? end : -1;
    }

    public void replaceSelection(String text, boolean regExReplace) {
        if (!this.isEditable()) {
            throw new IllegalStateException("'Replace' is unable because target is not editable.");
        }
        int selectionStart = this.getSelectionStart();
        if (selectionStart < 0) {
            return;
        }
        String replacement = text;
        if (regExReplace) {
            if (this.replacer == null) {
                throw new IllegalStateException();
            }
            StringBuffer result = new StringBuffer();
            try {
                this.replacer.appendReplacement(result, text);
            }
            catch (RuntimeException e) {
                String message = e.getLocalizedMessage();
                throw new PatternSyntaxException(message, text, -1);
            }
            replacement = result.substring(selectionStart);
        }
        this.inDocumentReplaceSelection(replacement);
        this.replacer = null;
        this.setSelection(selectionStart, selectionStart + replacement.length());
    }
}

