/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.vex.ui.internal.handlers.VexHandlerUtil;
import org.eclipse.vex.ui.internal.swt.VexWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentContextSourceProvider
extends AbstractSourceProvider {
    public static final String IS_COLUMN = "org.eclipse.vex.ui.isColumn";
    public static final String IS_FIRST_COLUMN = "org.eclipse.vex.ui.isFirstColumn";
    public static final String IS_LAST_COLUMN = "org.eclipse.vex.ui.isLastColumn";
    public static final String IS_ROW = "org.eclipse.vex.ui.isRow";
    public static final String IS_FIRST_ROW = "org.eclipse.vex.ui.isFirstRow";
    public static final String IS_LAST_ROW = "org.eclipse.vex.ui.isLastRow";
    private boolean isColumn;
    private boolean isFirstColumn;
    private boolean isLastColumn;
    private boolean isRow;
    private boolean isFirstRow;
    private boolean isLastRow;

    public void dispose() {
    }

    public String[] getProvidedSourceNames() {
        return new String[]{IS_COLUMN};
    }

    public Map<String, Boolean> getCurrentState() {
        HashMap<String, Boolean> currentState = new HashMap<String, Boolean>(6);
        currentState.put(IS_COLUMN, this.isColumn);
        currentState.put(IS_FIRST_COLUMN, this.isFirstColumn);
        currentState.put(IS_LAST_COLUMN, this.isLastColumn);
        currentState.put(IS_ROW, this.isRow);
        currentState.put(IS_FIRST_ROW, this.isFirstRow);
        currentState.put(IS_LAST_ROW, this.isLastRow);
        return currentState;
    }

    public void fireUpdate(VexWidget widget) {
        HashMap<String, Boolean> changes = new HashMap<String, Boolean>();
        VexHandlerUtil.RowColumnInfo rowColumnInfo = VexHandlerUtil.getRowColumnInfo(widget);
        int columnIndex = VexHandlerUtil.getCurrentColumnIndex(widget);
        int columnCount = rowColumnInfo == null ? -1 : rowColumnInfo.maxColumnCount;
        this.isColumn = DocumentContextSourceProvider.update(changes, this.isColumn, columnIndex != -1, IS_COLUMN);
        this.isFirstColumn = DocumentContextSourceProvider.update(changes, this.isFirstColumn, columnIndex == 0, IS_FIRST_COLUMN);
        this.isLastColumn = DocumentContextSourceProvider.update(changes, this.isLastColumn, columnIndex == columnCount - 1, IS_LAST_COLUMN);
        int rowCount = rowColumnInfo == null ? -1 : rowColumnInfo.rowCount;
        int rowIndex = rowColumnInfo == null ? -1 : rowColumnInfo.rowIndex;
        this.isRow = DocumentContextSourceProvider.update(changes, this.isRow, rowIndex != -1, IS_ROW);
        this.isFirstRow = DocumentContextSourceProvider.update(changes, this.isFirstRow, rowIndex == 0, IS_FIRST_ROW);
        this.isLastRow = DocumentContextSourceProvider.update(changes, this.isLastRow, rowIndex == rowCount - 1, IS_LAST_ROW);
        if (!changes.isEmpty()) {
            this.fireSourceChanged(0, changes);
        }
    }

    private static boolean update(Map<String, Boolean> changes, boolean oldValue, boolean newValue, String valueName) {
        if (newValue == oldValue) {
            return oldValue;
        }
        changes.put(valueName, newValue);
        return newValue;
    }
}

