/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.editor;

import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.DocumentType;
import org.eclipse.vex.ui.internal.editor.Messages;

public class DocumentTypeSelectionDialog
extends MessageDialog {
    private DocumentType doctype;
    private boolean alwaysUseThisDoctype;
    private ListViewer typeList;
    private Button alwaysUseButton;
    private final MouseListener mouseListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent e) {
            DocumentTypeSelectionDialog.this.buttonPressed(0);
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    };

    protected DocumentTypeSelectionDialog(Shell parentShell, String title, String message) {
        super(parentShell, title, null, message, 3, new String[]{Messages.getString("DocumentTypeSelectionDialog.ok"), Messages.getString("DocumentTypeSelectionDialog.cancel")}, 0);
        this.setShellStyle(16);
    }

    public static DocumentTypeSelectionDialog create(Shell parentShell, String publicId) {
        String message = publicId == null ? Messages.getString("DocumentTypeSelectionDialog.noDoctype") : Messages.getString("DocumentTypeSelectionDialog.unknownDoctype");
        return new DocumentTypeSelectionDialog(parentShell, Messages.getString("DocumentTypeSelectionDialog.selectDoctype"), MessageFormat.format(message, publicId));
    }

    protected Control createCustomArea(Composite parent) {
        this.typeList = new ListViewer(parent, 772);
        List list = this.typeList.getList();
        list.addMouseListener(this.mouseListener);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.heightHint = 120;
        list.setLayoutData((Object)gd);
        this.alwaysUseButton = new Button(parent, 32);
        this.alwaysUseButton.setText(Messages.getString("DocumentTypeSelectionDialog.alwaysUse"));
        Object[] doctypes = VexPlugin.getDefault().getConfigurationRegistry().getDocumentTypesWithStyles();
        Arrays.sort(doctypes);
        this.typeList.add(doctypes);
        return list;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            IStructuredSelection selection = (IStructuredSelection)this.typeList.getSelection();
            this.doctype = (DocumentType)selection.getFirstElement();
            this.alwaysUseThisDoctype = this.alwaysUseButton.getSelection();
        }
        super.buttonPressed(buttonId);
    }

    public DocumentType getDoctype() {
        return this.doctype;
    }

    public boolean alwaysUseThisDoctype() {
        return this.alwaysUseThisDoctype;
    }
}

