/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.editor;

import java.util.ResourceBundle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.texteditor.FindNextAction;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.vex.core.internal.dom.DocumentValidationException;
import org.eclipse.vex.ui.internal.editor.VexEditor;
import org.eclipse.vex.ui.internal.swt.VexWidget;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorActionBarContributor;

public class VexActionBarContributor
extends XMLMultiPageEditorActionBarContributor {
    private IEditorPart activeEditor;
    private final IAction copyAction = new CopyAction();
    private final IAction cutAction = new CutAction();
    private final IAction deleteAction = new DeleteAction();
    private final IAction pasteAction = new PasteAction();
    private final IAction redoAction = new RedoAction();
    private final IAction selectAllAction = new SelectAllAction();
    private final IAction undoAction = new UndoAction();
    private final ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            VexActionBarContributor.this.enableActions();
        }
    };

    public void dispose() {
    }

    public VexEditor getVexEditor() {
        return (VexEditor)this.activeEditor;
    }

    public VexWidget getVexWidget() {
        if (this.activeEditor != null) {
            return ((VexEditor)this.activeEditor).getVexWidget();
        }
        return null;
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        page.addSelectionListener(this.selectionListener);
    }

    public void setActiveEditor(IEditorPart activeEditor) {
        if (!(activeEditor instanceof VexEditor)) {
            return;
        }
        this.activeEditor = activeEditor;
        this.setId(this.copyAction, ActionFactory.COPY.getId());
        this.setId(this.cutAction, ActionFactory.CUT.getId());
        this.setId(this.deleteAction, ActionFactory.DELETE.getId());
        this.setId(this.pasteAction, ActionFactory.PASTE.getId());
        this.setId(this.redoAction, ActionFactory.REDO.getId());
        this.setId(this.selectAllAction, ActionFactory.SELECT_ALL.getId());
        this.setId(this.undoAction, ActionFactory.UNDO.getId());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.ui.texteditor.ConstructedEditorMessages");
        FindReplaceAction findAction = new FindReplaceAction(resourceBundle, "Editor.FindReplace.", (IWorkbenchPart)this.activeEditor);
        this.setId((IAction)findAction, ActionFactory.FIND.getId());
        FindNextAction findNextAction = new FindNextAction(resourceBundle, "Editor.FindNext.", (IWorkbenchPart)this.activeEditor, true);
        this.setIds((IAction)findNextAction, "FindNext", "org.eclipse.ui.edit.findNext");
        FindNextAction findPreviousAction = new FindNextAction(resourceBundle, "Editor.FindPrevious.", (IWorkbenchPart)this.activeEditor, false);
        this.setIds((IAction)findPreviousAction, "FindPrevious", "org.eclipse.ui.edit.findPrevious");
        this.enableActions();
    }

    private void setIds(IAction action, String actionId, String commandId) {
        action.setActionDefinitionId(commandId);
        this.setId(action, actionId);
    }

    private void setId(IAction action, String actionId) {
        this.getActionBars().setGlobalActionHandler(actionId, action);
    }

    private void enableActions() {
        VexWidget widget = this.getVexWidget();
        this.copyAction.setEnabled(widget != null && widget.hasSelection());
        this.cutAction.setEnabled(widget != null && widget.hasSelection());
        this.deleteAction.setEnabled(widget != null && widget.hasSelection());
        this.redoAction.setEnabled(widget != null && widget.canRedo());
        this.undoAction.setEnabled(widget != null && widget.canUndo());
    }

    private class CopyAction
    extends Action {
        private CopyAction() {
        }

        public void run() {
            VexActionBarContributor.this.getVexWidget().copySelection();
        }
    }

    private class CutAction
    extends Action {
        private CutAction() {
        }

        public void run() {
            VexActionBarContributor.this.getVexWidget().cutSelection();
        }
    }

    private class DeleteAction
    extends Action {
        private DeleteAction() {
        }

        public void run() {
            VexActionBarContributor.this.getVexWidget().deleteSelection();
        }
    }

    private class PasteAction
    extends Action {
        private PasteAction() {
        }

        public void run() {
            try {
                VexActionBarContributor.this.getVexWidget().paste();
            }
            catch (DocumentValidationException e) {
                e.printStackTrace();
            }
        }
    }

    private class RedoAction
    extends Action {
        private RedoAction() {
        }

        public void run() {
            if (VexActionBarContributor.this.getVexWidget().canRedo()) {
                VexActionBarContributor.this.getVexWidget().redo();
            }
        }
    }

    private class SelectAllAction
    extends Action {
        private SelectAllAction() {
        }

        public void run() {
            VexActionBarContributor.this.getVexWidget().selectAll();
        }
    }

    private class UndoAction
    extends Action {
        private UndoAction() {
        }

        public void run() {
            if (VexActionBarContributor.this.getVexWidget().canUndo()) {
                VexActionBarContributor.this.getVexWidget().undo();
            }
        }
    }
}

