/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.editor;

import org.eclipse.swt.widgets.Shell;
import org.eclipse.vex.core.internal.dom.DocumentContentModel;
import org.eclipse.vex.core.internal.dom.IWhitespacePolicy;
import org.eclipse.vex.core.internal.dom.RootElement;
import org.eclipse.vex.core.internal.widget.CssWhitespacePolicy;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.DocumentType;
import org.eclipse.vex.ui.internal.config.Style;
import org.eclipse.vex.ui.internal.editor.DocumentTypeSelectionDialog;
import org.eclipse.vex.ui.internal.editor.NoRegisteredDoctypeException;
import org.eclipse.vex.ui.internal.editor.NoStyleForDoctypeException;

public class VexDocumentContentModel
extends DocumentContentModel {
    private final Shell shell;
    private DocumentType documentType;
    private Style style;
    private boolean shouldAssignInferredDocumentType;

    public VexDocumentContentModel(Shell shell) {
        this.shell = shell;
    }

    public void initialize(String baseUri, String publicId, String systemId, RootElement rootElement) {
        super.initialize(baseUri, publicId, systemId, rootElement);
        String mainDocumentTypeIdentifier = this.getMainDocumentTypeIdentifier();
        this.documentType = this.getRegisteredDocumentType();
        if (this.documentType == null) {
            this.documentType = this.queryUserForDocumentType();
        }
        if (this.documentType == null) {
            throw new NoRegisteredDoctypeException(mainDocumentTypeIdentifier);
        }
        this.style = VexPlugin.getDefault().getPreferences().getPreferredStyle(this.documentType.getPublicId());
        if (this.style == null) {
            throw new NoStyleForDoctypeException();
        }
    }

    private DocumentType getRegisteredDocumentType() {
        return VexPlugin.getDefault().getConfigurationRegistry().getDocumentType(this.getMainDocumentTypeIdentifier());
    }

    private DocumentType queryUserForDocumentType() {
        DocumentTypeSelectionDialog dialog = DocumentTypeSelectionDialog.create(this.shell, this.getMainDocumentTypeIdentifier());
        dialog.open();
        if (dialog.alwaysUseThisDoctype()) {
            this.shouldAssignInferredDocumentType = true;
        }
        return dialog.getDoctype();
    }

    public IWhitespacePolicy getWhitespacePolicy() {
        if (this.style == null) {
            return super.getWhitespacePolicy();
        }
        return new CssWhitespacePolicy(this.style.getStyleSheet());
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public Style getStyle() {
        return this.style;
    }

    public boolean shouldAssignInferredDocumentType() {
        return this.shouldAssignInferredDocumentType;
    }
}

