/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.editor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.services.ISourceProviderService;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.vex.core.internal.core.ListenerList;
import org.eclipse.vex.core.internal.dom.Document;
import org.eclipse.vex.core.internal.dom.DocumentContentModel;
import org.eclipse.vex.core.internal.dom.DocumentReader;
import org.eclipse.vex.core.internal.dom.DocumentWriter;
import org.eclipse.vex.core.internal.dom.Element;
import org.eclipse.vex.core.internal.dom.IWhitespacePolicy;
import org.eclipse.vex.core.internal.dom.Validator;
import org.eclipse.vex.core.internal.validator.WTPVEXValidator;
import org.eclipse.vex.core.internal.widget.CssWhitespacePolicy;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.VexPreferences;
import org.eclipse.vex.ui.internal.config.ConfigEvent;
import org.eclipse.vex.ui.internal.config.ConfigurationRegistry;
import org.eclipse.vex.ui.internal.config.DocumentType;
import org.eclipse.vex.ui.internal.config.IConfigListener;
import org.eclipse.vex.ui.internal.config.Style;
import org.eclipse.vex.ui.internal.editor.AbstractRegExFindReplaceTarget;
import org.eclipse.vex.ui.internal.editor.DocumentContextSourceProvider;
import org.eclipse.vex.ui.internal.editor.IVexEditorListener;
import org.eclipse.vex.ui.internal.editor.Messages;
import org.eclipse.vex.ui.internal.editor.NoRegisteredDoctypeException;
import org.eclipse.vex.ui.internal.editor.NoStyleForDoctypeException;
import org.eclipse.vex.ui.internal.editor.SelectionProvider;
import org.eclipse.vex.ui.internal.editor.VexDocumentContentModel;
import org.eclipse.vex.ui.internal.editor.VexEditorEvent;
import org.eclipse.vex.ui.internal.outline.DocumentOutlinePage;
import org.eclipse.vex.ui.internal.property.ElementPropertySource;
import org.eclipse.vex.ui.internal.swt.VexWidget;
import org.xml.sax.SAXParseException;

public class VexEditor
extends EditorPart {
    public static final String ID = "org.eclipse.vex.ui.internal.editor.VexEditor";
    private final boolean debugging;
    private final ConfigurationRegistry configurationRegistry;
    private final VexPreferences preferences;
    private Composite parentControl;
    private Label loadingLabel;
    private boolean loaded;
    private DocumentType doctype;
    private Document document;
    private Style style;
    private VexWidget vexWidget;
    private int savedUndoDepth;
    private boolean wasDirty;
    private final ListenerList<IVexEditorListener, VexEditorEvent> vexEditorListeners = new ListenerList(IVexEditorListener.class);
    private final SelectionProvider selectionProvider = new SelectionProvider();
    private final IConfigListener configListener = new IConfigListener(){

        public void configChanged(ConfigEvent e) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (VexEditor.this.style == null) {
                        return;
                    }
                    String styleId = VexEditor.this.style.getUniqueId();
                    Style newStyle = VexEditor.this.configurationRegistry.getStyle(styleId);
                    if (newStyle != null) {
                        VexEditor.this.vexWidget.setStyleSheet(newStyle.getStyleSheet());
                        VexEditor.this.style = newStyle;
                    }
                }
            });
        }

        public void configLoaded(ConfigEvent e) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    VexEditor.this.loadInput();
                }
            });
        }
    };
    private final ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (VexEditor.this.isDirty() != VexEditor.this.wasDirty) {
                VexEditor.this.firePropertyChange(257);
                VexEditor.this.wasDirty = VexEditor.this.isDirty();
            }
            VexEditor.this.setStatus(VexEditor.this.getLocation());
            IEditorSite editorSite = VexEditor.this.getEditorSite();
            IWorkbenchWindow window = editorSite.getWorkbenchWindow();
            if (window instanceof IServiceLocator) {
                IWorkbenchWindow serviceLocator = window;
                ICommandService commandService = (ICommandService)serviceLocator.getService(ICommandService.class);
                commandService.refreshElements("org.eclipse.vex.ui.ConvertElementCommand", null);
                commandService.refreshElements("org.eclipse.vex.ui.RemoveTagCommand", null);
            }
            ISourceProviderService service = (ISourceProviderService)window.getService(ISourceProviderService.class);
            DocumentContextSourceProvider contextProvider = (DocumentContextSourceProvider)service.getSourceProvider("org.eclipse.vex.ui.isColumn");
            contextProvider.fireUpdate(VexEditor.this.vexWidget);
        }
    };
    private final ResourceChangeListener resourceChangeListener = new ResourceChangeListener();

    public VexEditor() {
        this.debugging = VexPlugin.getDefault().isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.vex.ui/debug/layout"));
        this.configurationRegistry = VexPlugin.getDefault().getConfigurationRegistry();
        this.preferences = VexPlugin.getDefault().getPreferences();
    }

    public void addVexEditorListener(IVexEditorListener listener) {
        this.vexEditorListeners.add((Object)listener);
    }

    public void dispose() {
        super.dispose();
        if (this.parentControl != null) {
            this.configurationRegistry.removeConfigListener(this.configListener);
        }
        if (this.getEditorInput() instanceof IFileEditorInput) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        block16: {
            IEditorInput input = this.getEditorInput();
            OutputStream os = null;
            try {
                try {
                    this.resourceChangeListener.setSaving(true);
                    DocumentWriter writer = this.createDocumentWriter();
                    if (input instanceof IFileEditorInput) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        writer.write(this.document, (OutputStream)baos);
                        baos.close();
                        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                        ((IFileEditorInput)input).getFile().setContents((InputStream)bais, false, false, monitor);
                    } else {
                        os = new FileOutputStream(((ILocationProvider)input).getPath((Object)input).toFile());
                        writer.write(this.document, os);
                    }
                    this.savedUndoDepth = this.vexWidget.getUndoDepth();
                    this.firePropertyChange(257);
                }
                catch (Exception ex) {
                    monitor.setCanceled(true);
                    String title = Messages.getString("VexEditor.errorSaving.title");
                    String message = MessageFormat.format(Messages.getString("VexEditor.errorSaving.message"), input.getName(), ex.getMessage());
                    MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)title, (String)message);
                    VexPlugin.getDefault().log(4, message, ex);
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                    this.resourceChangeListener.setSaving(false);
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
                this.resourceChangeListener.setSaving(false);
                throw throwable;
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            this.resourceChangeListener.setSaving(false);
        }
    }

    private DocumentWriter createDocumentWriter() {
        DocumentWriter result = new DocumentWriter();
        result.setWhitespacePolicy((IWhitespacePolicy)new CssWhitespacePolicy(this.style.getStyleSheet()));
        result.setIndent(this.preferences.getIndentationPattern());
        result.setWrapColumn(this.preferences.getLineWidth());
        return result;
    }

    public void doSaveAs() {
        SaveAsDialog dlg = new SaveAsDialog(this.getSite().getShell());
        int result = dlg.open();
        if (result == 0) {
            IPath path = dlg.getResult();
            try {
                try {
                    this.resourceChangeListener.setSaving(true);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DocumentWriter writer = this.createDocumentWriter();
                    writer.write(this.document, (OutputStream)baos);
                    baos.close();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                    file.create((InputStream)bais, false, null);
                    FileEditorInput input = new FileEditorInput(file);
                    this.setInput((IEditorInput)input);
                    this.savedUndoDepth = this.vexWidget.getUndoDepth();
                    this.firePropertyChange(257);
                    this.firePropertyChange(258);
                    this.firePropertyChange(1);
                }
                catch (Exception ex) {
                    String title = Messages.getString("VexEditor.errorSaving.title");
                    String message = MessageFormat.format(Messages.getString("VexEditor.errorSaving.message"), path, ex.getMessage());
                    MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)title, (String)message);
                    VexPlugin.getDefault().log(4, message, ex);
                    this.resourceChangeListener.setSaving(false);
                }
            }
            finally {
                this.resourceChangeListener.setSaving(false);
            }
        }
    }

    public Style getPreferredStyle(String publicId) {
        return this.configurationRegistry.getStyle(publicId, this.preferences.getPreferredStyleId(publicId));
    }

    public DocumentType getDocumentType() {
        return this.doctype;
    }

    public Style getStyle() {
        return this.style;
    }

    public VexWidget getVexWidget() {
        return this.vexWidget;
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.getEditorSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.getEditorSite().getSelectionProvider().addSelectionChangedListener(this.selectionChangedListener);
        if (input instanceof IFileEditorInput) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeListener, 1);
        }
    }

    protected void loadInput() {
        if (this.vexWidget != null) {
            this.vexEditorListeners.fireEvent("documentUnloaded", (EventObject)new VexEditorEvent(this));
        }
        this.loaded = false;
        IEditorInput input = this.getEditorInput();
        try {
            long start = System.currentTimeMillis();
            if (!(input instanceof IFileEditorInput)) {
                String msg = MessageFormat.format(Messages.getString("VexEditor.unknownInputClass"), input.getClass());
                this.showLabel(msg);
                return;
            }
            IFile file = ((IFileEditorInput)input).getFile();
            VexDocumentContentModel documentContentModel = new VexDocumentContentModel(this.getSite().getShell());
            DocumentReader reader = new DocumentReader();
            reader.setDebugging(this.debugging);
            reader.setDocumentContentModel((DocumentContentModel)documentContentModel);
            this.document = reader.read(file.getLocationURI().toURL());
            if (this.debugging) {
                long end = System.currentTimeMillis();
                String message = "Parsed document in " + (end - start) + "ms";
                System.out.println(message);
            }
            if (this.document == null) {
                this.showLabel(MessageFormat.format(Messages.getString("VexEditor.noContent"), file));
                return;
            }
            this.doctype = documentContentModel.getDocumentType();
            this.style = documentContentModel.getStyle();
            WTPVEXValidator validator = new WTPVEXValidator((DocumentContentModel)documentContentModel);
            this.document.setValidator((Validator)validator);
            if (this.debugging) {
                long end = System.currentTimeMillis();
                System.out.println("Got validator in " + (end - start) + "ms");
            }
            this.showVexWidget();
            this.vexWidget.setDebugging(this.debugging);
            this.vexWidget.setDocument(this.document, this.style.getStyleSheet());
            if (documentContentModel.shouldAssignInferredDocumentType()) {
                this.document.setPublicID(this.doctype.getPublicId());
                this.document.setSystemID(this.doctype.getSystemId());
                this.doSave(null);
            }
            this.loaded = true;
            this.savedUndoDepth = this.vexWidget.getUndoDepth();
            this.firePropertyChange(257);
            this.wasDirty = this.isDirty();
            this.vexEditorListeners.fireEvent("documentLoaded", (EventObject)new VexEditorEvent(this));
        }
        catch (SAXParseException ex) {
            if (ex.getException() instanceof NoRegisteredDoctypeException) {
                NoRegisteredDoctypeException ex2 = (NoRegisteredDoctypeException)ex.getException();
                String msg = ex2.getPublicId() == null ? Messages.getString("VexEditor.noDoctype") : MessageFormat.format(Messages.getString("VexEditor.unknownDoctype"), ex2.getPublicId());
                this.showLabel(msg);
            } else if (ex.getException() instanceof NoStyleForDoctypeException) {
                String msg = MessageFormat.format(Messages.getString("VexEditor.noStyles"), this.doctype.getPublicId());
                this.showLabel(msg);
            } else {
                String file = ex.getSystemId();
                if (file == null) {
                    file = input.getName();
                }
                String msg = MessageFormat.format(Messages.getString("VexEditor.parseError"), ex.getLineNumber(), file, ex.getLocalizedMessage());
                this.showLabel(msg);
                VexPlugin.getDefault().log(4, msg, ex);
            }
        }
        catch (Exception ex) {
            String msg = MessageFormat.format(Messages.getString("VexEditor.unexpectedError"), input.getName());
            VexPlugin.getDefault().log(4, msg, ex);
            this.showLabel(msg);
        }
    }

    public boolean isDirty() {
        if (this.vexWidget != null) {
            return this.savedUndoDepth != this.vexWidget.getUndoDepth();
        }
        return false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite parent) {
        this.parentControl = parent;
        this.configurationRegistry.addConfigListener(this.configListener);
        if (this.configurationRegistry.isLoaded()) {
            this.loadInput();
        } else {
            this.showLabel(Messages.getString("VexEditor.loading"));
        }
    }

    public void removeVexEditorListener(IVexEditorListener listener) {
        this.vexEditorListeners.remove((Object)listener);
    }

    public void setFocus() {
        if (this.vexWidget != null) {
            this.vexWidget.setFocus();
            this.setStatus(this.getLocation());
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setPartName(input.getName());
        this.setContentDescription(input.getName());
    }

    public void setStatus(String text) {
        this.getEditorSite().getActionBars().getStatusLineManager().setMessage(text);
    }

    public void setStyle(Style style) {
        this.style = style;
        if (this.vexWidget != null) {
            this.vexWidget.setStyleSheet(style.getStyleSheet());
            this.preferences.setPreferredStyleId(this.document.getPublicID(), style.getUniqueId());
        }
    }

    private void showLabel(String message) {
        if (this.loadingLabel == null) {
            if (this.vexWidget != null) {
                this.vexWidget.dispose();
                this.vexWidget = null;
            }
            this.loadingLabel = new Label(this.parentControl, 64);
        }
        this.loadingLabel.setText(message);
        this.parentControl.layout(true);
    }

    private void showVexWidget() {
        if (this.vexWidget != null) {
            return;
        }
        if (this.loadingLabel != null) {
            this.loadingLabel.dispose();
            this.loadingLabel = null;
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.parentControl.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.vexWidget = new VexWidget(this.parentControl, 512);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.vexWidget.setLayoutData(gd);
        MenuManager menuManager = new MenuManager();
        this.getSite().registerContextMenu("org.eclipse.vex.ui.popup", menuManager, (ISelectionProvider)this.vexWidget);
        this.vexWidget.setMenu(menuManager.createContextMenu((Control)this.vexWidget));
        this.savedUndoDepth = this.vexWidget.getUndoDepth();
        IContextService cs = (IContextService)this.getSite().getService(IContextService.class);
        cs.activateContext("org.eclipse.vex.ui.VexEditorContext");
        this.vexWidget.addSelectionChangedListener(this.selectionProvider);
        this.parentControl.layout(true);
    }

    private void handleResourceChanged(IResourceDelta delta) {
        if (delta.getKind() == 4) {
            if ((delta.getFlags() & 0x100) != 0) {
                this.handleResourceContentChanged();
            }
        } else if (delta.getKind() == 2) {
            if ((delta.getFlags() & 0x2000) != 0) {
                IPath toPath = delta.getMovedToPath();
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(toPath);
                this.setInput((IEditorInput)new FileEditorInput(file));
            } else if (!this.isDirty()) {
                this.getEditorSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.handleResourceDeleted();
            }
        }
    }

    private void handleResourceContentChanged() {
        if (!this.isDirty()) {
            this.loadInput();
        } else {
            String message = MessageFormat.format(Messages.getString("VexEditor.docChanged.message"), this.getEditorInput().getName());
            MessageDialog dlg = new MessageDialog(this.getSite().getShell(), Messages.getString("VexEditor.docChanged.title"), null, message, 3, new String[]{Messages.getString("VexEditor.docChanged.discard"), Messages.getString("VexEditor.docChanged.overwrite")}, 1);
            int result = dlg.open();
            if (result == 0) {
                this.loadInput();
            } else {
                this.doSave(null);
            }
        }
    }

    private void handleResourceDeleted() {
        String message = MessageFormat.format(Messages.getString("VexEditor.docDeleted.message"), this.getEditorInput().getName());
        MessageDialog dlg = new MessageDialog(this.getSite().getShell(), Messages.getString("VexEditor.docDeleted.title"), null, message, 3, new String[]{Messages.getString("VexEditor.docDeleted.discard"), Messages.getString("VexEditor.docDeleted.save")}, 1);
        int result = dlg.open();
        if (result == 0) {
            this.getEditorSite().getPage().closeEditor((IEditorPart)this, false);
        } else {
            this.doSaveAs();
            if (!this.getEditorInput().exists()) {
                this.getEditorSite().getPage().closeEditor((IEditorPart)this, false);
            }
        }
    }

    private String getLocation() {
        ArrayList<String> path = new ArrayList<String>();
        Element element = this.vexWidget.getCurrentElement();
        while (element != null) {
            path.add(element.getPrefixedName());
            element = element.getParent();
        }
        Collections.reverse(path);
        StringBuilder sb = new StringBuilder(path.size() * 15);
        for (String part : path) {
            sb.append("/");
            sb.append(part);
        }
        return sb.toString();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            return new DocumentOutlinePage();
        }
        if (adapter == IPropertySheetPage.class) {
            PropertySheetPage page = new PropertySheetPage();
            page.setPropertySourceProvider(new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    if (object instanceof Element) {
                        IStructuredSelection sel = (IStructuredSelection)VexEditor.this.vexWidget.getSelection();
                        boolean multi = sel != null && sel.size() > 1;
                        Validator validator = VexEditor.this.vexWidget.getDocument().getValidator();
                        return new ElementPropertySource((Element)object, validator, multi);
                    }
                    return null;
                }
            });
            return page;
        }
        if (adapter == IFindReplaceTarget.class) {
            return new AbstractRegExFindReplaceTarget(){

                protected int getSelectionStart() {
                    return VexEditor.this.getVexWidget().getSelectionStart();
                }

                protected int getSelectionEnd() {
                    return VexEditor.this.getVexWidget().getSelectionEnd();
                }

                protected void setSelection(int start, int end) {
                    VexEditor.this.getVexWidget().moveTo(start);
                    VexEditor.this.getVexWidget().moveTo(end, true);
                }

                protected CharSequence getDocument() {
                    return new CharSequence(){

                        public CharSequence subSequence(int start, int end) {
                            return VexEditor.this.document.getRawText(start, end);
                        }

                        public int length() {
                            return VexEditor.this.document.getLength();
                        }

                        public char charAt(int index) {
                            return VexEditor.this.document.getCharacterAt(index);
                        }
                    };
                }

                protected void inDocumentReplaceSelection(CharSequence text) {
                    VexWidget vexWidget = VexEditor.this.getVexWidget();
                    vexWidget.beginWork();
                    try {
                        vexWidget.deleteSelection();
                        vexWidget.insertText(text.toString());
                    }
                    finally {
                        vexWidget.endWork(true);
                    }
                }
            };
        }
        return super.getAdapter(adapter);
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private boolean saving;

        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (this.saving) {
                return;
            }
            IPath path = ((IFileEditorInput)VexEditor.this.getEditorInput()).getFile().getFullPath();
            final IResourceDelta delta = event.getDelta().findMember(path);
            if (delta != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        VexEditor.this.handleResourceChanged(delta);
                    }
                });
            }
        }

        public void setSaving(boolean saving) {
            this.saving = saving;
        }
    }
}

