/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.vex.core.internal.dom.Element;
import org.eclipse.vex.ui.internal.handlers.TableCellCallbackAdapter;
import org.eclipse.vex.ui.internal.handlers.VexHandlerUtil;
import org.eclipse.vex.ui.internal.swt.VexWidget;

public abstract class AbstractAddColumnHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final VexWidget widget = VexHandlerUtil.computeWidget(event);
        widget.doWork(new Runnable(){

            public void run() {
                try {
                    AbstractAddColumnHandler.this.addColumn(widget);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return null;
    }

    private void addColumn(VexWidget widget) throws ExecutionException {
        final int indexToDup = VexHandlerUtil.getCurrentColumnIndex(widget);
        if (indexToDup == -1) {
            return;
        }
        final ArrayList cellsToDup = new ArrayList();
        VexHandlerUtil.iterateTableCells(widget, new TableCellCallbackAdapter(){

            public void onCell(Object row, Object cell, int rowIndex, int cellIndex) {
                if (cellIndex == indexToDup && cell instanceof Element) {
                    cellsToDup.add((Element)cell);
                }
            }
        });
        int finalOffset = -1;
        for (Element element : cellsToDup) {
            if (finalOffset == -1) {
                finalOffset = element.getStartOffset() + 1;
            }
            widget.moveTo(this.addBefore() ? element.getStartOffset() : element.getEndOffset() + 1);
            widget.insertElement(element.clone());
        }
        if (finalOffset != -1) {
            widget.moveTo(finalOffset);
        }
    }

    protected abstract boolean addBefore();
}

