/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.vex.core.internal.dom.Element;
import org.eclipse.vex.ui.internal.handlers.AbstractVexWidgetHandler;
import org.eclipse.vex.ui.internal.handlers.ITableCellCallback;
import org.eclipse.vex.ui.internal.handlers.VexHandlerUtil;
import org.eclipse.vex.ui.internal.swt.VexWidget;

public abstract class AbstractAddRowHandler
extends AbstractVexWidgetHandler {
    public void execute(final VexWidget widget) throws ExecutionException {
        widget.doWork(new Runnable(){

            public void run() {
                AbstractAddRowHandler.this.addRow(widget);
            }
        });
    }

    protected abstract boolean addAbove();

    private void addRow(final VexWidget widget) {
        final ArrayList rowCellsToInsert = new ArrayList();
        VexHandlerUtil.iterateTableCells(widget, new ITableCellCallback(){
            private boolean selectedRow;
            private List<Object> cellsToInsert;

            public void startRow(Object row, int rowIndex) {
                this.selectedRow = VexHandlerUtil.elementOrRangeIsPartiallySelected(widget, row);
                if (this.selectedRow) {
                    this.cellsToInsert = new ArrayList<Object>();
                }
            }

            public void onCell(Object row, Object cell, int rowIndex, int cellIndex) {
                if (this.selectedRow) {
                    this.cellsToInsert.add(cell);
                }
            }

            public void endRow(Object row, int rowIndex) {
                if (this.selectedRow) {
                    rowCellsToInsert.add(new RowCells(row, this.cellsToInsert));
                }
            }
        });
        if (rowCellsToInsert.isEmpty()) {
            return;
        }
        RowCells firstRow = (RowCells)rowCellsToInsert.get(0);
        int outerOffset = VexHandlerUtil.getOuterRange(firstRow.row).getStart();
        Object firstInner = firstRow.cells.isEmpty() ? firstRow.row : firstRow.cells.get(0);
        int innerOffset = VexHandlerUtil.getInnerRange(firstInner).getStart();
        int insertOffset = this.addAbove() ? VexHandlerUtil.getOuterRange(firstRow.row).getStart() : VexHandlerUtil.getOuterRange(((RowCells)rowCellsToInsert.get(rowCellsToInsert.size() - 1)).row).getEnd();
        int finalOffset = insertOffset + innerOffset - outerOffset;
        widget.moveTo(insertOffset);
        for (RowCells rowCells : rowCellsToInsert) {
            if (rowCells.row instanceof Element) {
                widget.insertElement(((Element)rowCells.row).clone());
            }
            for (Object cell : rowCells.cells) {
                if (cell instanceof Element) {
                    widget.insertElement(((Element)cell).clone());
                    widget.moveBy(1);
                    continue;
                }
                widget.insertText(" ");
            }
            if (!(rowCells.row instanceof Element)) continue;
            widget.moveBy(1);
        }
        widget.moveTo(finalOffset);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RowCells {
        private final Object row;
        private final List<Object> cells;

        private RowCells(Object row, List<Object> cells) {
            this.row = row;
            this.cells = cells;
        }
    }
}

