/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.vex.core.internal.core.IntRange;
import org.eclipse.vex.ui.internal.handlers.TableCellCallbackAdapter;
import org.eclipse.vex.ui.internal.handlers.VexHandlerUtil;
import org.eclipse.vex.ui.internal.swt.VexWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMoveColumnHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final VexWidget widget = VexHandlerUtil.computeWidget(event);
        final VexHandlerUtil.RowColumnInfo rcInfo = VexHandlerUtil.getRowColumnInfo(widget);
        if (rcInfo == null || !this.movingPossible(rcInfo)) {
            return null;
        }
        widget.doWork(true, new Runnable(){

            public void run() {
                ArrayList sourceCells = new ArrayList();
                ArrayList targetCells = new ArrayList();
                AbstractMoveColumnHandler.this.computeCells(widget, rcInfo, sourceCells, targetCells);
                AbstractMoveColumnHandler.this.swapCells(widget, sourceCells, targetCells);
            }
        });
        return null;
    }

    protected abstract boolean moveRight();

    private void computeCells(VexWidget widget, final VexHandlerUtil.RowColumnInfo rcInfo, final List<Object> sourceCells, final List<Object> targetCells) {
        VexHandlerUtil.iterateTableCells(widget, new TableCellCallbackAdapter(){
            private Object leftCell;

            public void onCell(Object row, Object cell, int rowIndex, int cellIndex) {
                if (AbstractMoveColumnHandler.this.leftCell(cellIndex, rcInfo.cellIndex)) {
                    this.leftCell = cell;
                } else if (AbstractMoveColumnHandler.this.rightCell(cellIndex, rcInfo.cellIndex)) {
                    sourceCells.add(AbstractMoveColumnHandler.this.moveRight() ? cell : this.leftCell);
                    targetCells.add(AbstractMoveColumnHandler.this.moveRight() ? this.leftCell : cell);
                }
            }
        });
    }

    private void swapCells(final VexWidget widget, List<Object> sourceCells, List<Object> targetCells) {
        int i = sourceCells.size() - 1;
        while (i >= 0) {
            Object source = sourceCells.get(i);
            Object target = targetCells.get(i);
            final IntRange sourceRange = VexHandlerUtil.getOuterRange(source);
            IntRange outerRange = VexHandlerUtil.getOuterRange(target);
            widget.moveTo(this.moveRight() ? outerRange.getStart() : outerRange.getEnd());
            widget.savePosition(new Runnable(){

                public void run() {
                    widget.moveTo(sourceRange.getStart());
                    widget.moveTo(sourceRange.getEnd(), true);
                    widget.cutSelection();
                }
            });
            widget.paste();
            --i;
        }
    }

    protected abstract boolean movingPossible(VexHandlerUtil.RowColumnInfo var1);

    private boolean leftCell(int currentIndex, int sourceIndex) {
        return this.moveRight() ? currentIndex == sourceIndex : currentIndex == sourceIndex - 1;
    }

    private boolean rightCell(int currentIndex, int sourceIndex) {
        return this.moveRight() ? currentIndex == sourceIndex + 1 : currentIndex == sourceIndex;
    }
}

