/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.vex.core.internal.VEXCorePlugin;
import org.eclipse.vex.core.internal.css.Styles;
import org.eclipse.vex.core.internal.dom.Document;
import org.eclipse.vex.core.internal.dom.DocumentFragment;
import org.eclipse.vex.core.internal.dom.Element;
import org.eclipse.vex.core.internal.dom.RootElement;
import org.eclipse.vex.core.internal.widget.IVexWidget;
import org.eclipse.vex.ui.internal.handlers.AbstractVexWidgetHandler;
import org.eclipse.vex.ui.internal.swt.VexWidget;

public class SplitBlockElementHandler
extends AbstractVexWidgetHandler {
    public void execute(VexWidget widget) throws ExecutionException {
        Element element = widget.getCurrentElement();
        Styles styles = widget.getStyleSheet().getStyles(element);
        while (!styles.isBlock()) {
            if ((element = element.getParent()) == null || element instanceof RootElement) {
                return;
            }
            styles = widget.getStyleSheet().getStyles(element);
        }
        this.splitElement(widget, element);
    }

    protected void splitElement(final IVexWidget vexWidget, final Element element) {
        vexWidget.doWork(new Runnable(){

            public void run() {
                Styles styles;
                long start = 0L;
                if (VEXCorePlugin.getInstance().isDebugging()) {
                    start = System.currentTimeMillis();
                }
                if ((styles = vexWidget.getStyleSheet().getStyles(element)).getWhiteSpace().equals("pre")) {
                    Document doc = vexWidget.getDocument();
                    int offset = vexWidget.getCaretOffset();
                    doc.insertText(offset, "\n");
                    vexWidget.moveTo(offset + 1);
                } else {
                    ArrayList<Element> children = new ArrayList<Element>();
                    ArrayList<DocumentFragment> frags = new ArrayList<DocumentFragment>();
                    Element child = vexWidget.getCurrentElement();
                    while (true) {
                        children.add(child);
                        vexWidget.moveTo(child.getEndOffset(), true);
                        frags.add(vexWidget.getSelectedFragment());
                        vexWidget.deleteSelection();
                        vexWidget.moveTo(child.getEndOffset() + 1);
                        if (child == element) break;
                        child = child.getParent();
                    }
                    int i = children.size() - 1;
                    while (i >= 0) {
                        child = (Element)children.get(i);
                        DocumentFragment frag = (DocumentFragment)frags.get(i);
                        vexWidget.insertElement(child.clone());
                        int offset = vexWidget.getCaretOffset();
                        if (frag != null) {
                            vexWidget.insertFragment(frag);
                        }
                        vexWidget.moveTo(offset);
                        --i;
                    }
                }
                if (VEXCorePlugin.getInstance().isDebugging()) {
                    long end = System.currentTimeMillis();
                    System.out.println("split() took " + (end - start) + "ms");
                }
            }
        });
    }
}

