/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.vex.core.internal.core.IntRange;
import org.eclipse.vex.core.internal.css.StyleSheet;
import org.eclipse.vex.core.internal.dom.Document;
import org.eclipse.vex.core.internal.dom.Element;
import org.eclipse.vex.core.internal.dom.Node;
import org.eclipse.vex.core.internal.layout.BlockBox;
import org.eclipse.vex.core.internal.layout.Box;
import org.eclipse.vex.core.internal.layout.ElementOrRangeCallback;
import org.eclipse.vex.core.internal.layout.LayoutUtils;
import org.eclipse.vex.core.internal.layout.TableRowBox;
import org.eclipse.vex.core.internal.widget.IBoxFilter;
import org.eclipse.vex.core.internal.widget.IVexWidget;
import org.eclipse.vex.ui.internal.editor.VexEditor;
import org.eclipse.vex.ui.internal.handlers.ITableCellCallback;
import org.eclipse.vex.ui.internal.handlers.TableCellCallbackAdapter;
import org.eclipse.vex.ui.internal.swt.VexWidget;

public final class VexHandlerUtil {
    public static VexWidget computeWidget(ExecutionEvent event) throws ExecutionException {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        VexHandlerUtil.assertNotNull(activeEditor);
        VexWidget widget = null;
        if (activeEditor instanceof VexEditor) {
            widget = ((VexEditor)activeEditor).getVexWidget();
        }
        VexHandlerUtil.assertNotNull(widget);
        return widget;
    }

    public static VexWidget computeWidget(IWorkbenchWindow window) {
        VexEditor editor = VexHandlerUtil.computeVexEditor(window);
        if (editor == null) {
            return null;
        }
        return editor.getVexWidget();
    }

    public static VexEditor computeVexEditor(IWorkbenchWindow window) {
        IEditorPart activeEditor = window.getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        if (activeEditor instanceof VexEditor) {
            return (VexEditor)activeEditor;
        }
        return null;
    }

    private static void assertNotNull(Object object) throws ExecutionException {
        if (object == null) {
            throw new ExecutionException("Can not compute VexWidget.");
        }
    }

    public static void cloneTableCells(final IVexWidget vexWidget, final TableRowBox tr, final boolean moveToFirstCell) {
        vexWidget.doWork(new Runnable(){

            public void run() {
                int offset = vexWidget.getCaretOffset();
                boolean firstCellIsAnonymous = false;
                Box[] cells = tr.getChildren();
                int i = 0;
                while (i < cells.length) {
                    if (cells[i].isAnonymous()) {
                        vexWidget.insertText(" ");
                        if (i == 0) {
                            firstCellIsAnonymous = true;
                        }
                    } else {
                        vexWidget.insertElement(cells[i].getElement().clone());
                        vexWidget.moveBy(1);
                    }
                    ++i;
                }
                if (moveToFirstCell) {
                    vexWidget.moveTo(offset + 1);
                    if (firstCellIsAnonymous) {
                        vexWidget.moveBy(-1, true);
                    }
                }
            }
        });
    }

    public static void duplicateTableRow(final IVexWidget vexWidget, final TableRowBox tr) {
        vexWidget.doWork(new Runnable(){

            public void run() {
                vexWidget.moveTo(tr.getEndOffset());
                if (!tr.isAnonymous()) {
                    vexWidget.moveBy(1);
                    vexWidget.insertElement(tr.getElement().clone());
                }
                VexHandlerUtil.cloneTableCells(vexWidget, tr, true);
            }
        });
    }

    public static boolean elementOrRangeIsPartiallySelected(IVexWidget vexWidget, Object elementOrRange) {
        IntRange range = VexHandlerUtil.getInnerRange(elementOrRange);
        return range.getEnd() >= vexWidget.getSelectionStart() && range.getStart() <= vexWidget.getSelectionEnd();
    }

    public static int getCurrentColumnIndex(IVexWidget vexWidget) {
        Element row = VexHandlerUtil.getCurrentTableRow(vexWidget);
        if (row == null) {
            return -1;
        }
        final int offset = vexWidget.getCaretOffset();
        final int[] column = new int[]{-1};
        LayoutUtils.iterateTableCells((StyleSheet)vexWidget.getStyleSheet(), (Element)row, (ElementOrRangeCallback)new ElementOrRangeCallback(){
            private int i = 0;

            public void onElement(Element child, String displayStyle) {
                if (offset > child.getStartOffset() && offset <= child.getEndOffset()) {
                    column[0] = this.i;
                }
                ++this.i;
            }

            public void onRange(Element parent, int startOffset, int endOffset) {
                ++this.i;
            }
        });
        return column[0];
    }

    public static Element getCurrentTableRow(IVexWidget vexWidget) {
        StyleSheet ss = vexWidget.getStyleSheet();
        Element element = vexWidget.getCurrentElement();
        while (element != null) {
            if (ss.getStyles(element).getDisplay().equals("table-row")) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    public static int getPreviousSiblingStart(IVexWidget vexWidget) {
        int startOffset;
        if (vexWidget.hasSelection()) {
            startOffset = vexWidget.getSelectionStart();
        } else {
            Box box = vexWidget.findInnermostBox(new IBoxFilter(){

                public boolean matches(Box box) {
                    return box instanceof BlockBox && box.getElement() != null;
                }
            });
            if (box.getElement() == vexWidget.getDocument().getRootElement()) {
                return -1;
            }
            startOffset = box.getElement().getStartOffset();
        }
        int previousSiblingStart = -1;
        Element parent = vexWidget.getDocument().getElementAt(startOffset);
        List children = parent.getChildNodes();
        for (Node child : children) {
            if (startOffset == child.getStartOffset()) break;
            previousSiblingStart = child.getStartOffset();
        }
        return previousSiblingStart;
    }

    public static BlockBox[] getSelectedBlockBoxes(final IVexWidget vexWidget) {
        if (!vexWidget.hasSelection()) {
            return new BlockBox[0];
        }
        Box parent = vexWidget.findInnermostBox(new IBoxFilter(){

            public boolean matches(Box box) {
                System.out.println("Matching " + box);
                return box instanceof BlockBox && box.getStartOffset() <= vexWidget.getSelectionStart() && box.getEndOffset() >= vexWidget.getSelectionEnd();
            }
        });
        System.out.println("Matched " + parent);
        ArrayList<BlockBox> blockList = new ArrayList<BlockBox>();
        Box[] children = parent.getChildren();
        System.out.println("Parent has " + children.length + " children");
        Box[] boxArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Box child = boxArray[n2];
            if (child instanceof BlockBox && child.getStartOffset() >= vexWidget.getSelectionStart() && child.getEndOffset() <= vexWidget.getSelectionEnd()) {
                System.out.println("  adding " + child);
                blockList.add((BlockBox)child);
            } else {
                System.out.println("  skipping " + child);
            }
            ++n2;
        }
        return blockList.toArray(new BlockBox[blockList.size()]);
    }

    public static SelectedRows getSelectedTableRows(final IVexWidget vexWidget) {
        final SelectedRows selected = new SelectedRows();
        VexHandlerUtil.iterateTableCells(vexWidget, new TableCellCallbackAdapter(){

            public void startRow(Object row, int rowIndex) {
                if (VexHandlerUtil.elementOrRangeIsPartiallySelected(vexWidget, row)) {
                    if (selected.rows == null) {
                        selected.rows = new ArrayList();
                    }
                    selected.rows.add(row);
                } else if (selected.rows == null) {
                    selected.rowBefore = row;
                } else if (selected.rowAfter == null) {
                    selected.rowAfter = row;
                }
            }
        });
        return selected;
    }

    public static void iterateTableCells(IVexWidget vexWidget, final ITableCellCallback callback) {
        final StyleSheet ss = vexWidget.getStyleSheet();
        VexHandlerUtil.iterateTableRows(vexWidget, new ElementOrRangeCallback(){
            private final int[] rowIndex = new int[1];

            public void onElement(final Element row, String displayStyle) {
                callback.startRow(row, this.rowIndex[0]);
                LayoutUtils.iterateTableCells((StyleSheet)ss, (Element)row, (ElementOrRangeCallback)new ElementOrRangeCallback(){
                    private int cellIndex = 0;

                    public void onElement(Element cell, String displayStyle) {
                        callback.onCell(row, cell, rowIndex[0], this.cellIndex);
                        ++this.cellIndex;
                    }

                    public void onRange(Element parent, int startOffset, int endOffset) {
                        callback.onCell(row, new IntRange(startOffset, endOffset), rowIndex[0], this.cellIndex);
                        ++this.cellIndex;
                    }
                });
                callback.endRow(row, this.rowIndex[0]);
                this.rowIndex[0] = this.rowIndex[0] + 1;
            }

            public void onRange(Element parent, int startOffset, int endOffset) {
                final IntRange row = new IntRange(startOffset, endOffset);
                callback.startRow(row, this.rowIndex[0]);
                LayoutUtils.iterateTableCells((StyleSheet)ss, (Element)parent, (int)startOffset, (int)endOffset, (ElementOrRangeCallback)new ElementOrRangeCallback(){
                    private int cellIndex = 0;

                    public void onElement(Element cell, String displayStyle) {
                        callback.onCell(row, cell, rowIndex[0], this.cellIndex);
                        ++this.cellIndex;
                    }

                    public void onRange(Element parent, int startOffset, int endOffset) {
                        callback.onCell(row, new IntRange(startOffset, endOffset), rowIndex[0], this.cellIndex);
                        ++this.cellIndex;
                    }
                });
                callback.endRow(row, this.rowIndex[0]);
                this.rowIndex[0] = this.rowIndex[0] + 1;
            }
        });
    }

    public static RowColumnInfo getRowColumnInfo(IVexWidget vexWidget) {
        final boolean[] found = new boolean[1];
        final RowColumnInfo[] rcInfo = new RowColumnInfo[]{new RowColumnInfo()};
        final int offset = vexWidget.getCaretOffset();
        rcInfo[0].cellIndex = -1;
        rcInfo[0].rowIndex = -1;
        VexHandlerUtil.iterateTableCells(vexWidget, new ITableCellCallback(){
            private int rowColumnCount;

            public void startRow(Object row, int rowIndex) {
                this.rowColumnCount = 0;
            }

            public void onCell(Object row, Object cell, int rowIndex, int cellIndex) {
                found[0] = true;
                if (LayoutUtils.elementOrRangeContains((Object)row, (int)offset)) {
                    rcInfo[0].row = row;
                    rcInfo[0].rowIndex = rowIndex;
                    ++rcInfo[0].columnCount;
                    if (LayoutUtils.elementOrRangeContains((Object)cell, (int)offset)) {
                        rcInfo[0].cell = cell;
                        rcInfo[0].cellIndex = cellIndex;
                    }
                }
                ++this.rowColumnCount;
            }

            public void endRow(Object row, int rowIndex) {
                ++rcInfo[0].rowCount;
                rcInfo[0].maxColumnCount = Math.max(rcInfo[0].maxColumnCount, this.rowColumnCount);
            }
        });
        if (found[0]) {
            return rcInfo[0];
        }
        return null;
    }

    public static void iterateTableRows(IVexWidget vexWidget, ElementOrRangeCallback callback) {
        StyleSheet ss = vexWidget.getStyleSheet();
        Document doc = vexWidget.getDocument();
        final int offset = vexWidget.getCaretOffset();
        Element table = doc.getElementAt(offset);
        while (table != null && !LayoutUtils.isTableChild((StyleSheet)ss, (Element)table)) {
            table = table.getParent();
        }
        while (table != null && LayoutUtils.isTableChild((StyleSheet)ss, (Element)table)) {
            table = table.getParent();
        }
        if (table == null || table.getParent() == null) {
            return;
        }
        final ArrayList tableChildren = new ArrayList();
        final boolean[] found = new boolean[1];
        LayoutUtils.iterateChildrenByDisplayStyle((StyleSheet)ss, (Set)LayoutUtils.TABLE_CHILD_STYLES, (Element)table, (ElementOrRangeCallback)new ElementOrRangeCallback(){

            public void onElement(Element child, String displayStyle) {
                if (offset >= child.getStartOffset() && offset <= child.getEndOffset()) {
                    found[0] = true;
                }
                tableChildren.add(child);
            }

            public void onRange(Element parent, int startOffset, int endOffset) {
                if (!found[0]) {
                    tableChildren.clear();
                }
            }
        });
        if (!found[0]) {
            return;
        }
        int startOffset = ((Element)tableChildren.get(0)).getStartOffset();
        int endOffset = ((Element)tableChildren.get(tableChildren.size() - 1)).getEndOffset() + 1;
        LayoutUtils.iterateTableRows((StyleSheet)ss, (Element)table, (int)startOffset, (int)endOffset, (ElementOrRangeCallback)callback);
    }

    public static IntRange getInnerRange(Object elementOrRange) {
        if (elementOrRange instanceof Element) {
            Element element = (Element)elementOrRange;
            return new IntRange(element.getStartOffset() + 1, element.getEndOffset());
        }
        return (IntRange)elementOrRange;
    }

    public static IntRange getOuterRange(Object elementOrRange) {
        if (elementOrRange instanceof Element) {
            Element element = (Element)elementOrRange;
            return new IntRange(element.getStartOffset(), element.getEndOffset() + 1);
        }
        return (IntRange)elementOrRange;
    }

    public static class RowColumnInfo {
        public Object row;
        public Object cell;
        public int rowIndex;
        public int cellIndex;
        public int rowCount;
        public int columnCount;
        public int maxColumnCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectedRows {
        private List<Object> rows;
        private Object rowBefore;
        private Object rowAfter;

        private SelectedRows() {
        }

        public List<Object> getRows() {
            return this.rows;
        }

        public Object getRowBefore() {
            return this.rowBefore;
        }

        public Object getRowAfter() {
            return this.rowAfter;
        }
    }
}

