/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.namespace;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.vex.core.internal.dom.Element;
import org.eclipse.vex.ui.internal.namespace.EditableNamespaceDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditNamespacesController {
    private final Element element;
    private String defaultNamespaceURI;
    private final List<EditableNamespaceDefinition> namespaceDefinitions;

    public EditNamespacesController(Element element) {
        this.element = element;
        this.defaultNamespaceURI = EditNamespacesController.getDefaultNamespaceURI(element);
        this.namespaceDefinitions = EditNamespacesController.getNamespaceDefinitions(element);
    }

    private static String getDefaultNamespaceURI(Element element) {
        String result = element.getDeclaredDefaultNamespaceURI();
        if (result == null) {
            return "";
        }
        return result;
    }

    private static List<EditableNamespaceDefinition> getNamespaceDefinitions(Element element) {
        ArrayList<EditableNamespaceDefinition> result = new ArrayList<EditableNamespaceDefinition>();
        for (String prefix : element.getDeclaredNamespacePrefixes()) {
            result.add(new EditableNamespaceDefinition(prefix, element.getNamespaceURI(prefix)));
        }
        return result;
    }

    public String getDefaultNamespaceURI() {
        return this.defaultNamespaceURI;
    }

    public void setDefaultNamespaceURI(String defaultNamespaceURI) {
        this.defaultNamespaceURI = defaultNamespaceURI;
    }

    public List<EditableNamespaceDefinition> getNamespaceDefinitions() {
        return this.namespaceDefinitions;
    }

    public EditableNamespaceDefinition addNamespaceDefinition() {
        EditableNamespaceDefinition result = new EditableNamespaceDefinition();
        this.namespaceDefinitions.add(result);
        return result;
    }

    public void removeNamespaceDefinition(EditableNamespaceDefinition namespaceDefinition) {
        this.namespaceDefinitions.remove(namespaceDefinition);
    }

    public void applyToElement() {
        if (this.defaultNamespaceURI == null || "".equals(this.defaultNamespaceURI)) {
            this.element.removeDefaultNamespace();
        } else {
            this.element.declareDefaultNamespace(this.defaultNamespaceURI);
        }
        HashSet<String> declaredPrefixes = new HashSet<String>();
        for (EditableNamespaceDefinition definition : this.namespaceDefinitions) {
            this.element.declareNamespace(definition.getPrefix(), definition.getUri());
            declaredPrefixes.add(definition.getPrefix());
        }
        for (String prefix : this.element.getDeclaredNamespacePrefixes()) {
            if (declaredPrefixes.contains(prefix)) continue;
            this.element.removeNamespace(prefix);
        }
    }
}

