/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.namespace;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.vex.ui.internal.namespace.EditNamespacesController;
import org.eclipse.vex.ui.internal.namespace.EditableNamespaceDefinition;

public class EditNamespacesDialog
extends TitleAreaDialog {
    private final EditNamespacesController controller;
    private Text defaultNamespaceText;
    private TableViewer namespacesTable;

    public EditNamespacesDialog(Shell parentShell, EditNamespacesController controller) {
        super(parentShell);
        this.controller = controller;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit Namespaces");
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(shellSize.x, Math.max(this.convertVerticalDLUsToPixels(200), shellSize.y));
    }

    protected Control createContents(Composite parent) {
        Composite result = (Composite)super.createContents(parent);
        this.setTitle("Edit Namespaces");
        this.setMessage("Edit the namespaces of the selected element.");
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite superRoot = (Composite)super.createDialogArea(parent);
        Composite root = new Composite(superRoot, 0);
        root.setLayoutData((Object)new GridData(4, 4, true, true));
        root.setLayout((Layout)new GridLayout(2, false));
        Label defaultNamespaceLabel = new Label(root, 0);
        defaultNamespaceLabel.setText("Default Namespace");
        defaultNamespaceLabel.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.defaultNamespaceText = new Text(root, 2052);
        this.defaultNamespaceText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.defaultNamespaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditNamespacesDialog.this.controller.setDefaultNamespaceURI(EditNamespacesDialog.this.defaultNamespaceText.getText());
            }
        });
        new Label(root, 0);
        Label namespaceTableLabel = new Label(root, 0);
        namespaceTableLabel.setText("Other Namespaces");
        namespaceTableLabel.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite tableRoot = new Composite(root, 0);
        tableRoot.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableRoot.setLayout((Layout)tableColumnLayout);
        this.namespacesTable = new TableViewer(tableRoot, 67584);
        this.namespacesTable.getTable().setHeaderVisible(true);
        this.namespacesTable.getTable().setLinesVisible(true);
        this.namespacesTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn prefixColumn = new TableViewerColumn(this.namespacesTable, 0);
        prefixColumn.getColumn().setText("Prefix");
        prefixColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(((EditableNamespaceDefinition)cell.getElement()).getPrefix());
            }
        });
        prefixColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.namespacesTable){

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)EditNamespacesDialog.this.namespacesTable.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return ((EditableNamespaceDefinition)element).getPrefix();
            }

            protected void setValue(Object element, Object value) {
                if (value != null) {
                    ((EditableNamespaceDefinition)element).setPrefix(value.toString());
                } else {
                    ((EditableNamespaceDefinition)element).setPrefix("");
                }
                EditNamespacesDialog.this.namespacesTable.refresh(element);
            }
        });
        TableViewerColumn uriColumn = new TableViewerColumn(this.namespacesTable, 0);
        uriColumn.getColumn().setText("URI");
        uriColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(((EditableNamespaceDefinition)cell.getElement()).getUri());
            }
        });
        uriColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.namespacesTable){

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)EditNamespacesDialog.this.namespacesTable.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return ((EditableNamespaceDefinition)element).getUri();
            }

            protected void setValue(Object element, Object value) {
                if (value != null) {
                    ((EditableNamespaceDefinition)element).setUri(value.toString());
                } else {
                    ((EditableNamespaceDefinition)element).setUri("");
                }
                EditNamespacesDialog.this.namespacesTable.refresh(element);
            }
        });
        tableColumnLayout.setColumnData((Widget)prefixColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 100, true));
        tableColumnLayout.setColumnData((Widget)uriColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(3, 100, true));
        Button addNamespaceButton = new Button(root, 8);
        addNamespaceButton.setText("Add");
        addNamespaceButton.setLayoutData((Object)new GridData(4, 4, false, false));
        addNamespaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditNamespacesDialog.this.addNamespacePressed();
            }
        });
        Button removeNamespaceButton = new Button(root, 8);
        removeNamespaceButton.setText("Remove");
        removeNamespaceButton.setLayoutData((Object)new GridData(4, 4, false, false));
        removeNamespaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditNamespacesDialog.this.removeNamespacePressed();
            }
        });
        this.populateFromController();
        return superRoot;
    }

    private void populateFromController() {
        this.defaultNamespaceText.setText(this.controller.getDefaultNamespaceURI());
        this.namespacesTable.setInput(this.controller.getNamespaceDefinitions());
    }

    private void addNamespacePressed() {
        EditableNamespaceDefinition newDefinition = this.controller.addNamespaceDefinition();
        this.namespacesTable.refresh();
        this.namespacesTable.setSelection((ISelection)new StructuredSelection((Object)newDefinition), true);
    }

    private void removeNamespacePressed() {
        IStructuredSelection selection = (IStructuredSelection)this.namespacesTable.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        EditableNamespaceDefinition selectedDefinition = (EditableNamespaceDefinition)selection.getFirstElement();
        this.controller.removeNamespaceDefinition(selectedDefinition);
        this.namespacesTable.refresh();
    }
}

