/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.outline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.vex.core.internal.css.StyleSheet;
import org.eclipse.vex.core.internal.dom.Document;
import org.eclipse.vex.core.internal.dom.Element;
import org.eclipse.vex.core.internal.dom.IWhitespacePolicy;
import org.eclipse.vex.core.internal.widget.CssWhitespacePolicy;
import org.eclipse.vex.ui.internal.editor.VexEditor;
import org.eclipse.vex.ui.internal.outline.IOutlineProvider;

public class DefaultOutlineProvider
implements IOutlineProvider {
    private IWhitespacePolicy whitespacePolicy;
    private ITreeContentProvider contentProvider;
    private IBaseLabelProvider labelProvider;

    public void init(VexEditor editor) {
        StyleSheet ss = editor.getVexWidget().getStyleSheet();
        this.whitespacePolicy = new CssWhitespacePolicy(ss);
        this.contentProvider = new ContentProvider();
        this.labelProvider = new LabelProvider(){

            public String getText(Object o) {
                Element e = (Element)o;
                String s = e.getText();
                if (s.length() > 30) {
                    s = String.valueOf(s.substring(0, 30)) + "...";
                }
                return String.valueOf(e.getPrefixedName()) + ": " + s;
            }
        };
    }

    public ITreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public IBaseLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public Element getOutlineElement(Element child) {
        Element element = child;
        while (element != null) {
            if (this.whitespacePolicy.isBlock(element)) {
                return element;
            }
            Element parent = element.getParent();
            if (parent == null) {
                return element;
            }
            element = parent;
        }
        return element;
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<Element> blockChildren = new ArrayList<Element>();
            List children = ((Element)parentElement).getChildElements();
            for (Element child : children) {
                if (!DefaultOutlineProvider.this.whitespacePolicy.isBlock(child)) continue;
                blockChildren.add(child);
            }
            return blockChildren.toArray();
        }

        public Object getParent(Object element) {
            return ((Element)element).getParent();
        }

        public boolean hasChildren(Object o) {
            return this.hasBlockChild((Element)o);
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{((Document)inputElement).getRootElement()};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        private boolean hasBlockChild(Element element) {
            for (Element child : element.getChildElements()) {
                if (!DefaultOutlineProvider.this.whitespacePolicy.isBlock(child)) continue;
                return true;
            }
            return false;
        }
    }
}

