/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.outline;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.vex.core.internal.dom.Element;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.DocumentType;
import org.eclipse.vex.ui.internal.editor.IVexEditorListener;
import org.eclipse.vex.ui.internal.editor.Messages;
import org.eclipse.vex.ui.internal.editor.SelectionProvider;
import org.eclipse.vex.ui.internal.editor.VexEditor;
import org.eclipse.vex.ui.internal.editor.VexEditorEvent;
import org.eclipse.vex.ui.internal.outline.DefaultOutlineProvider;
import org.eclipse.vex.ui.internal.outline.IOutlineProvider;
import org.eclipse.vex.ui.internal.swt.VexWidget;
import org.osgi.framework.Bundle;

public class DocumentOutlinePage
extends Page
implements IContentOutlinePage {
    private Composite composite;
    private Label label;
    private TreeViewer treeViewer;
    private VexEditor vexEditor;
    private IOutlineProvider outlineProvider;
    private final SelectionProvider selectionProvider = new SelectionProvider();
    private final ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSource() instanceof VexWidget) {
                VexWidget vexWidget = (VexWidget)((Object)event.getSource());
                if (vexWidget.isFocusControl() && DocumentOutlinePage.this.getTreeViewer() != null) {
                    Element element = vexWidget.getCurrentElement();
                    Element outlineElement = DocumentOutlinePage.this.outlineProvider.getOutlineElement(element);
                    DocumentOutlinePage.this.getTreeViewer().refresh((Object)outlineElement);
                    DocumentOutlinePage.this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)outlineElement), true);
                }
            } else {
                TreeItem[] selected;
                TreeViewer treeViewer = (TreeViewer)event.getSource();
                if (treeViewer.getTree().isFocusControl() && (selected = treeViewer.getTree().getSelection()).length > 0) {
                    Element element = (Element)selected[0].getData();
                    VexWidget vexWidget = DocumentOutlinePage.this.vexEditor.getVexWidget();
                    vexWidget.moveTo(element.getEndOffset());
                    vexWidget.moveTo(element.getStartOffset() + 1);
                }
            }
        }
    };
    private final IVexEditorListener vexEditorListener = new IVexEditorListener(){

        public void documentLoaded(VexEditorEvent event) {
            DocumentOutlinePage.this.showTreeViewer();
        }

        public void documentUnloaded(VexEditorEvent event) {
            DocumentOutlinePage.this.showLabel(Messages.getString("DocumentOutlinePage.reloading"));
        }
    };

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new FillLayout());
        if (this.vexEditor.isLoaded()) {
            this.showTreeViewer();
        } else {
            this.showLabel(Messages.getString("DocumentOutlinePage.loading"));
        }
    }

    public void dispose() {
        this.vexEditor.removeVexEditorListener(this.vexEditorListener);
        this.vexEditor.getEditorSite().getSelectionProvider().removeSelectionChangedListener(this.selectionListener);
    }

    public Control getControl() {
        return this.composite;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        IEditorPart editor = pageSite.getPage().getActiveEditor();
        if (editor instanceof VexEditor) {
            this.vexEditor = (VexEditor)editor;
        }
        this.vexEditor.addVexEditorListener(this.vexEditorListener);
        this.vexEditor.getEditorSite().getSelectionProvider().addSelectionChangedListener(this.selectionListener);
    }

    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getControl().setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.selectionProvider.getSelection();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.selectionProvider.setSelection(selection);
    }

    private void showLabel(String message) {
        if (this.treeViewer != null) {
            this.treeViewer.removeSelectionChangedListener(this.selectionListener);
            this.treeViewer.getTree().dispose();
            this.treeViewer = null;
        }
        if (this.label == null) {
            this.label = new Label(this.composite, 0);
            this.label.setText(message);
            this.composite.layout(true);
        }
        this.label.setText(message);
    }

    private void showTreeViewer() {
        if (this.treeViewer != null) {
            return;
        }
        if (this.label != null) {
            this.label.dispose();
            this.label = null;
        }
        this.treeViewer = new TreeViewer(this.composite, 0);
        this.composite.layout();
        DocumentType doctype = this.vexEditor.getDocumentType();
        if (doctype == null) {
            return;
        }
        String ns = doctype.getConfig().getUniqueIdentifer();
        Bundle bundle = Platform.getBundle((String)ns);
        String providerClassName = doctype.getOutlineProvider();
        if (bundle != null && providerClassName != null) {
            try {
                Class clazz = bundle.loadClass(providerClassName);
                this.outlineProvider = (IOutlineProvider)clazz.newInstance();
            }
            catch (Exception ex) {
                String message = Messages.getString("DocumentOutlinePage.loadingError");
                VexPlugin.getDefault().log(2, MessageFormat.format(message, providerClassName, ns, ex));
            }
        }
        if (this.outlineProvider == null) {
            this.outlineProvider = new DefaultOutlineProvider();
        }
        this.outlineProvider.init(this.vexEditor);
        this.treeViewer.setContentProvider((IContentProvider)this.outlineProvider.getContentProvider());
        this.treeViewer.setLabelProvider(this.outlineProvider.getLabelProvider());
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.setInput((Object)this.vexEditor.getVexWidget().getDocument());
        this.treeViewer.addSelectionChangedListener(this.selectionListener);
    }
}

