/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.swt;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vex.core.internal.core.ElementName;
import org.eclipse.vex.core.internal.dom.Element;
import org.eclipse.vex.ui.internal.Icon;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.editor.Messages;
import org.eclipse.vex.ui.internal.swt.VexWidget;

public class ContentAssist
extends PopupDialog {
    private static final String SETTINGS_SECTION = "contentAssistant";
    private final VexWidget vexWidget;
    private final AbstractVexAction[] actions;
    private final boolean autoExecute;
    private final Point location;
    private Text textWidget;
    private TableViewer viewer;
    private Font boldFont;

    private ContentAssist(VexWidget vexWidget, AbstractVexAction[] actions, boolean autoExecute) {
        super(vexWidget.getShell(), 16, true, false, false, false, false, null, null);
        this.vexWidget = vexWidget;
        this.actions = actions;
        this.autoExecute = autoExecute;
        this.location = vexWidget.toDisplay(vexWidget.getLocationForContentAssist());
    }

    public int open() {
        if (this.autoExecute && this.actions.length == 1) {
            this.actions[0].execute(this.vexWidget);
            return 0;
        }
        return super.open();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings root = VexPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = root.getSection(SETTINGS_SECTION);
        if (settings == null) {
            settings = root.addNewSection(SETTINGS_SECTION);
        }
        return settings;
    }

    protected Color getForeground() {
        return JFaceResources.getColorRegistry().get("CONTENT_ASSIST_FOREGROUND_COLOR");
    }

    protected Color getBackground() {
        return JFaceResources.getColorRegistry().get("CONTENT_ASSIST_BACKGROUND_COLOR");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 4, 0).applyTo(composite);
        this.textWidget = new Text(composite, 4);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.textWidget);
        this.textWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ContentAssist.this.repopulateList();
            }
        });
        this.textWidget.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    ContentAssist.this.doAction();
                } else if (e.widget == ContentAssist.this.textWidget && e.keyCode == 0x1000002) {
                    ContentAssist.this.viewer.getControl().setFocus();
                }
            }
        });
        Label separator = new Label(composite, 259);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)separator);
        this.viewer = new TableViewer(composite, 768);
        Control viewerControl = this.viewer.getControl();
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 300).applyTo(viewerControl);
        this.boldFont = ContentAssist.getModifiedFont(viewerControl.getFont(), 1);
        this.viewer.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ContentAssist.this.doAction();
            }
        });
        this.viewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    ContentAssist.this.doAction();
                }
            }
        });
        this.repopulateList();
        return composite;
    }

    protected Point getDefaultLocation(Point initialSize) {
        return this.location;
    }

    public boolean close() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        return super.close();
    }

    private void doAction() {
        Object first;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof StructuredSelection && (first = ((StructuredSelection)selection).getFirstElement()) instanceof AbstractVexAction) {
            ((AbstractVexAction)first).execute(this.vexWidget);
        }
        this.close();
    }

    private void repopulateList() {
        final String filterText = this.textWidget.getText().toLowerCase();
        LinkedList<AbstractVexAction> actionList = new LinkedList<AbstractVexAction>();
        AbstractVexAction[] abstractVexActionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractVexAction action = abstractVexActionArray[n2];
            if (action.getText().toLowerCase().contains(filterText)) {
                actionList.add(action);
            }
            ++n2;
        }
        if (filterText.length() > 0) {
            Collections.sort(actionList, new Comparator<AbstractVexAction>(){

                @Override
                public int compare(AbstractVexAction action1, AbstractVexAction action2) {
                    String actionText1 = action1.getElementName().getLocalName().toLowerCase();
                    String actionText2 = action2.getElementName().getLocalName().toLowerCase();
                    if (!actionText1.startsWith(filterText) && !actionText2.startsWith(filterText)) {
                        return 0;
                    }
                    return actionText1.startsWith(filterText) ? -1 : 1;
                }
            });
        }
        this.viewer.setInput((Object)actionList.toArray(new AbstractVexAction[actionList.size()]));
        this.viewer.getTable().setSelection(0);
    }

    public static void openAddElementsContentAssist(VexWidget widget) {
        AbstractVexAction[] addActions = ContentAssist.computeAddElementsActions(widget);
        ContentAssist assist = new ContentAssist(widget, addActions, true);
        assist.open();
    }

    public static void openQuickFixContentAssist(VexWidget widget) {
        AbstractVexAction[] quickFixActions = ContentAssist.computeQuickFixActions(widget);
        ContentAssist assist = new ContentAssist(widget, quickFixActions, true);
        assist.open();
    }

    private static AbstractVexAction[] computeAddElementsActions(VexWidget widget) {
        ElementName[] names = widget.getValidInsertElements();
        AbstractVexAction[] actions = new AbstractVexAction[names.length];
        int i = 0;
        while (i < names.length) {
            final QualifiedName qualifiedName = names[i].getQualifiedName();
            actions[i] = new AbstractVexAction(widget, names[i], names[i].toString(), Icon.ELEMENT){

                public void execute(VexWidget vexWidget) {
                    this.getWidget().insertElement(new Element(qualifiedName));
                }
            };
            ++i;
        }
        return actions;
    }

    private static AbstractVexAction[] computeQuickFixActions(VexWidget widget) {
        ElementName[] names = widget.getValidMorphElements();
        AbstractVexAction[] actions = new AbstractVexAction[names.length];
        int caretOffset = widget.getCaretOffset();
        Element element = widget.getDocument().getElementAt(caretOffset);
        String sourceName = element.getPrefixedName();
        int i = 0;
        while (i < names.length) {
            final QualifiedName qualifiedName = names[i].getQualifiedName();
            String message = Messages.getString("command.convertElement.dynamicCommandName");
            String text = MessageFormat.format(message, sourceName, names[i]);
            Icon icon = Icon.CONVERT;
            actions[i] = new AbstractVexAction(widget, names[i], text, icon){

                public void execute(VexWidget vexWidget) {
                    this.getWidget().morph(new Element(qualifiedName));
                }
            };
            ++i;
        }
        return actions;
    }

    private static Font getModifiedFont(Font baseFont, int additionalStyle) {
        FontData[] baseData = baseFont.getFontData();
        FontData[] styleData = new FontData[baseData.length];
        int i = 0;
        while (i < styleData.length) {
            FontData data = baseData[i];
            styleData[i] = new FontData(data.getName(), data.getHeight(), data.getStyle() | additionalStyle);
            ++i;
        }
        return new Font((Device)Display.getCurrent(), styleData);
    }

    private static abstract class AbstractVexAction {
        private final VexWidget widget;
        private final ElementName elementName;
        private final String text;
        private final Icon image;

        public AbstractVexAction(VexWidget widget, ElementName elementName, String text, Icon image) {
            this.widget = widget;
            this.elementName = elementName;
            this.text = text;
            this.image = image;
        }

        abstract void execute(VexWidget var1);

        public VexWidget getWidget() {
            return this.widget;
        }

        public ElementName getElementName() {
            return this.elementName;
        }

        public String getText() {
            return this.text;
        }

        public Icon getImage() {
            return this.image;
        }
    }

    private class MyLabelProvider
    extends StyledCellLabelProvider {
        private final StyledString.Styler boldStyler = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.font = ContentAssist.this.boldFont;
            }
        };

        private MyLabelProvider() {
        }

        public void update(ViewerCell cell) {
            AbstractVexAction action = (AbstractVexAction)cell.getElement();
            String filterText = ContentAssist.this.textWidget.getText();
            String text = action.getText();
            StyledString styledString = new StyledString(action.getText());
            if (text.contains(filterText)) {
                int start = text.indexOf(filterText);
                int end = start + filterText.length();
                styledString = new StyledString(text.substring(0, start));
                styledString.append(text.substring(start, end), this.boldStyler);
                styledString.append(text.substring(end));
            }
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(Icon.get(action.getImage()));
            super.update(cell);
        }
    }
}

