/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.swt;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.vex.core.internal.core.ColorResource;
import org.eclipse.vex.core.internal.core.FontMetrics;
import org.eclipse.vex.core.internal.core.FontResource;
import org.eclipse.vex.core.internal.core.FontSpec;
import org.eclipse.vex.core.internal.core.Graphics;
import org.eclipse.vex.core.internal.core.Image;
import org.eclipse.vex.core.internal.core.Rectangle;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.swt.SwtColor;
import org.eclipse.vex.ui.internal.swt.SwtFont;
import org.eclipse.vex.ui.internal.swt.SwtFontMetrics;
import org.eclipse.vex.ui.internal.swt.SwtImage;

public class SwtGraphics
implements Graphics {
    private final GC gc;
    private int originX;
    private int originY;
    private int lineStyle = 0;

    public SwtGraphics(GC gc) {
        this.gc = gc;
    }

    public void dispose() {
        this.gc.dispose();
    }

    public void drawChars(char[] chars, int offset, int length, int x, int y) {
        this.drawString(new String(chars, offset, length), x, y);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.gc.drawLine(x1 + this.originX, y1 + this.originY, x2 + this.originX, y2 + this.originY);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.gc.drawOval(x + this.originX, y + this.originY, width, height);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.gc.drawRectangle(x + this.originX, y + this.originY, width, height);
    }

    public void drawString(String s, int x, int y) {
        this.gc.drawString(s, x + this.originX, y + this.originY, true);
    }

    public void drawImage(Image image, int x, int y, int width, int height) {
        Assert.isTrue((boolean)(image instanceof SwtImage));
        org.eclipse.swt.graphics.Image swtImage = new org.eclipse.swt.graphics.Image(this.gc.getDevice(), ((SwtImage)image).imageData);
        try {
            this.gc.drawImage(swtImage, 0, 0, image.getWidth(), image.getHeight(), x + this.originX, y + this.originY, width, height);
        }
        finally {
            swtImage.dispose();
        }
    }

    public void fillOval(int x, int y, int width, int height) {
        this.gc.fillOval(x + this.originX, y + this.originY, width, height);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.gc.fillRectangle(x + this.originX, y + this.originY, width, height);
    }

    public Rectangle getClipBounds() {
        org.eclipse.swt.graphics.Rectangle r = this.gc.getClipping();
        return new Rectangle(r.x - this.originX, r.y - this.originY, r.width, r.height);
    }

    public ColorResource getColor() {
        return new SwtColor(this.gc.getForeground());
    }

    public FontResource getFont() {
        return new SwtFont(this.gc.getFont());
    }

    public FontMetrics getFontMetrics() {
        return new SwtFontMetrics(this.gc.getFontMetrics());
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public int getLineWidth() {
        return this.gc.getLineWidth();
    }

    public Image getImage(URL url) {
        ImageData[] imageData = SwtGraphics.loadImageData(url);
        if (imageData != null && imageData.length > 0) {
            return new SwtImage(imageData[0]);
        }
        return new SwtImage(Display.getDefault().getSystemImage(1).getImageData());
    }

    private static ImageData[] loadImageData(URL url) {
        ImageData[] imageDataArray;
        ImageLoader imageLoader = new ImageLoader();
        InputStream in = url.openStream();
        try {
            imageDataArray = imageLoader.load(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                VexPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.vex.ui", MessageFormat.format("Cannot load image from url: {0}", url), (Throwable)e));
                return null;
            }
        }
        in.close();
        return imageDataArray;
    }

    public boolean isAntiAliased() {
        return false;
    }

    public void setAntiAliased(boolean antiAliased) {
    }

    public ColorResource setColor(ColorResource color) {
        ColorResource oldColor = this.getColor();
        this.gc.setForeground(((SwtColor)color).getSwtColor());
        this.gc.setBackground(((SwtColor)color).getSwtColor());
        return oldColor;
    }

    public FontResource setFont(FontResource font) {
        FontResource oldFont = this.getFont();
        this.gc.setFont(((SwtFont)font).getSwtFont());
        return oldFont;
    }

    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
        switch (lineStyle) {
            case 1: {
                this.gc.setLineStyle(2);
                break;
            }
            case 2: {
                this.gc.setLineStyle(3);
                break;
            }
            default: {
                this.gc.setLineStyle(1);
            }
        }
    }

    public void setLineWidth(int lineWidth) {
        this.gc.setLineWidth(lineWidth);
    }

    public int charsWidth(char[] data, int offset, int length) {
        return this.stringWidth(new String(data, offset, length));
    }

    public ColorResource createColor(org.eclipse.vex.core.internal.core.Color rgb) {
        return new SwtColor(new Color(null, rgb.getRed(), rgb.getGreen(), rgb.getBlue()));
    }

    public FontResource createFont(FontSpec fontSpec) {
        int style = 0;
        if ((fontSpec.getStyle() & 1) > 0) {
            style |= 1;
        }
        if ((fontSpec.getStyle() & 2) > 0) {
            style |= 2;
        }
        int size = Math.round(fontSpec.getSize() * 72.0f / 90.0f);
        String[] names = fontSpec.getNames();
        FontData[] fd = new FontData[names.length];
        int i = 0;
        while (i < names.length) {
            fd[i] = new FontData(names[i], size, style);
            ++i;
        }
        return new SwtFont(new Font(null, fd));
    }

    public ColorResource getSystemColor(int id) {
        if (id == 0) {
            return new SwtColor(Display.getCurrent().getSystemColor(26));
        }
        if (id == 1) {
            return new SwtColor(Display.getCurrent().getSystemColor(27));
        }
        return new SwtColor(Display.getCurrent().getSystemColor(-1));
    }

    public void setOrigin(int x, int y) {
        this.originX = x;
        this.originY = y;
    }

    public int stringWidth(String s) {
        return this.gc.stringExtent((String)s).x;
    }
}

