/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.swt;

import org.eclipse.swt.widgets.Display;

public class Timer {
    private final Runnable runnable;
    private final int periodMs;
    private boolean started = false;
    private InnerRunnable innerRunnable;

    public Timer(int periodMs, Runnable runnable) {
        this.periodMs = periodMs;
        this.runnable = runnable;
    }

    public void reset() {
        if (this.started) {
            this.stop();
            this.start();
        }
    }

    public void start() {
        if (!this.started) {
            this.innerRunnable = new InnerRunnable();
            Display.getCurrent().timerExec(this.periodMs, (Runnable)this.innerRunnable);
            this.started = true;
        }
    }

    public void stop() {
        if (this.started) {
            this.innerRunnable.discarded = true;
            this.innerRunnable = null;
            this.started = false;
        }
    }

    private class InnerRunnable
    implements Runnable {
        public boolean discarded = false;

        private InnerRunnable() {
        }

        public void run() {
            if (!this.discarded) {
                Timer.this.runnable.run();
                Display.getCurrent().timerExec(Timer.this.periodMs, (Runnable)this);
            }
        }
    }
}

