/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.swt;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.vex.core.internal.core.Caret;
import org.eclipse.vex.core.internal.core.Color;
import org.eclipse.vex.core.internal.core.ColorResource;
import org.eclipse.vex.core.internal.core.DisplayDevice;
import org.eclipse.vex.core.internal.core.ElementName;
import org.eclipse.vex.core.internal.core.Graphics;
import org.eclipse.vex.core.internal.core.Rectangle;
import org.eclipse.vex.core.internal.css.StyleSheet;
import org.eclipse.vex.core.internal.dom.Document;
import org.eclipse.vex.core.internal.dom.DocumentFragment;
import org.eclipse.vex.core.internal.dom.DocumentValidationException;
import org.eclipse.vex.core.internal.dom.Element;
import org.eclipse.vex.core.internal.layout.Box;
import org.eclipse.vex.core.internal.layout.BoxFactory;
import org.eclipse.vex.core.internal.widget.HostComponent;
import org.eclipse.vex.core.internal.widget.IBoxFilter;
import org.eclipse.vex.core.internal.widget.IVexWidget;
import org.eclipse.vex.core.internal.widget.VexWidgetImpl;
import org.eclipse.vex.ui.internal.handlers.IVexWidgetHandler;
import org.eclipse.vex.ui.internal.swt.DocumentFragmentTransfer;
import org.eclipse.vex.ui.internal.swt.KeyStroke;
import org.eclipse.vex.ui.internal.swt.SwtDisplayDevice;
import org.eclipse.vex.ui.internal.swt.SwtGraphics;
import org.eclipse.vex.ui.internal.swt.Timer;

public class VexWidget
extends Canvas
implements IVexWidget,
ISelectionProvider {
    private static final char CHAR_NONE = '\u0000';
    private static Map<KeyStroke, IVexWidgetHandler> keyMap = new HashMap<KeyStroke, IVexWidgetHandler>();
    private final VexWidgetImpl impl;
    int originX = 0;
    int originY = 0;
    private final List<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>();
    private ISelection selection;
    private final Runnable caretTimerRunnable = new Runnable(){

        public void run() {
            VexWidget.this.impl.toggleCaret();
        }
    };
    private final Timer caretTimer = new Timer(500, this.caretTimerRunnable);
    private final ControlListener controlListener = new ControlListener(){

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            org.eclipse.swt.graphics.Rectangle r = VexWidget.this.getClientArea();
            if (r.width == 1) {
                return;
            }
            VexWidget.this.impl.setLayoutWidth(r.width);
            ScrollBar vbar = VexWidget.this.getVerticalBar();
            if (vbar != null) {
                vbar.setThumb(r.height);
                vbar.setPageIncrement(Math.round((float)r.height * 0.9f));
            }
        }
    };
    private final FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            VexWidget.this.impl.setFocus(true);
            VexWidget.this.caretTimer.start();
        }

        public void focusLost(FocusEvent e) {
            VexWidget.this.impl.setFocus(false);
            VexWidget.this.caretTimer.stop();
        }
    };
    private final HostComponent hostComponent = new HostComponent(){

        public Graphics createDefaultGraphics() {
            if (VexWidget.this.isDisposed()) {
                System.out.println("*** Woot! VexWidget is disposed!");
            }
            return new SwtGraphics(new GC((Drawable)VexWidget.this));
        }

        public void fireSelectionChanged() {
            if (VexWidget.this.hasSelection()) {
                List nodes = VexWidget.this.getDocument().getNodes(VexWidget.this.getSelectionStart(), VexWidget.this.getSelectionEnd());
                VexWidget.this.selection = (ISelection)new StructuredSelection(nodes);
            } else {
                VexWidget.this.selection = (ISelection)new StructuredSelection((Object)VexWidget.this.getCurrentElement());
            }
            SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)VexWidget.this, VexWidget.this.selection);
            for (ISelectionChangedListener listener : VexWidget.this.selectionListeners) {
                listener.selectionChanged(e);
            }
            VexWidget.this.caretTimer.reset();
        }

        public Rectangle getViewport() {
            return new Rectangle(VexWidget.this.getClientArea().x - VexWidget.this.originX, VexWidget.this.getClientArea().y - VexWidget.this.originY, VexWidget.this.getClientArea().width, VexWidget.this.getClientArea().height);
        }

        public void invokeLater(Runnable runnable) {
            VexWidget.this.getDisplay().asyncExec(runnable);
        }

        public void repaint() {
            if (!VexWidget.this.isDisposed()) {
                VexWidget.this.redraw();
            }
        }

        public void repaint(int x, int y, int width, int height) {
            VexWidget.this.redraw(x + VexWidget.this.originX, y + VexWidget.this.originY, width, height, true);
        }

        public void scrollTo(int left, int top) {
            ScrollBar vbar = VexWidget.this.getVerticalBar();
            if (vbar != null) {
                vbar.setSelection(top);
            }
            VexWidget.this.setOrigin(-left, -top);
        }

        public void setPreferredSize(int width, int height) {
            ScrollBar vbar = VexWidget.this.getVerticalBar();
            if (vbar != null) {
                vbar.setMaximum(height);
            }
        }
    };
    private final KeyListener keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent event) {
            KeyStroke keyStroke = new KeyStroke(event);
            IVexWidgetHandler handler = (IVexWidgetHandler)keyMap.get(keyStroke);
            if (handler != null) {
                try {
                    handler.execute(VexWidget.this);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (!Character.isISOControl(event.character)) {
                try {
                    VexWidget.this.insertChar(event.character);
                }
                catch (DocumentValidationException documentValidationException) {}
            }
        }
    };
    private final MouseListener mouseListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent e) {
            if (e.button == 1) {
                VexWidget.this.selectWord();
            }
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1) {
                int offset = VexWidget.this.viewToModel(e.x - VexWidget.this.originX, e.y - VexWidget.this.originY);
                boolean select = e.stateMask == 131072;
                VexWidget.this.moveTo(offset, select);
            }
        }

        public void mouseUp(MouseEvent e) {
        }
    };
    private final MouseMoveListener mouseMoveListener = new MouseMoveListener(){

        public void mouseMove(MouseEvent e) {
            if ((e.stateMask & 0x80000) > 0) {
                int offset = VexWidget.this.viewToModel(e.x - VexWidget.this.originX, e.y - VexWidget.this.originY);
                VexWidget.this.moveTo(offset, true);
            }
        }
    };
    private final PaintListener painter = new PaintListener(){

        public void paintControl(PaintEvent e) {
            SwtGraphics g = new SwtGraphics(e.gc);
            g.setOrigin(VexWidget.this.originX, VexWidget.this.originY);
            Color bgColor = VexWidget.this.impl.getBackgroundColor();
            if (bgColor == null) {
                bgColor = new Color(255, 255, 255);
            }
            ColorResource color = g.createColor(bgColor);
            ColorResource oldColor = g.setColor(color);
            Rectangle r = g.getClipBounds();
            g.fillRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
            g.setColor(oldColor);
            color.dispose();
            VexWidget.this.impl.paint((Graphics)g, 0, 0);
        }
    };
    private final SelectionListener selectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            ScrollBar vbar = VexWidget.this.getVerticalBar();
            if (vbar != null) {
                int y = -vbar.getSelection();
                VexWidget.this.setOrigin(0, y);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    static {
        VexWidget.buildKeyMap();
    }

    public VexWidget(Composite parent, int style) {
        super(parent, style);
        if (DisplayDevice.getCurrent() == null) {
            DisplayDevice.setCurrent((DisplayDevice)new SwtDisplayDevice());
        }
        this.impl = new VexWidgetImpl(this.hostComponent);
        this.setBackground(this.getDisplay().getSystemColor(1));
        ScrollBar vbar = this.getVerticalBar();
        if (vbar != null) {
            vbar.setIncrement(20);
            vbar.addSelectionListener(this.selectionListener);
        }
        this.addControlListener(this.controlListener);
        this.addFocusListener(this.focusListener);
        this.addKeyListener(this.keyListener);
        this.addMouseListener(this.mouseListener);
        this.addMouseMoveListener(this.mouseMoveListener);
        this.addPaintListener(this.painter);
    }

    public void dispose() {
        super.dispose();
        this.impl.setFocus(false);
    }

    public Object getInput() {
        return this.impl.getDocument();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        throw new RuntimeException("Unexpected call to setSelection");
    }

    public void beginWork() {
        this.impl.beginWork();
    }

    public boolean canPaste() {
        return false;
    }

    public boolean canPasteText() {
        return false;
    }

    public boolean canRedo() {
        return this.impl.canRedo();
    }

    public boolean canUndo() {
        return this.impl.canUndo();
    }

    public boolean canUnwrap() {
        return this.impl.canUnwrap();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        org.eclipse.swt.graphics.Rectangle r = this.getClientArea();
        int height = r.height;
        ScrollBar vbar = this.getVerticalBar();
        if (vbar != null) {
            height = vbar.getMaximum();
        }
        return new Point(r.width, height);
    }

    public void copySelection() {
        Clipboard clipboard = new Clipboard(this.getDisplay());
        Object[] data = new Object[]{this.getSelectedFragment(), this.getSelectedText()};
        Transfer[] transfers = new Transfer[]{DocumentFragmentTransfer.getInstance(), TextTransfer.getInstance()};
        clipboard.setContents(data, transfers);
    }

    public void cutSelection() {
        this.copySelection();
        this.deleteSelection();
    }

    public void deleteNextChar() throws DocumentValidationException {
        this.impl.deleteNextChar();
    }

    public void deletePreviousChar() throws DocumentValidationException {
        this.impl.deletePreviousChar();
    }

    public void deleteSelection() {
        this.impl.deleteSelection();
    }

    public void doWork(Runnable runnable) {
        this.impl.doWork(runnable);
    }

    public void doWork(boolean savePosition, Runnable runnable) {
        this.impl.doWork(savePosition, runnable);
    }

    public void endWork(boolean success) {
        this.impl.endWork(success);
    }

    public Box findInnermostBox(IBoxFilter filter) {
        return this.impl.findInnermostBox(filter);
    }

    public BoxFactory getBoxFactory() {
        return this.impl.getBoxFactory();
    }

    public int getCaretOffset() {
        return this.impl.getCaretOffset();
    }

    public Element getCurrentElement() {
        return this.impl.getCurrentElement();
    }

    public Document getDocument() {
        return this.impl.getDocument();
    }

    public int getLayoutWidth() {
        return this.impl.getLayoutWidth();
    }

    public int getSelectionEnd() {
        return this.impl.getSelectionEnd();
    }

    public int getSelectionStart() {
        return this.impl.getSelectionStart();
    }

    public DocumentFragment getSelectedFragment() {
        return this.impl.getSelectedFragment();
    }

    public String getSelectedText() {
        return this.impl.getSelectedText();
    }

    public StyleSheet getStyleSheet() {
        return this.impl.getStyleSheet();
    }

    public int getUndoDepth() {
        return this.impl.getUndoDepth();
    }

    public ElementName[] getValidInsertElements() {
        return this.impl.getValidInsertElements();
    }

    public ElementName[] getValidMorphElements() {
        return this.impl.getValidMorphElements();
    }

    public boolean hasSelection() {
        return this.impl.hasSelection();
    }

    public void insertChar(char c) throws DocumentValidationException {
        this.impl.insertChar(c);
    }

    public void insertFragment(DocumentFragment frag) throws DocumentValidationException {
        this.impl.insertFragment(frag);
    }

    public void insertElement(Element element) throws DocumentValidationException {
        this.impl.insertElement(element);
    }

    public void insertText(String text) throws DocumentValidationException {
        this.impl.insertText(text);
    }

    public boolean isDebugging() {
        return this.impl.isDebugging();
    }

    public void morph(Element element) throws DocumentValidationException {
        this.impl.morph(element);
    }

    public void moveBy(int distance) {
        this.impl.moveBy(distance);
    }

    public void moveBy(int distance, boolean select) {
        this.impl.moveBy(distance, select);
    }

    public void moveTo(int offset) {
        this.impl.moveTo(offset);
    }

    public void moveTo(int offset, boolean select) {
        this.impl.moveTo(offset, select);
    }

    public void moveToLineEnd(boolean select) {
        this.impl.moveToLineEnd(select);
    }

    public void moveToLineStart(boolean select) {
        this.impl.moveToLineStart(select);
    }

    public void moveToNextLine(boolean select) {
        this.impl.moveToNextLine(select);
    }

    public void moveToNextPage(boolean select) {
        this.impl.moveToNextPage(select);
    }

    public void moveToNextWord(boolean select) {
        this.impl.moveToNextWord(select);
    }

    public void moveToPreviousLine(boolean select) {
        this.impl.moveToPreviousLine(select);
    }

    public void moveToPreviousPage(boolean select) {
        this.impl.moveToPreviousPage(select);
    }

    public void moveToPreviousWord(boolean select) {
        this.impl.moveToPreviousWord(select);
    }

    public void paste() throws DocumentValidationException {
        Clipboard clipboard = new Clipboard(this.getDisplay());
        DocumentFragment frag = (DocumentFragment)clipboard.getContents((Transfer)DocumentFragmentTransfer.getInstance());
        if (frag != null) {
            this.insertFragment(frag);
        } else {
            this.pasteText();
        }
    }

    public void pasteText() throws DocumentValidationException {
        Clipboard clipboard = new Clipboard(this.getDisplay());
        String text = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
        if (text != null) {
            this.insertText(text);
        }
    }

    public void redo() throws CannotRedoException {
        this.impl.redo();
    }

    public void removeAttribute(String attributeName) {
        this.impl.removeAttribute(attributeName);
    }

    public void savePosition(Runnable runnable) {
        this.impl.savePosition(runnable);
    }

    public void selectAll() {
        this.impl.selectAll();
    }

    public void selectWord() {
        this.impl.selectWord();
    }

    public void setAttribute(String attributeName, String value) {
        this.impl.setAttribute(attributeName, value);
    }

    public void setBoxFactory(BoxFactory boxFactory) {
        this.impl.setBoxFactory(boxFactory);
    }

    public void setDebugging(boolean debugging) {
        this.impl.setDebugging(debugging);
    }

    public void setDocument(Document doc, StyleSheet styleSheet) {
        this.impl.setDocument(doc, styleSheet);
    }

    public void setLayoutWidth(int width) {
        this.impl.setLayoutWidth(width);
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        this.impl.setStyleSheet(styleSheet);
    }

    public void setStyleSheet(URL ssUrl) throws IOException {
        this.impl.setStyleSheet(ssUrl);
    }

    public void split() throws DocumentValidationException {
        this.impl.split();
    }

    public void undo() throws CannotUndoException {
        this.impl.undo();
    }

    public int viewToModel(int x, int y) {
        return this.impl.viewToModel(x, y);
    }

    public Point getLocationForContentAssist() {
        Caret vexCaret = this.impl.getCaret();
        if (vexCaret == null) {
            return new Point(0, 0);
        }
        Rectangle caretBounds = vexCaret.getBounds();
        return new Point(caretBounds.getX() + this.originX, caretBounds.getY() + this.originY + caretBounds.getHeight());
    }

    private static void addKey(char character, int keyCode, int stateMask, Action action) {
        keyMap.put(new KeyStroke(character, keyCode, stateMask), action);
    }

    private static void buildKeyMap() {
        VexWidget.addKey('\u0000', 0x1000002, 0, new Action(){

            public void runEx(IVexWidget w) {
                w.moveToNextLine(false);
            }
        });
        VexWidget.addKey('\u0000', 0x1000002, 131072, new Action(){

            public void runEx(IVexWidget w) {
                w.moveToNextLine(true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000001, 0, new Action(){

            public void runEx(IVexWidget w) {
                w.moveToPreviousLine(false);
            }
        });
        VexWidget.addKey('\u0000', 0x1000001, 131072, new Action(){

            public void runEx(IVexWidget w) {
                w.moveToPreviousLine(true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000003, 0, new Action(){

            public void runEx(IVexWidget w) {
                w.moveBy(-1);
            }
        });
        VexWidget.addKey('\u0000', 0x1000003, 131072, new Action(){

            public void runEx(IVexWidget w) {
                w.moveBy(-1, true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000003, 262144, new Action(){

            public void runEx(IVexWidget w) {
                w.moveToPreviousWord(false);
            }
        });
        VexWidget.addKey('\u0000', 0x1000003, 393216, new Action(){

            public void runEx(IVexWidget w) {
                w.moveToPreviousWord(true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000004, 0, new Action(){

            public void runEx(IVexWidget w) {
                w.moveBy(1);
            }
        });
        VexWidget.addKey('\u0000', 0x1000004, 131072, new Action(){

            public void runEx(IVexWidget w) {
                w.moveBy(1, true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000004, 262144, new Action(){

            public void runEx(IVexWidget w) {
                w.moveToNextWord(false);
            }
        });
        VexWidget.addKey('\u0000', 0x1000004, 393216, new Action(){

            public void runEx(IVexWidget w) {
                w.moveToNextWord(true);
            }
        });
        VexWidget.addKey('\b', 8, 0, new Action(){

            public void runEx(IVexWidget w) throws ExecutionException {
                try {
                    w.deletePreviousChar();
                }
                catch (DocumentValidationException e) {
                    throw new ExecutionException(e.getMessage(), (Throwable)e);
                }
            }
        });
        VexWidget.addKey('\u007f', 127, 0, new Action(){

            public void runEx(IVexWidget w) throws ExecutionException {
                try {
                    w.deleteNextChar();
                }
                catch (DocumentValidationException e) {
                    throw new ExecutionException(e.getMessage(), (Throwable)e);
                }
            }
        });
        VexWidget.addKey('\u0000', 0x1000008, 0, new Action(){

            public void runEx(IVexWidget w) {
                w.moveToLineEnd(false);
            }
        });
        VexWidget.addKey('\u0000', 0x1000008, 131072, new Action(){

            public void runEx(IVexWidget w) {
                w.moveToLineEnd(true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000008, 262144, new Action(){

            public void runEx(IVexWidget w) {
                w.moveTo(w.getDocument().getLength() - 1);
            }
        });
        VexWidget.addKey('\u0000', 0x1000008, 393216, new Action(){

            public void runEx(IVexWidget w) {
                w.moveTo(w.getDocument().getLength() - 1, true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000007, 0, new Action(){

            public void runEx(IVexWidget w) {
                w.moveToLineStart(false);
            }
        });
        VexWidget.addKey('\u0000', 0x1000007, 131072, new Action(){

            public void runEx(IVexWidget w) {
                w.moveToLineStart(true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000007, 262144, new Action(){

            public void runEx(IVexWidget w) {
                w.moveTo(1);
            }
        });
        VexWidget.addKey('\u0000', 0x1000007, 393216, new Action(){

            public void runEx(IVexWidget w) {
                w.moveTo(1, true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000006, 0, new Action(){

            public void runEx(IVexWidget w) {
                w.moveToNextPage(false);
            }
        });
        VexWidget.addKey('\u0000', 0x1000006, 131072, new Action(){

            public void runEx(IVexWidget w) {
                w.moveToNextPage(true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000005, 0, new Action(){

            public void runEx(IVexWidget w) {
                w.moveToPreviousPage(false);
            }
        });
        VexWidget.addKey('\u0000', 0x1000005, 131072, new Action(){

            public void runEx(IVexWidget w) {
                w.moveToPreviousPage(true);
            }
        });
    }

    private void setOrigin(int x, int y) {
        int destX = x - this.originX;
        int destY = y - this.originY;
        org.eclipse.swt.graphics.Rectangle ca = this.getClientArea();
        this.scroll(destX, destY, 0, 0, ca.width, ca.height, false);
        this.originX = x;
        this.originY = y;
    }

    private static abstract class Action
    implements IVexWidgetHandler {
        private Action() {
        }

        public void execute(VexWidget widget) throws ExecutionException {
            this.runEx(widget);
        }

        public abstract void runEx(IVexWidget var1) throws ExecutionException;
    }
}

