/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.vex.core.internal.dom.Document;
import org.eclipse.vex.core.internal.dom.DocumentContentModel;
import org.eclipse.vex.core.internal.dom.DocumentWriter;
import org.eclipse.vex.core.internal.dom.IWhitespacePolicy;
import org.eclipse.vex.core.internal.dom.RootElement;
import org.eclipse.vex.core.internal.validator.WTPVEXValidator;
import org.eclipse.vex.core.internal.widget.CssWhitespacePolicy;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.DocumentType;
import org.eclipse.vex.ui.internal.config.Style;
import org.eclipse.vex.ui.internal.editor.DocumentFileCreationPage;
import org.eclipse.vex.ui.internal.editor.DocumentTypeSelectionPage;
import org.eclipse.vex.ui.internal.editor.Messages;

public class NewDocumentWizard
extends BasicNewResourceWizard {
    private DocumentTypeSelectionPage typePage;
    private DocumentFileCreationPage filePage;

    public void addPages() {
        this.typePage = new DocumentTypeSelectionPage();
        this.filePage = new DocumentFileCreationPage("filePage", this.getSelection());
        this.addPage((IWizardPage)this.typePage);
        this.addPage((IWizardPage)this.filePage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(Messages.getString("NewDocumentWizard.title"));
    }

    public boolean performFinish() {
        IWorkbenchPage page;
        Style style;
        Document doc;
        block4: {
            try {
                doc = NewDocumentWizard.createDocument(this.typePage.getDocumentType(), this.typePage.getRootElementName());
                style = VexPlugin.getDefault().getPreferences().getPreferredStyle(this.typePage.getDocumentType().getPublicId());
                if (style != null) break block4;
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("NewDocumentWizard.noStyles.title"), (String)Messages.getString("NewDocumentWizard.noStyles.message"));
                return false;
            }
            catch (Exception ex) {
                String message = MessageFormat.format(Messages.getString("NewDocumentWizard.errorLoading.message"), this.filePage.getFileName(), ex.getMessage());
                VexPlugin.getDefault().log(4, message, ex);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("NewDocumentWizard.errorLoading.title"), (String)("Unable to create " + this.filePage.getFileName()));
                return false;
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DocumentWriter writer = new DocumentWriter();
        writer.setWhitespacePolicy((IWhitespacePolicy)new CssWhitespacePolicy(style.getStyleSheet()));
        writer.write(doc, (OutputStream)baos);
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        this.filePage.setInitialContents(bais);
        IFile file = this.filePage.createNewFile();
        IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.vex.ui.internal.editor.VexEditor");
        this.selectAndReveal((IResource)file);
        NewDocumentWizard.registerEditorForFilename("*." + file.getFileExtension(), "org.eclipse.vex.ui.internal.editor.VexEditor");
        IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
        if (dw != null && (page = dw.getActivePage()) != null) {
            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
        }
        this.typePage.saveSettings();
        return true;
    }

    private static Document createDocument(DocumentType documentType, String rootElementName) {
        if (NewDocumentWizard.isDTD(documentType)) {
            return NewDocumentWizard.createDocumentWithDTD(documentType, rootElementName);
        }
        return NewDocumentWizard.createDocumentWithSchema(documentType, rootElementName);
    }

    private static boolean isDTD(DocumentType documentType) {
        String systemId = documentType.getSystemId();
        return systemId != null && systemId.toLowerCase().endsWith(".dtd");
    }

    private static Document createDocumentWithDTD(DocumentType documentType, String rootElementName) {
        RootElement root = new RootElement(rootElementName);
        Document result = new Document(root);
        result.setPublicID(documentType.getPublicId());
        result.setSystemID(documentType.getSystemId());
        return result;
    }

    private static Document createDocumentWithSchema(DocumentType documentType, String rootElementName) {
        String defaultNamespaceUri = documentType.getPublicId();
        RootElement root = new RootElement(new QualifiedName(defaultNamespaceUri, rootElementName));
        root.declareDefaultNamespace(defaultNamespaceUri);
        WTPVEXValidator validator = new WTPVEXValidator(new DocumentContentModel(null, null, null, root));
        int namespaceIndex = 1;
        for (String namespaceUri : validator.getRequiredNamespaces()) {
            if (defaultNamespaceUri.equals(namespaceUri)) continue;
            root.declareNamespace("ns" + namespaceIndex++, namespaceUri);
        }
        return new Document(root);
    }

    private static void registerEditorForFilename(String fileName, String editorId) {
        EditorDescriptor ed = NewDocumentWizard.getEditorDescriptor(editorId);
        if (ed == null) {
            return;
        }
        IEditorRegistry reg = PlatformUI.getWorkbench().getEditorRegistry();
        EditorRegistry ereg = (EditorRegistry)reg;
        FileEditorMapping[] mappings = (FileEditorMapping[])ereg.getFileEditorMappings();
        FileEditorMapping mapping = null;
        FileEditorMapping[] fileEditorMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            FileEditorMapping fem = fileEditorMappingArray[n2];
            if (fem.getLabel().equals(fileName)) {
                mapping = fem;
                break;
            }
            ++n2;
        }
        if (mapping != null) {
            fileEditorMappingArray = mapping.getEditors();
            n = fileEditorMappingArray.length;
            n2 = 0;
            while (n2 < n) {
                FileEditorMapping editor = fileEditorMappingArray[n2];
                if (editor.getId().equals(editorId)) {
                    return;
                }
                ++n2;
            }
            mapping.addEditor(ed);
            ereg.setFileEditorMappings(mappings);
            ereg.saveAssociations();
        } else {
            String name = null;
            String ext = null;
            int iDot = fileName.lastIndexOf(46);
            if (iDot == -1) {
                name = fileName;
            } else {
                name = fileName.substring(0, iDot);
                ext = fileName.substring(iDot + 1);
            }
            mapping = new FileEditorMapping(name, ext);
            FileEditorMapping[] newMappings = new FileEditorMapping[mappings.length + 1];
            mapping.addEditor(ed);
            System.arraycopy(mappings, 0, newMappings, 0, mappings.length);
            newMappings[mappings.length] = mapping;
            ereg.setFileEditorMappings(newMappings);
            ereg.saveAssociations();
        }
    }

    private static EditorDescriptor getEditorDescriptor(String editorId) {
        EditorRegistry reg = (EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor[] iEditorDescriptorArray = reg.getSortedEditorsFromPlugins();
        int n = iEditorDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorDescriptor editor = iEditorDescriptorArray[n2];
            if (editor.getId().equals(editorId)) {
                return (EditorDescriptor)editor;
            }
            ++n2;
        }
        return null;
    }
}

