/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.xhtml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.vex.core.provisional.dom.Filters;
import org.eclipse.vex.core.provisional.dom.IDocument;
import org.eclipse.vex.core.provisional.dom.IElement;
import org.eclipse.vex.ui.internal.editor.VexEditor;
import org.eclipse.vex.ui.internal.outline.IOutlineProvider;

public class XhtmlOutlineProvider
implements IOutlineProvider {
    private final ITreeContentProvider contentProvider = new ITreeContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return XhtmlOutlineProvider.this.getOutlineChildren((IElement)parentElement);
        }

        public Object getParent(Object element) {
            IElement parent = ((IElement)element).getParentElement();
            if (parent == null) {
                return element;
            }
            return XhtmlOutlineProvider.this.getOutlineElement(parent);
        }

        public boolean hasChildren(Object element) {
            return XhtmlOutlineProvider.this.getOutlineChildren((IElement)element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            IDocument document = (IDocument)inputElement;
            return new Object[]{document.getRootElement()};
        }
    };
    private final ILabelProvider labelProvider = new LabelProvider(){

        public String getText(Object o) {
            String text;
            IElement element = (IElement)o;
            if (element.getParent() == null) {
                IElement title;
                text = "html";
                IElement head = XhtmlOutlineProvider.this.findChild(element, "head");
                if (head != null && (title = XhtmlOutlineProvider.this.findChild(head, "title")) != null) {
                    text = title.getText();
                }
            } else {
                text = element.getText();
            }
            return text;
        }
    };

    public void init(VexEditor editor) {
    }

    public ITreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public IBaseLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public IElement getOutlineElement(IElement child) {
        IElement element = child;
        while (element.getParentElement() != null) {
            String name = element.getLocalName();
            if (name.equals("h1") || name.equals("h2") || name.equals("h3") || name.equals("h4") || name.equals("h5") || name.equals("h6")) {
                return element;
            }
            element = element.getParentElement();
        }
        return element;
    }

    private IElement[] getOutlineChildren(IElement element) {
        ArrayList<IElement> children;
        block7: {
            block8: {
                children = new ArrayList<IElement>();
                if (element.getParent() != null) break block8;
                IElement body = this.findChild(element, "body");
                if (body == null) break block7;
                List childElements = body.childElements().asList();
                String lowH = "h6";
                for (IElement child : childElements) {
                    if (!this.isHTag(child) || child.getLocalName().compareTo(lowH) >= 0) continue;
                    lowH = child.getLocalName();
                }
                for (IElement child : childElements) {
                    if (!child.getLocalName().equals(lowH)) continue;
                    children.add(child);
                }
                break block7;
            }
            if (this.isHTag(element)) {
                int level = Integer.parseInt(element.getLocalName().substring(1));
                String childName = "h" + (level + 1);
                boolean foundSelf = false;
                for (IElement child : element.getParentElement().childElements()) {
                    if (child == element) {
                        foundSelf = true;
                        continue;
                    }
                    if (!foundSelf) continue;
                    if (child.getLocalName().equals(childName)) {
                        children.add(child);
                        continue;
                    }
                    if (!child.getLocalName().equals(element.getLocalName())) {
                        continue;
                    }
                    break;
                }
            }
        }
        return children.toArray(new IElement[children.size()]);
    }

    private IElement findChild(IElement parent, String childName) {
        Iterator iterator = parent.childElements().matching(Filters.elementsNamed((String)childName)).iterator();
        if (iterator.hasNext()) {
            IElement child = (IElement)iterator.next();
            return child;
        }
        return null;
    }

    private boolean isHTag(IElement element) {
        String name = element.getLocalName();
        return name.equals("h1") || name.equals("h2") || name.equals("h3") || name.equals("h4") || name.equals("h5") || name.equals("h6");
    }
}

