/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.bag.primitive;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;

/**
 * This file was automatically generated from template file immutablePrimitiveBag.stg.
 *
 * @since 3.0.
 */
public interface ImmutableLongBag extends ImmutableLongCollection, LongBag
{
    ImmutableLongBag select(LongPredicate predicate);

    ImmutableLongBag reject(LongPredicate predicate);

    <V> ImmutableBag<V> collect(LongToObjectFunction<? extends V> function);

    ImmutableLongBag newWith(long element);

    ImmutableLongBag newWithout(long element);

    ImmutableLongBag newWithAll(LongIterable elements);

    ImmutableLongBag newWithoutAll(LongIterable elements);
}
