/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.virgo.ide.bundlerepository.domain.OsgiVersion;
import org.eclipse.virgo.ide.manifest.core.editor.model.ImportBundleHeader;
import org.eclipse.virgo.ide.manifest.core.editor.model.ImportBundleObject;
import org.eclipse.virgo.ide.runtime.core.artefacts.Artefact;
import org.eclipse.virgo.ide.runtime.core.artefacts.ArtefactRepository;
import org.eclipse.virgo.ide.runtime.core.artefacts.BundleArtefact;
import org.eclipse.virgo.ide.runtime.core.artefacts.IArtefact;
import org.eclipse.virgo.ide.runtime.core.provisioning.RepositoryUtils;
import org.eclipse.virgo.ide.ui.editors.AbstractImportSection;
import org.eclipse.virgo.ide.ui.editors.BundleDependencyPropertiesDialog;
import org.eclipse.virgo.ide.ui.editors.BundleManifestEditor;

public class BundleImportSection
extends AbstractImportSection {
    private static final String DESCRIPTION = "Specify the list of bundles required for the operation of this bundle.";
    private static final int ADD_INDEX = 0;
    private static final int ADD_REMOTE_BUNDLE_INDEX = 1;
    private static final int REMOVE_INDEX = 2;
    private static final int PROPERTIES_INDEX = 3;

    public BundleImportSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEUIMessages.ImportPackageSection_add, "Download...", PDEUIMessages.ImportPackageSection_remove, PDEUIMessages.ImportPackageSection_properties});
        this.getSection().setText("Import Bundle");
        this.getSection().setDescription(DESCRIPTION);
        this.getTablePart().setEditable(false);
    }

    protected IContentProvider getContentProvider() {
        return new ImportBundleContentProvider();
    }

    protected ITableLabelProvider getLabelProvider() {
        return new BundleImportLabelProvider();
    }

    private void setElements(AbstractImportSection.ImportListSelectionDialog dialog, boolean addRemote) {
        IProject project = ((BundleManifestEditor)this.getPage().getEditor()).getCommonProject();
        Object[] bundles = null;
        if (addRemote) {
            ArtefactRepository bundleRepository = RepositoryUtils.searchForArtifacts((String)"", (boolean)true, (boolean)false);
            bundles = bundleRepository.getBundleSet().toArray();
        } else {
            Set bundleList = RepositoryUtils.getImportBundleProposals((IProject)project, (String)"");
            bundles = bundleList.toArray(new IArtefact[0]);
        }
        dialog.setElements(bundles);
    }

    protected void handleAdd() {
        this.internalHandleAdd(false);
    }

    private void internalHandleAdd(final boolean addRemote) {
        final AbstractImportSection.ImportListSelectionDialog dialog = new AbstractImportSection.ImportListSelectionDialog(this, PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new BundleImportDialogLabelProvider());
        Runnable runnable = new Runnable(){

            public void run() {
                BundleImportSection.this.setElements(dialog, addRemote);
                dialog.setMultipleSelection(true);
                dialog.setTitle("Bundle Selection");
                dialog.setMessage("Select a Bundle:");
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, (int)400, (int)500);
            }
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable);
        if (dialog.open() == 0) {
            Object[] selected = dialog.getResult();
            if (addRemote) {
                this.addRemoteBundles(selected);
            } else {
                this.addLocalBundles(selected);
            }
        }
    }

    private void addLocalBundles(Object[] selected) {
        ImportBundleHeader importBundleHeader = (ImportBundleHeader)this.getBundle().getManifestHeader("Import-Bundle");
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object currSelectedElement = objectArray[n2];
            BundleArtefact currBundle = (BundleArtefact)currSelectedElement;
            if (importBundleHeader == null) {
                this.getBundle().setHeader("Import-Bundle", "");
                importBundleHeader = (ImportBundleHeader)this.getBundle().getManifestHeader("Import-Bundle");
            }
            String versionString = null;
            OsgiVersion osgiVers = currBundle.getVersion();
            if (osgiVers.getMajor() != 0 || osgiVers.getMinor() != 0 || osgiVers.getService() != 0 || osgiVers.getQualifier() != null && !osgiVers.getQualifier().trim().equals("")) {
                versionString = "[" + currBundle.getVersion().toString() + "," + currBundle.getVersion().toString() + "]";
            }
            importBundleHeader.addBundle(currBundle.getSymbolicName(), versionString);
            ++n2;
        }
    }

    private void addRemoteBundles(Object[] selected) {
        ImportBundleHeader importBundleHeader = (ImportBundleHeader)this.getBundle().getManifestHeader("Import-Bundle");
        HashSet<Artefact> remoteArtifactDefinitions = new HashSet<Artefact>(selected.length);
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object currSelectedElement = objectArray[n2];
            remoteArtifactDefinitions.add((Artefact)currSelectedElement);
            ++n2;
        }
        IProject project = ((BundleManifestEditor)this.getPage().getEditor()).getCommonProject();
        RepositoryUtils.downloadArifacts(remoteArtifactDefinitions, (IProject)project, (Shell)Display.getDefault().getActiveShell(), (boolean)false);
        Object[] objectArray2 = selected;
        int n3 = selected.length;
        n = 0;
        while (n < n3) {
            Object currSelectedElement = objectArray2[n];
            BundleArtefact currBundle = (BundleArtefact)currSelectedElement;
            if (importBundleHeader == null) {
                this.getBundle().setHeader("Import-Bundle", "");
                importBundleHeader = (ImportBundleHeader)this.getBundle().getManifestHeader("Import-Bundle");
            }
            String versionString = null;
            OsgiVersion osgiVers = currBundle.getVersion();
            if (osgiVers.getMajor() != 0 || osgiVers.getMinor() != 0 || osgiVers.getService() != 0 || osgiVers.getQualifier() != null && !osgiVers.getQualifier().trim().equals("")) {
                versionString = "[" + currBundle.getVersion().toString() + "," + currBundle.getVersion().toString() + "]";
            }
            if (importBundleHeader.hasElement(currBundle.getSymbolicName())) {
                importBundleHeader.removeBundle(currBundle.getSymbolicName());
            }
            importBundleHeader.addBundle(currBundle.getSymbolicName(), versionString);
            ++n;
        }
    }

    protected void handleRemove() {
        Object[] removed;
        Object[] objectArray = removed = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        int n = removed.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            ImportBundleHeader header = (ImportBundleHeader)this.getBundle().getManifestHeader("Import-Bundle");
            header.removeBundle((ImportBundleObject)element);
            ++n2;
        }
    }

    protected int getAddIndex() {
        return 0;
    }

    protected int getRemoveIndex() {
        return 2;
    }

    protected int getPropertiesIndex() {
        return 3;
    }

    protected String getHeaderConstant() {
        return "Import-Bundle";
    }

    protected boolean shouldEnableProperties(Object[] selected) {
        if (selected.length == 0) {
            return false;
        }
        if (selected.length == 1) {
            return true;
        }
        String version = ((ImportBundleObject)selected[0]).getVersion();
        boolean optional = ((ImportBundleObject)selected[0]).isOptional();
        int i = 1;
        while (i < selected.length) {
            ImportBundleObject object = (ImportBundleObject)selected[i];
            if (version == null ? object.getVersion() != null || optional != object.isOptional() : !version.equals(object.getVersion()) || optional != object.isOptional()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void handleOpenProperties() {
        Object[] selected = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        ImportBundleObject first = (ImportBundleObject)selected[0];
        BundleDependencyPropertiesDialog dialog = new BundleDependencyPropertiesDialog(this.isEditable(), false, false, first.isOptional(), first.getVersion(), true, true);
        dialog.create();
        SWTUtil.setDialogSize((Dialog)dialog, (int)400, (int)-1);
        if (selected.length == 1) {
            dialog.setTitle(((ImportBundleObject)selected[0]).getValue());
        } else {
            dialog.setTitle("Properties");
        }
        if (dialog.open() == 0 && this.isEditable()) {
            String newVersion = dialog.getVersion();
            boolean newOptional = dialog.isOptional();
            Object[] objectArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                ImportBundleObject object = (ImportBundleObject)element;
                if (!newVersion.equals(object.getVersion())) {
                    object.setVersion(newVersion);
                }
                if (!newOptional == object.isOptional()) {
                    object.setOptional(newOptional);
                }
                ++n2;
            }
        }
    }

    protected void buttonSelected(int index) {
        if (index == 1) {
            this.internalHandleAdd(true);
        } else {
            super.buttonSelected(index);
        }
    }

    class BundleImportDialogLabelProvider
    extends LabelProvider {
        BundleImportDialogLabelProvider() {
        }

        public Image getImage(Object element) {
            return PDEPluginImages.DESC_BUNDLE_OBJ.createImage();
        }

        public String getText(Object element) {
            BundleArtefact bundleArtifact = (BundleArtefact)element;
            String label = bundleArtifact.getSymbolicName();
            if (bundleArtifact.getVersion() != null) {
                label = String.valueOf(label) + " " + bundleArtifact.getVersion();
            }
            return label;
        }
    }

    class BundleImportLabelProvider
    extends AbstractImportSection.AbstractSectionViewerLabelProvider {
        BundleImportLabelProvider() {
            super(BundleImportSection.this);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return PDEPluginImages.DESC_BUNDLE_OBJ.createImage();
        }

        public String getColumnText(Object element, int columnIndex) {
            ImportBundleObject importBundleObject = (ImportBundleObject)element;
            String label = importBundleObject.getValue();
            if (importBundleObject.getVersion() != null) {
                label = String.valueOf(label) + " " + importBundleObject.getVersion();
            }
            return label;
        }
    }

    class ImportBundleContentProvider
    implements IStructuredContentProvider {
        ImportBundleContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object parent) {
            ImportBundleHeader header = (ImportBundleHeader)BundleImportSection.this.getBundle().getManifestHeader("Import-Bundle");
            if (header == null) {
                return new Object[0];
            }
            return header.getImportedBundles();
        }
    }
}

