/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.plugin.BundleFoldingStructureProvider;

public class SpringBundleFoldingStructureProvider
extends BundleFoldingStructureProvider {
    private final Map fPositionToElement = new HashMap();

    public SpringBundleFoldingStructureProvider(PDESourcePage editor, IEditingModel model) {
        super(editor, model);
    }

    public void addFoldingRegions(Set currentRegions, IEditingModel model) throws BadLocationException {
        IBundle bundle = ((BundleModel)model).getBundle();
        IManifestHeader importPackageHeader = bundle.getManifestHeader("Import-Package");
        IManifestHeader exportPackageHeader = bundle.getManifestHeader("Export-Package");
        IManifestHeader requireBundleHeader = bundle.getManifestHeader("Require-Bundle");
        IManifestHeader importLibraryHeader = bundle.getManifestHeader("Import-Library");
        IManifestHeader importBundleHeader = bundle.getManifestHeader("Import-Bundle");
        IManifestHeader importTemplateBundleHeader = bundle.getManifestHeader("Import-Template");
        IManifestHeader exportTemplateBundleHeader = bundle.getManifestHeader("Export-Template");
        try {
            this.addFoldingRegions(currentRegions, importPackageHeader, model.getDocument());
            this.addFoldingRegions(currentRegions, exportPackageHeader, model.getDocument());
            this.addFoldingRegions(currentRegions, requireBundleHeader, model.getDocument());
            this.addFoldingRegions(currentRegions, importLibraryHeader, model.getDocument());
            this.addFoldingRegions(currentRegions, importBundleHeader, model.getDocument());
            this.addFoldingRegions(currentRegions, importTemplateBundleHeader, model.getDocument());
            this.addFoldingRegions(currentRegions, exportTemplateBundleHeader, model.getDocument());
        }
        catch (BadLocationException badLocationException) {}
    }

    private void addFoldingRegions(Set regions, IManifestHeader header, IDocument document) throws BadLocationException {
        int endLine;
        if (header == null) {
            return;
        }
        int startLine = document.getLineOfOffset(header.getOffset());
        if (startLine < (endLine = document.getLineOfOffset(header.getOffset() + header.getLength() - 1))) {
            int start = document.getLineOffset(startLine);
            int end = document.getLineOffset(endLine) + document.getLineLength(endLine);
            Position position = new Position(start, end - start);
            regions.add(position);
            this.fPositionToElement.put(position, header);
        }
    }
}

