/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dali.core.PersistenceProject;
import org.eclipse.dali.db.PersistenceDbPlugin;
import org.eclipse.dali.db.wrappers.ConnectionInfoWrapper;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class PersistenceProjectPropertiesPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Combo connectionInfoCombo;
    private Combo schemaNameCombo;

    public PersistenceProjectPropertiesPage() {
        this.setDescription("Select a database connection to use for this project.");
    }

    protected Control createContents(Composite superparent) {
        Composite parent = new Composite(superparent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(768));
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        Composite persistenceComposite = new Composite(parent, 0);
        persistenceComposite.setLayout((Layout)gl);
        persistenceComposite.setLayoutData((Object)new GridData(768));
        Label connectionNameLabel = new Label(persistenceComposite, 0);
        connectionNameLabel.setText("Database Connection:");
        this.connectionInfoCombo = new Combo(persistenceComposite, 12);
        this.connectionInfoCombo.setLayoutData((Object)new GridData(768));
        this.connectionInfoCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PersistenceProjectPropertiesPage.this.populateSchemaNameCombo();
            }

            public void widgetSelected(SelectionEvent e) {
                PersistenceProjectPropertiesPage.this.populateSchemaNameCombo();
            }
        });
        Label schemaNameLabel = new Label(persistenceComposite, 0);
        schemaNameLabel.setText("Database Schema:");
        this.schemaNameCombo = new Combo(persistenceComposite, 12);
        this.schemaNameCombo.setLayoutData((Object)new GridData(768));
        new Label(persistenceComposite, 0).setText("Note:  Must be connected to select schema");
        this.populateConnectionInfoCombo();
        this.populateSchemaNameCombo();
        return parent;
    }

    private PersistenceProject getPersistenceProject() {
        IJavaProject project = (IJavaProject)this.getElement();
        try {
            return (PersistenceProject)project.getProject().getNature("org.eclipse.dali.core.persistenceNature");
        }
        catch (CoreException ce) {
            throw new RuntimeException(ce);
        }
    }

    private void populateConnectionInfoCombo() {
        ConnectionInfoWrapper connInfo;
        this.connectionInfoCombo.setItems(new String[0]);
        Iterator connectionInfos = PersistenceDbPlugin.getDefault().getConnectionRepository().getAllConnectionInfo().iterator();
        if (connectionInfos.hasNext()) {
            while (connectionInfos.hasNext()) {
                String connInfoName = ((ConnectionInfoWrapper)connectionInfos.next()).getName();
                this.connectionInfoCombo.add(connInfoName);
            }
        }
        if ((connInfo = this.getPersistenceProject().getConnectionInfo()) != null) {
            this.connectionInfoCombo.select(this.connectionInfoCombo.indexOf(connInfo.getName()));
        }
    }

    private void populateSchemaNameCombo() {
        this.schemaNameCombo.setItems(new String[0]);
        ConnectionInfoWrapper connectionInfo = PersistenceDbPlugin.getDefault().getConnectionRepository().getConnectionInfoNamed(this.connectionInfoCombo.getText());
        if (connectionInfo.isConnected()) {
            Iterator schemaNames = CollectionTools.sort((List)CollectionTools.list((Iterator)connectionInfo.schemaNames())).iterator();
            while (schemaNames.hasNext()) {
                this.schemaNameCombo.add((String)schemaNames.next());
            }
            String schemaName = this.getPersistenceProject().getSchemaName();
            if (schemaName != null) {
                this.schemaNameCombo.select(this.schemaNameCombo.indexOf(schemaName));
            }
        }
    }

    protected void performApply() {
        this.performOk();
    }

    public boolean performOk() {
        this.getPersistenceProject().setConnectionInfoName(this.connectionInfoCombo.getText());
        this.getPersistenceProject().setSchemaName(this.schemaNameCombo.getText());
        return true;
    }
}

