/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.GeneratedValue;
import org.eclipse.dali.core.GeneratorType;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.GeneratedValueItemProvider;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.IdMappingComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class GeneratedValueComposite
extends Composite
implements IPersistenceComposite {
    private GeneratedValue generatedValue;
    private INotifyChangedListener generatedValueListener;
    protected EditingDomain editingDomain;
    protected DaliItemProviderAdapterFactory adapterFactory;
    private GeneratedValueItemProvider generatedValueItemProvider;
    private ComboViewer strategyComboViewer;
    private ITextViewer generatorNameViewer;
    protected boolean populating;
    static /* synthetic */ Class class$0;

    public GeneratedValueComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.initialize();
        this.initializeLayout();
    }

    private void initialize() {
        this.generatedValueItemProvider = (GeneratedValueItemProvider)this.adapterFactory.createGeneratedValueAdapter();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Group generatedValueGroup = new Group((Composite)this, 16);
        generatedValueGroup.setText("Generated Value");
        generatedValueGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        generatedValueGroup.setLayoutData((Object)gridData);
        Label strategyTypeLabel = new Label((Composite)generatedValueGroup, 16384);
        strategyTypeLabel.setText("Strategy:");
        this.strategyComboViewer = this.buildStrategyComboViewer((Composite)generatedValueGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.strategyComboViewer.getCombo().setLayoutData((Object)gridData);
        Label generatorNameLabel = new Label((Composite)generatedValueGroup, 16384);
        generatorNameLabel.setText("Generator Name:");
        this.generatorNameViewer = this.buildGeneratorNameViewer((Composite)generatedValueGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.generatorNameViewer.getTextWidget().setLayoutData((Object)gridData);
    }

    private ComboViewer buildStrategyComboViewer(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(GeneratorType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (GeneratedValueComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    GeneratorType selectedType = (GeneratorType)selection.getFirstElement();
                    if (!GeneratedValueComposite.this.generatedValue.getStrategy().equals(selectedType)) {
                        GeneratedValueComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)GeneratedValueComposite.this.editingDomain, (Object)GeneratedValueComposite.this.generatedValue, (Object)DaliPackage.eINSTANCE.getGeneratedValue_Strategy(), (Object)selectedType));
                    }
                }
            }
        });
        return viewer;
    }

    private ITextViewer buildGeneratorNameViewer(Composite parent) {
        final TextViewer textViewer = new TextViewer(parent, 2052);
        textViewer.setDocument((IDocument)new Document());
        textViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (GeneratedValueComposite.this.populating) {
                    return;
                }
                String generatorName = textViewer.getDocument().get();
                if (GeneratedValueComposite.this.generatedValue != null && generatorName.equals("")) {
                    if (GeneratedValueComposite.this.generatedValue.getSpecifiedGeneratorName() == null) {
                        return;
                    }
                    generatorName = null;
                }
                GeneratedValueComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)GeneratedValueComposite.this.editingDomain, (Object)GeneratedValueComposite.this.generatedValue, (Object)DaliPackage.eINSTANCE.getGeneratedValue_SpecifiedGeneratorName(), (Object)generatorName));
            }
        });
        return textViewer;
    }

    private INotifyChangedListener getGeneratedValueListener() {
        if (this.generatedValueListener == null) {
            this.generatedValueListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    GeneratedValueComposite.this.generatedValueChanged(notification);
                }
            };
        }
        return this.generatedValueListener;
    }

    protected void generatedValueChanged(Notification notification) {
        if (notification.getFeatureID(GeneratedValue.class) == 0) {
            final GeneratorType strategy = (GeneratorType)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (GeneratedValueComposite.this.selectedStrategy() != strategy) {
                        GeneratedValueComposite.this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)strategy));
                    }
                    if (strategy.getValue() != 4 && strategy.getValue() != 2) {
                        GeneratedValueComposite.this.removeGeneratorComposite();
                    }
                }
            });
        } else if (notification.getFeatureID(GeneratedValue.class) == 1) {
            final String generatorName = notification.getNewStringValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (generatorName == null && !GeneratedValueComposite.this.generatorNameViewer.getDocument().get().equals("")) {
                        GeneratedValueComposite.this.generatorNameViewer.getDocument().set("");
                    } else if (!GeneratedValueComposite.this.generatorNameViewer.getDocument().get().equals(generatorName)) {
                        GeneratedValueComposite.this.generatorNameViewer.getDocument().set(generatorName);
                    }
                }
            });
        }
    }

    private void updateGeneratorComposite(GeneratorType newGeneratorType) {
        ((IdMappingComposite)this.getParent()).updateGeneratorComposite(newGeneratorType);
    }

    private void removeGeneratorComposite() {
        ((IdMappingComposite)this.getParent()).removeGeneratorComposite();
    }

    public void populate(EObject model) {
        this.populating = true;
        if (this.generatedValue != null) {
            this.generatedValueItemProvider.removeListener(this.getGeneratedValueListener());
            this.generatedValue.eAdapters().remove((Object)this.generatedValueItemProvider);
        }
        if (model == null) {
            return;
        }
        this.generatedValue = (GeneratedValue)model;
        this.generatedValueItemProvider.addListener(this.getGeneratedValueListener());
        this.generatedValue.eAdapters().add((Object)this.generatedValueItemProvider);
        this.populateStrategyCombo();
        this.populating = false;
    }

    private void populateStrategyCombo() {
        GeneratorType selectedType = this.selectedStrategy();
        GeneratorType strategy = this.generatedValue.getStrategy();
        if (strategy == GeneratorType.AUTO_LITERAL) {
            if (selectedType != GeneratorType.AUTO_LITERAL) {
                this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)GeneratorType.AUTO_LITERAL));
            }
        } else if (strategy == GeneratorType.SEQUENCE_LITERAL) {
            if (selectedType != GeneratorType.SEQUENCE_LITERAL) {
                this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)GeneratorType.SEQUENCE_LITERAL));
            }
        } else if (strategy == GeneratorType.IDENTITY_LITERAL) {
            if (selectedType != GeneratorType.IDENTITY_LITERAL) {
                this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)GeneratorType.IDENTITY_LITERAL));
            }
        } else if (strategy == GeneratorType.TABLE_LITERAL) {
            if (selectedType != GeneratorType.TABLE_LITERAL) {
                this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)GeneratorType.TABLE_LITERAL));
            }
        } else if (selectedType != GeneratorType.DEFAULT_LITERAL) {
            this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)GeneratorType.DEFAULT_LITERAL));
        }
    }

    public boolean setFocus() {
        super.setFocus();
        return this.strategyComboViewer.getCombo().setFocus();
    }

    private GeneratorType selectedStrategy() {
        return (GeneratorType)((StructuredSelection)this.strategyComboViewer.getSelection()).getFirstElement();
    }
}

