/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import org.eclipse.dali.core.Entity;
import org.eclipse.dali.core.JoinColumn;
import org.eclipse.dali.core.JoinTable;
import org.eclipse.dali.core.ManyToMany;
import org.eclipse.dali.db.wrappers.TableWrapper;
import org.eclipse.dali.ui.views.JoinColumnDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Shell;

public class InverseJoinColumnDialog
extends JoinColumnDialog {
    InverseJoinColumnDialog(Shell parent, JoinColumn joinColumn) {
        super(parent, joinColumn);
    }

    protected String getTitle() {
        return "Edit Inverse Join Column";
    }

    protected void populateNameCombo(Combo nameCombo) {
        nameCombo.add("Default ( " + this.getJoinColumn().getDefaultName() + ")");
        TableWrapper joinDBTable = ((JoinTable)this.getJoinColumn().getParent()).getDBTable();
        if (joinDBTable != null) {
            Iterator i = joinDBTable.getColumnNames().iterator();
            while (i.hasNext()) {
                nameCombo.add((String)i.next());
            }
        }
        if (this.getJoinColumn().getSpecifiedReferencedColumnName() != null) {
            nameCombo.setText(this.getJoinColumn().getSpecifiedReferencedColumnName());
        } else {
            nameCombo.select(0);
        }
    }

    protected void populateReferencedNameCombo(Combo referencedColumnNameCombo) {
        TableWrapper referencedDbTable;
        referencedColumnNameCombo.add("Default ( " + this.getJoinColumn().getDefaultReferencedColumnName() + ")");
        ManyToMany manyToManyMapping = (ManyToMany)((JoinTable)this.getJoinColumn().getParent()).getParent();
        Entity targetEntity = manyToManyMapping.getResolvedTargetEntity();
        if (targetEntity != null && (referencedDbTable = targetEntity.getResolvedDBTable()) != null) {
            Iterator i = referencedDbTable.getColumnNames().iterator();
            while (i.hasNext()) {
                referencedColumnNameCombo.add((String)i.next());
            }
        }
        if (this.getJoinColumn().getSpecifiedReferencedColumnName() != null) {
            referencedColumnNameCombo.setText(this.getJoinColumn().getSpecifiedReferencedColumnName());
        } else {
            referencedColumnNameCombo.select(0);
        }
    }
}

