/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import org.eclipse.dali.core.Column;
import org.eclipse.dali.core.ColumnPersistentAttributeFlavor;
import org.eclipse.dali.core.Entity;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.PersistentAttribute;
import org.eclipse.dali.core.PersistentAttributeFlavor;
import org.eclipse.dali.core.PersistentTypeFlavor;
import org.eclipse.dali.core.adapters.IColumnModelAdapter;
import org.eclipse.dali.core.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.core.adapters.java.Attribute;
import org.eclipse.dali.core.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.core.adapters.java.Member;
import org.eclipse.dali.core.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaColumnModelAdapter
implements IColumnModelAdapter {
    private Column column;
    private StringAnnotationElementAdapter specifiedNameAdapter = new StringAnnotationElementAdapter(this.buildSpecifiedNameElementInfo());
    private StringAnnotationElementAdapter specifiedTableNameAdapter = new StringAnnotationElementAdapter(this.buildSpecifiedTableNameElementInfo());

    JavaColumnModelAdapter() {
    }

    public void engage(Column column, CompilationUnit astRoot) {
        this.column = column;
        this.updatePersModel(astRoot);
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildSpecifiedNameElementInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaColumnModelAdapter.this.column.setSpecifiedName(newValue);
            }

            public String persValue() {
                return JavaColumnModelAdapter.this.column.getSpecifiedName();
            }

            public String annotationElementName() {
                return "name";
            }

            public String annotationName() {
                return "Column";
            }

            public Member member() {
                return JavaColumnModelAdapter.this.attribute();
            }

            public String defaultValue() {
                return null;
            }
        };
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildSpecifiedTableNameElementInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaColumnModelAdapter.this.column.setSpecifiedTableName(newValue);
            }

            public String persValue() {
                return JavaColumnModelAdapter.this.column.getSpecifiedTableName();
            }

            public String annotationElementName() {
                return "table";
            }

            public String annotationName() {
                return "Column";
            }

            public Member member() {
                return JavaColumnModelAdapter.this.attribute();
            }

            public String defaultValue() {
                return null;
            }
        };
    }

    private void updatePersModel(CompilationUnit astRoot) {
        this.updatePersDefaultName();
        this.updatePersSpecifiedName(astRoot);
        this.updatePersDefaultTableName();
        this.updatePersSpecifiedTableName(astRoot);
    }

    private void updatePersDefaultName() {
        String name = this.defaultName();
        String persName = this.column.getDefaultName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.column.setDefaultName(name);
        }
    }

    private String defaultName() {
        ColumnPersistentAttributeFlavor flavor = (ColumnPersistentAttributeFlavor)this.column.eContainer();
        String attributeName = ((PersistentAttribute)flavor.eContainer()).getName();
        return attributeName;
    }

    private void updatePersSpecifiedName(CompilationUnit astRoot) {
        this.specifiedNameAdapter.updatePersElement(astRoot);
    }

    private void updatePersDefaultTableName() {
        String name = this.defaultTableName();
        String persName = this.column.getDefaultTableName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.column.setDefaultTableName(name);
        }
    }

    private void updatePersSpecifiedTableName(CompilationUnit astRoot) {
        this.specifiedTableNameAdapter.updatePersElement(astRoot);
    }

    private String defaultTableName() {
        PersistentAttributeFlavor flavor = (PersistentAttributeFlavor)this.column.eContainer();
        PersistentTypeFlavor persistentTypeFlavor = flavor.getPersistentTypeFlavor();
        if (persistentTypeFlavor.getKey() == Entity.Key.INSTANCE) {
            return ((Entity)persistentTypeFlavor).getTable().getName();
        }
        return null;
    }

    public void specifiedNameChanged() {
        this.specifiedNameAdapter.updateJavaElement();
    }

    public void specifiedTableNameChanged() {
        this.specifiedTableNameAdapter.updateJavaElement();
    }

    private Attribute attribute() {
        PersistentAttribute persistentAttribute = this.column.getPersistentAttributeFlavor().getPersistentAttribute();
        JavaPersistentAttributeModelAdapter modelAdapter = (JavaPersistentAttributeModelAdapter)persistentAttribute.getModelAdapter();
        return modelAdapter.getAttribute();
    }

    public ITextRange getTextRange() {
        return this.attribute().getTextRange("Column");
    }

    public ITextRange nameTextRange() {
        return this.specifiedNameAdapter.getTextRange();
    }

    public ITextRange tableNameTextRange() {
        return this.specifiedTableNameAdapter.getTextRange();
    }
}

