/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.iterators.CompositeListIterator;
import org.eclipse.dali.utility.tests.iterators.CompositeIteratorTests;

public class CompositeListIteratorTests
extends CompositeIteratorTests {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.CompositeListIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.CompositeListIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public CompositeListIteratorTests(String name) {
        super(name);
    }

    void verifyHasAnother(Iterator stream) {
        super.verifyHasAnother(stream);
        ListIterator stream2 = (ListIterator)stream;
        int i = 0;
        while (stream2.hasPrevious()) {
            stream2.previous();
            ++i;
        }
        CompositeListIteratorTests.assertEquals((int)8, (int)i);
    }

    void verifyAnother(Iterator stream) {
        super.verifyAnother(stream);
        int i = 8;
        ListIterator stream2 = (ListIterator)stream;
        while (stream2.hasPrevious()) {
            CompositeListIteratorTests.assertEquals((String)"bogus element", (String)String.valueOf(i--), (String)((String)stream2.previous()).substring(0, 1));
        }
    }

    public void testRemove() {
        super.testRemove();
        List list1 = this.buildList1();
        List list2 = this.buildList2();
        List list3 = this.buildList3();
        Object firstElement3 = list3.get(0);
        ArrayList list = new ArrayList();
        list.add(list1.listIterator());
        list.add(list2.listIterator());
        list.add(list3.listIterator());
        ListIterator stream = (ListIterator)this.buildCompositeIterator(list.listIterator());
        while (stream.hasNext()) {
            stream.next();
        }
        while (stream.hasPrevious()) {
            Object previous = stream.previous();
            if (previous.equals("333")) {
                stream.remove();
            }
            if (!previous.equals(firstElement3)) continue;
            stream.hasPrevious();
            stream.remove();
        }
        stream.remove();
        CompositeListIteratorTests.assertEquals((String)"nothing removed from collection 1", (int)(this.buildList1().size() - 2), (int)list1.size());
        CompositeListIteratorTests.assertFalse((String)"element still in collection 1", (boolean)list1.contains("1"));
        CompositeListIteratorTests.assertFalse((String)"element still in collection 1", (boolean)list1.contains("333"));
        CompositeListIteratorTests.assertEquals((String)"nothing removed from collection 3", (int)(this.buildList3().size() - 1), (int)list3.size());
        CompositeListIteratorTests.assertFalse((String)"first element still in collection 3", (boolean)list3.contains(firstElement3));
        CompositeListIteratorTests.assertTrue((String)"wrong element removed from collection 3", (boolean)list3.contains("666666"));
    }

    public void testAdd() {
        List list1 = this.buildList1();
        Object lastElement1 = list1.get(list1.size() - 1);
        List list2 = this.buildList2();
        List list3 = this.buildList3();
        Object firstElement3 = list3.get(0);
        ArrayList list = new ArrayList();
        list.add(list1.listIterator());
        list.add(list2.listIterator());
        list.add(list3.listIterator());
        ListIterator stream = (ListIterator)this.buildCompositeIterator(list.listIterator());
        while (stream.hasNext()) {
            Object next = stream.next();
            if (next.equals("333")) {
                stream.add("3.5");
            }
            if (!next.equals(lastElement1)) continue;
            stream.hasNext();
            stream.add("something in 3");
        }
        stream.add("finale");
        boolean checkForFinale = true;
        while (stream.hasPrevious()) {
            Object previous = stream.previous();
            if (checkForFinale) {
                checkForFinale = false;
                CompositeListIteratorTests.assertEquals((String)"added element dropped", (Object)"finale", previous);
            }
            if (previous.equals("333")) {
                stream.add("2.5");
            }
            if (!previous.equals(firstElement3)) continue;
            stream.hasPrevious();
            stream.add("old start of 3");
        }
        stream.add("prelude");
        CompositeListIteratorTests.assertEquals((String)"added element dropped", (Object)"prelude", stream.previous());
        CompositeListIteratorTests.assertEquals((String)"elements not added to collection 1", (int)(this.buildList1().size() + 3), (int)list1.size());
        CompositeListIteratorTests.assertEquals((String)"element not added to collection 1", (Object)"prelude", list1.get(0));
        CompositeListIteratorTests.assertEquals((String)"element not added to collection 1", (Object)"2.5", list1.get(3));
        CompositeListIteratorTests.assertEquals((String)"element not added to collection 1", (Object)"3.5", list1.get(5));
        CompositeListIteratorTests.assertEquals((String)"elements not added to collection 3", (int)(this.buildList3().size() + 3), (int)list3.size());
        CompositeListIteratorTests.assertEquals((String)"element not added to collection 3", (Object)"something in 3", list3.get(0));
        CompositeListIteratorTests.assertEquals((String)"element not added to collection 3", (Object)"old start of 3", list3.get(1));
        CompositeListIteratorTests.assertEquals((String)"element not added to collection 3", (Object)"finale", list3.get(list3.size() - 1));
        stream = (ListIterator)this.buildCompositeIterator();
        stream.add("blah");
        CompositeListIteratorTests.assertFalse((String)"added element should be placed BEFORE the \"cursor\"", (boolean)stream.next().equals("blah"));
        stream = (ListIterator)this.buildCompositeIterator();
        stream.add("blah");
        CompositeListIteratorTests.assertTrue((String)"added element should be placed BEFORE the \"cursor\"", (boolean)stream.previous().equals("blah"));
        stream = (ListIterator)this.buildCompositeIterator();
        while (stream.hasNext()) {
            stream.next();
        }
        while (stream.hasPrevious()) {
            stream.previous();
        }
        stream.add("blah");
        CompositeListIteratorTests.assertFalse((String)"added element should be placed BEFORE the \"cursor\"", (boolean)stream.next().equals("blah"));
        stream = (ListIterator)this.buildCompositeIterator();
        while (stream.hasNext()) {
            stream.next();
        }
        while (stream.hasPrevious()) {
            stream.previous();
        }
        stream.add("blah");
        CompositeListIteratorTests.assertTrue((String)"added element should be placed BEFORE the \"cursor\"", (boolean)stream.previous().equals("blah"));
        stream = (ListIterator)this.buildCompositeIterator();
        stream.next();
        stream.add("blah");
        CompositeListIteratorTests.assertFalse((String)"added element should be placed BEFORE the \"cursor\"", (boolean)stream.next().equals("blah"));
        stream = (ListIterator)this.buildCompositeIterator();
        stream.next();
        stream.add("blah");
        CompositeListIteratorTests.assertTrue((String)"added element should be placed BEFORE the \"cursor\"", (boolean)stream.previous().equals("blah"));
        stream = (ListIterator)this.buildCompositeIterator();
        while (stream.hasNext()) {
            stream.next();
        }
        stream.previous();
        stream.add("blah");
        CompositeListIteratorTests.assertFalse((String)"added element should be placed BEFORE the \"cursor\"", (boolean)stream.next().equals("blah"));
        stream = (ListIterator)this.buildCompositeIterator();
        while (stream.hasNext()) {
            stream.next();
        }
        stream.previous();
        stream.add("blah");
        CompositeListIteratorTests.assertTrue((String)"added element should be placed BEFORE the \"cursor\"", (boolean)stream.previous().equals("blah"));
        stream = (ListIterator)this.buildCompositeIterator();
        while (stream.hasNext()) {
            stream.next();
        }
        stream.add("blah");
        CompositeListIteratorTests.assertFalse((String)"added element should be placed BEFORE the \"cursor\"", (boolean)stream.hasNext());
        stream = (ListIterator)this.buildCompositeIterator();
        while (stream.hasNext()) {
            stream.next();
        }
        stream.add("blah");
        CompositeListIteratorTests.assertTrue((String)"added element should be placed BEFORE the \"cursor\"", (boolean)stream.previous().equals("blah"));
    }

    public void testSet() {
        List list1 = this.buildList1();
        Object lastElement1 = list1.get(list1.size() - 1);
        List list2 = this.buildList2();
        List list3 = this.buildList3();
        Object firstElement3 = list3.get(0);
        ArrayList list = new ArrayList();
        list.add(list1.listIterator());
        list.add(list2.listIterator());
        list.add(list3.listIterator());
        ListIterator stream = (ListIterator)this.buildCompositeIterator(list.listIterator());
        while (stream.hasNext()) {
            Object next = stream.next();
            if (next.equals("333")) {
                stream.set("333a");
            }
            if (!next.equals(lastElement1)) continue;
            stream.hasNext();
            stream.set("end of 1");
        }
        while (stream.hasPrevious()) {
            Object previous = stream.previous();
            if (previous.equals("22")) {
                stream.set("22a");
            }
            if (!previous.equals(firstElement3)) continue;
            stream.hasPrevious();
            stream.set("start of 3");
        }
        CompositeListIteratorTests.assertEquals((String)"element(s) added to collection 1", (int)this.buildList1().size(), (int)list1.size());
        CompositeListIteratorTests.assertEquals((String)"element not set in collection 1", (Object)"22a", list1.get(1));
        CompositeListIteratorTests.assertFalse((String)"element not set in collection 1", (boolean)list1.contains("22"));
        CompositeListIteratorTests.assertEquals((String)"element not set in collection 1", (Object)"333a", list1.get(2));
        CompositeListIteratorTests.assertFalse((String)"element not set in collection 1", (boolean)list1.contains("333"));
        CompositeListIteratorTests.assertEquals((String)"element not set in collection 1", (Object)"end of 1", list1.get(list1.size() - 1));
        CompositeListIteratorTests.assertFalse((String)"element not set in collection 1", (boolean)list1.contains(lastElement1));
        CompositeListIteratorTests.assertEquals((String)"element(s) added to collection 3", (int)this.buildList3().size(), (int)list3.size());
        CompositeListIteratorTests.assertEquals((String)"element not set in collection 3", (Object)"start of 3", list3.get(0));
        CompositeListIteratorTests.assertFalse((String)"element not set in collection 3", (boolean)list3.contains(firstElement3));
    }

    public void testNextIndexPreviousIndex() {
        int i = 0;
        ListIterator stream = (ListIterator)this.buildCompositeIterator();
        CompositeListIteratorTests.assertEquals((int)i, (int)stream.nextIndex());
        CompositeListIteratorTests.assertEquals((int)(i - 1), (int)stream.previousIndex());
        while (stream.hasNext()) {
            Object next = stream.next();
            ++i;
            if (next.equals("333")) {
                stream.remove();
                --i;
            }
            if (next.equals("7777777")) {
                stream.add("7.5");
                ++i;
            }
            CompositeListIteratorTests.assertEquals((int)i, (int)stream.nextIndex());
            CompositeListIteratorTests.assertEquals((int)(i - 1), (int)stream.previousIndex());
        }
        CompositeListIteratorTests.assertEquals((String)"index is corrupt", (int)8, (int)i);
        CompositeListIteratorTests.assertEquals((int)i, (int)stream.nextIndex());
        CompositeListIteratorTests.assertEquals((int)(i - 1), (int)stream.previousIndex());
        while (stream.hasPrevious()) {
            Object previous = stream.previous();
            --i;
            if (previous.equals("666666")) {
                stream.remove();
            }
            if (previous.equals("22")) {
                stream.add("1.5");
                ++i;
            }
            CompositeListIteratorTests.assertEquals((int)i, (int)stream.nextIndex());
            CompositeListIteratorTests.assertEquals((int)(i - 1), (int)stream.previousIndex());
        }
        CompositeListIteratorTests.assertEquals((String)"index is corrupt", (int)0, (int)i);
    }

    public void testPreviousIndex() {
    }

    void verifyNoSuchElementException(Iterator stream) {
        super.verifyNoSuchElementException(stream);
        ListIterator stream2 = (ListIterator)stream;
        boolean exCaught = false;
        String string = null;
        while (stream2.hasPrevious()) {
            string = (String)stream2.previous();
        }
        try {
            string = (String)stream2.previous();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        CompositeListIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    void verifyUnsupportedOperationException(Iterator stream) {
        super.verifyUnsupportedOperationException(stream);
        boolean exCaught = false;
        ListIterator stream2 = (ListIterator)stream;
        while (stream2.hasPrevious()) {
            Object string = stream2.previous();
            if (!string.equals("333")) continue;
            try {
                stream2.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        CompositeListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    void verifyIllegalStateException(Iterator stream) {
        super.verifyIllegalStateException(stream);
        ListIterator stream2 = (ListIterator)stream;
        boolean exCaught = false;
        try {
            stream2.set("junk");
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        CompositeListIteratorTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
    }

    void verifyEmptyHasAnother(Iterator stream) {
        super.verifyEmptyHasAnother(stream);
        ListIterator stream2 = (ListIterator)stream;
        int i = 0;
        while (stream2.hasPrevious()) {
            stream2.previous();
            ++i;
        }
        CompositeListIteratorTests.assertEquals((int)0, (int)i);
    }

    Iterator buildCompositeIterator(Iterator iterators) {
        return this.buildCompositeListIterator((ListIterator)iterators);
    }

    ListIterator buildCompositeListIterator(ListIterator iterators) {
        return new CompositeListIterator(iterators);
    }

    Iterator buildCompositeIterator(Object object, ListIterator iterator) {
        return this.buildCompositeListIterator(object, iterator);
    }

    ListIterator buildCompositeListIterator(Object object, ListIterator iterator) {
        return new CompositeListIterator(object, iterator);
    }
}

