/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.ProjectJSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.ProjectJSFLibraryProvider;

public class ProjectJSFLibraryMetaData {
    private IProject fProject;
    private ProjectJSFLibraryProvider provider;
    private ProjectJSFLibrary selJSFLibImpl = null;
    private List selJSFLibComp = null;

    protected ProjectJSFLibraryMetaData(ProjectJSFLibraryProvider provider) {
        this.fProject = provider.getProject();
        this.provider = provider;
    }

    protected ProjectJSFLibrary getSelectedJSFLibImplementation() {
        block3: {
            try {
                if (this.selJSFLibImpl == null) {
                    String strImplLibs = this.fProject.getPersistentProperty(new QualifiedName("", "jsf.implementation.libraries"));
                    this.selJSFLibImpl = this.getSelectedJSFLibImpl(this.getTuples(strImplLibs));
                }
            }
            catch (CoreException coreException) {
                JSFLibrary jsfLib;
                if (JSFCorePlugin.getDefault().getJSFLibraryRegistry() == null || (jsfLib = JSFCorePlugin.getDefault().getJSFLibraryRegistry().getDefaultImplementation()) == null) break block3;
                this.selJSFLibImpl = new ProjectJSFLibrary(jsfLib, true, jsfLib.isDeployed());
            }
        }
        return this.selJSFLibImpl;
    }

    protected List getSelectedJSFLibComponent() {
        try {
            if (this.selJSFLibComp == null) {
                this.selJSFLibComp = new ArrayList(Collections.EMPTY_LIST);
                String strCompLibs = this.fProject.getPersistentProperty(new QualifiedName("", "jsf.component.libraries"));
                this.initJSFCompLibs(this.getTuples(strCompLibs), this.selJSFLibComp);
            }
        }
        catch (CoreException coreException) {}
        return this.selJSFLibComp;
    }

    protected void saveMetaData(List selJSFLibImpl, List selJSFLibComp) {
        try {
            this.fProject.setPersistentProperty(new QualifiedName("", "jsf.implementation.libraries"), this.generatePersistString(selJSFLibImpl));
            this.fProject.setPersistentProperty(new QualifiedName("", "jsf.component.libraries"), this.generatePersistString(selJSFLibComp));
            this.selJSFLibImpl = null;
            this.selJSFLibComp = null;
        }
        catch (CoreException coreException) {}
    }

    private ProjectJSFLibrary getSelectedJSFLibImpl(List jsfLibTuples) {
        Iterator itTuple = jsfLibTuples.iterator();
        while (itTuple.hasNext()) {
            JSFLibraryRegistry jsfLibReg;
            JSFLibrary jsfLib;
            Tuple tuple = (Tuple)itTuple.next();
            if (this.provider.getJSFLibraryRegistry() == null || (jsfLib = (jsfLibReg = this.provider.getJSFLibraryRegistry()).getJSFLibraryByID(tuple.ID)) == null) continue;
            return new ProjectJSFLibrary(jsfLib, tuple.selected, tuple.deploy);
        }
        return null;
    }

    private void initJSFCompLibs(List jsfLibTuples, List prjJSFLibs) {
        Iterator itTuple = jsfLibTuples.iterator();
        while (itTuple.hasNext()) {
            JSFLibraryRegistry jsfLibReg;
            JSFLibrary jsfLib;
            Tuple tuple = (Tuple)itTuple.next();
            if (this.provider.getJSFLibraryRegistry() == null || (jsfLib = (jsfLibReg = this.provider.getJSFLibraryRegistry()).getJSFLibraryByID(tuple.ID)) == null) continue;
            ProjectJSFLibrary newPrjJSFLib = new ProjectJSFLibrary(jsfLib, tuple.selected, tuple.deploy);
            prjJSFLibs.add(newPrjJSFLib);
        }
    }

    private String generatePersistString(List list) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            ProjectJSFLibrary jsfLibItem = (ProjectJSFLibrary)list.get(i);
            JSFLibrary jsfLib = jsfLibItem.getLibrary();
            String tmp = String.valueOf(jsfLib.getID()) + ":" + String.valueOf(jsfLibItem.isSelected()) + ":" + String.valueOf(jsfLibItem.needDeploy());
            sb = sb.append(String.valueOf(tmp) + ";");
            ++i;
        }
        return sb.toString();
    }

    private List getTuples(String strJSFLibs) {
        String patternStr = ";";
        String[] fields = strJSFLibs.split(patternStr);
        ArrayList<Tuple> list = new ArrayList<Tuple>(Collections.EMPTY_LIST);
        if (strJSFLibs.length() > 0) {
            int i = 0;
            while (i < fields.length) {
                Tuple tuple = new Tuple(fields[i]);
                list.add(tuple);
                ++i;
            }
        }
        return list;
    }

    class Tuple {
        private String ID;
        private boolean selected = false;
        private boolean deploy = false;

        Tuple(String ID, boolean selected, boolean deploy) {
            this.ID = ID;
            this.selected = selected;
            this.deploy = deploy;
        }

        Tuple(String tuple) {
            String patternStr = ":";
            String[] fields = tuple.split(patternStr);
            this.ID = fields[0];
            this.selected = Boolean.valueOf(fields[1]);
            this.deploy = Boolean.valueOf(fields[2]);
        }

        String getID() {
            return this.ID;
        }

        boolean isSelected() {
            return this.selected;
        }

        boolean needDeploy() {
            return this.deploy;
        }
    }
}

