/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.FromViewIdType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.emf.ToViewIdType;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.Pageflow;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowFactory;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowLink;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowNode;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization.FC2PFTransformer;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowModelManager;
import org.eclipse.jst.jsf.facesconfig.ui.util.WebrootUtil;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class PageflowTransform {
    private static final String CONDITION_SEPERATOR = ";";
    private static PageflowTransform transform;
    private Map mapLinkHelper = null;
    private Map mapUpdatedNavigationCase = null;
    private Map mapLinkNavigationRule = null;
    private FacesConfigFactory facesConfigFactory = null;
    private PageflowFactory pageflowFactory;
    private Pageflow pageflow;

    private PageflowTransform() {
    }

    public static PageflowTransform getInstance() {
        if (transform == null) {
            transform = new PageflowTransform();
        }
        return transform;
    }

    public void updateFacesConfigModel(Pageflow pageflow, IStructuredModel sseModel) {
    }

    public boolean updatePageflowModelFromEMF(Pageflow pageflow, FacesConfigType emfModel) {
        if (pageflow != null && emfModel != null) {
            this.pageflow = pageflow;
            EList navigationRulesInFacesconfig = emfModel.getNavigationRule();
            FC2PFTransformer.getInstance().clearCaches();
            return this.updateNavigationRulesInPageflowFromFacesConfig((List)navigationRulesInFacesconfig, pageflow);
        }
        return false;
    }

    private boolean hasSameFromViewID(FromViewIdType fromViewID1, FromViewIdType fromViewID2) {
        String viewID1 = null;
        viewID1 = fromViewID1 == null ? "*" : fromViewID1.getTextContent().trim();
        String viewID2 = null;
        viewID2 = fromViewID2 == null ? "*" : fromViewID2.getTextContent().trim();
        return viewID1.equalsIgnoreCase(viewID2);
    }

    public void updatePageflowSourcePage(PageflowPage sourcePage, NavigationRuleType navigationRuleFC) {
        if (navigationRuleFC.getDescription() != null && navigationRuleFC.getDescription().size() > 0) {
            String description = ((DescriptionType)navigationRuleFC.getDescription().get(0)).getTextContent();
            sourcePage.setComment(description);
        }
        if (navigationRuleFC.getDisplayName() != null && navigationRuleFC.getDisplayName().size() > 0) {
            String displayName = ((DisplayNameType)navigationRuleFC.getDisplayName().get(0)).getTextContent();
            sourcePage.setName(displayName);
        }
        if (navigationRuleFC.getIcon() != null && navigationRuleFC.getIcon().size() > 0) {
            boolean largeUpdated = false;
            boolean smallUpdated = false;
            int i = 0;
            while (i < navigationRuleFC.getIcon().size()) {
                IconType icon = (IconType)navigationRuleFC.getIcon().get(i);
                if (!largeUpdated && icon.getLargeIcon() != null) {
                    sourcePage.setLargeicon(icon.getLargeIcon().getTextContent());
                    largeUpdated = true;
                }
                if (!smallUpdated && icon.getSmallIcon() != null) {
                    sourcePage.setSmallicon(icon.getSmallIcon().getTextContent());
                    smallUpdated = true;
                }
                if (largeUpdated && smallUpdated) {
                    return;
                }
                ++i;
            }
        }
    }

    public void updatePageflowTargetPage(PageflowPage targetPage, NavigationCaseType navigationCaseFC) {
        if (navigationCaseFC.getDescription() != null && navigationCaseFC.getDescription().size() > 0) {
            String description = ((DescriptionType)navigationCaseFC.getDescription().get(0)).getTextContent();
            targetPage.setComment(description);
        }
        if (navigationCaseFC.getDisplayName() != null && navigationCaseFC.getDisplayName().size() > 0) {
            String displayName = ((DisplayNameType)navigationCaseFC.getDisplayName().get(0)).getTextContent();
            targetPage.setName(displayName);
        }
        if (navigationCaseFC.getIcon() != null && navigationCaseFC.getIcon().size() > 0) {
            boolean largeUpdated = false;
            boolean smallUpdated = false;
            int i = 0;
            while (i < navigationCaseFC.getIcon().size()) {
                IconType icon = (IconType)navigationCaseFC.getIcon().get(0);
                if (!largeUpdated && icon.getLargeIcon() != null) {
                    targetPage.setLargeicon(icon.getLargeIcon().getTextContent());
                    largeUpdated = true;
                }
                if (!smallUpdated && icon.getSmallIcon() != null) {
                    targetPage.setSmallicon(icon.getSmallIcon().getTextContent());
                    smallUpdated = true;
                }
                if (largeUpdated && smallUpdated) {
                    return;
                }
                ++i;
            }
        }
    }

    private boolean hasSameToViewID(ToViewIdType toViewID1, String toViewID2) {
        String viewID1 = null;
        viewID1 = toViewID1 == null ? "" : toViewID1.getTextContent().trim();
        String viewID2 = null;
        viewID2 = toViewID2 == null ? "" : toViewID2.trim();
        return viewID1.equalsIgnoreCase(viewID2);
    }

    private boolean hasSameToViewID(ToViewIdType toViewID1, ToViewIdType toViewID2) {
        String viewID1 = null;
        viewID1 = toViewID1 == null ? "" : toViewID1.getTextContent().trim();
        String viewID2 = null;
        viewID2 = toViewID2 == null ? "" : toViewID2.getTextContent().trim();
        return viewID1.equalsIgnoreCase(viewID2);
    }

    private FacesConfigFactory getFacesConfigFactory() {
        if (this.facesConfigFactory == null) {
            this.facesConfigFactory = FacesConfigFactory.eINSTANCE;
        }
        return this.facesConfigFactory;
    }

    private NavigationRuleType getNavigationRule(String fromViewIdPath, List navigationRulesInPageflow) {
        NavigationRuleType navigationRule = null;
        FacesConfigFactory factory = this.getFacesConfigFactory();
        FromViewIdType fromViewId = factory.createFromViewIdType();
        fromViewId.setTextContent(fromViewIdPath);
        boolean bFound = false;
        Iterator iter = navigationRulesInPageflow.iterator();
        while (iter.hasNext() && !bFound) {
            NavigationRuleType rule = (NavigationRuleType)iter.next();
            if (!this.hasSameFromViewID(fromViewId, rule.getFromViewId())) continue;
            navigationRule = rule;
            bFound = true;
        }
        if (!bFound) {
            navigationRule = factory.createNavigationRuleType();
            FromViewIdType fromViewid = factory.createFromViewIdType();
            fromViewid.setTextContent(fromViewIdPath);
            navigationRule.setFromViewId(fromViewid);
            navigationRulesInPageflow.add(navigationRule);
        }
        return navigationRule;
    }

    private boolean updateNavigationRulesInPageflowFromFacesConfig(List rulesFC, Pageflow pageflow) {
        boolean isNew = false;
        if (rulesFC == null || rulesFC.isEmpty()) {
            Iterator iterLink = pageflow.getLinks().iterator();
            while (iterLink.hasNext()) {
                PageflowLink link = (PageflowLink)iterLink.next();
                link.getSource().getOutlinks().remove((Object)link);
                link.getTarget().getInlinks().remove((Object)link);
            }
            pageflow.getLinks().clear();
        } else {
            this.mapUpdatedNavigationCase = new HashMap();
            Iterator iterRulesFC = rulesFC.iterator();
            while (iterRulesFC.hasNext()) {
                NavigationRuleType ruleFC = (NavigationRuleType)iterRulesFC.next();
                EList casesFC = ruleFC.getNavigationCase();
                Iterator iterCasesFC = casesFC.iterator();
                while (iterCasesFC.hasNext()) {
                    NavigationCaseType navigationCaseFC = (NavigationCaseType)iterCasesFC.next();
                    isNew |= FC2PFTransformer.getInstance().updatePageflowElements(pageflow, navigationCaseFC);
                }
            }
        }
        return isNew |= this.cleanPageflowNavigationRule(pageflow);
    }

    private boolean cleanPageflowNavigationRule(Pageflow pageflow) {
        boolean dirty = false;
        EList links = pageflow.getLinks();
        Iterator linksIterator = links.iterator();
        while (linksIterator.hasNext()) {
            PageflowLink link = (PageflowLink)linksIterator.next();
            if (!link.getFCElements().isEmpty()) continue;
            linksIterator.remove();
            if (link.getSource() != null) {
                link.getSource().getOutlinks().remove((Object)link);
            }
            if (link.getTarget() != null) {
                link.getTarget().getInlinks().remove((Object)link);
            }
            dirty = true;
        }
        return dirty;
    }

    private PageflowFactory getPageflowFactory() {
        if (this.pageflowFactory == null) {
            this.pageflowFactory = PageflowModelManager.getFactory();
        }
        return this.pageflowFactory;
    }

    public PageflowPage createPFPage(String fromViewID) {
        PageflowPage page = this.getPageflowFactory().createPFPage();
        if (fromViewID != null && fromViewID.length() > 0) {
            page.setPath(fromViewID.trim());
            page.setName(WebrootUtil.getPageNameFromWebPath((String)fromViewID.trim()));
        }
        this.pageflow.getNodes().add((Object)page);
        return page;
    }

    public static void updatePageflowModelInfo(Pageflow newPageflow, Pageflow oldPageflow) {
        if (newPageflow == null || oldPageflow == null) {
            return;
        }
        newPageflow.setName(oldPageflow.getName());
        newPageflow.setComment(oldPageflow.getComment());
        newPageflow.setConfigfile(oldPageflow.getConfigfile());
        PageflowTransform.updatePageflowNode(newPageflow, oldPageflow);
    }

    private static void updatePageflowNode(Pageflow newPageflow, Pageflow oldPageflow) {
        if (oldPageflow.getNodes().size() > 0) {
            Iterator iter = newPageflow.getNodes().iterator();
            while (iter.hasNext()) {
                PageflowNode newNode = (PageflowNode)iter.next();
                PageflowTransform.updatePageflowNode(newNode, oldPageflow);
            }
        }
    }

    private static void updatePageflowNode(PageflowNode newNode, Pageflow oldPageflow) {
        Iterator iter = oldPageflow.getNodes().iterator();
        while (iter.hasNext()) {
            PageflowNode cfr_ignored_0 = (PageflowNode)iter.next();
        }
    }
}

