/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.xml.internal.commands;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.command.LSPCommandHandler;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wildwebdeveloper.xml.internal.Activator;
import org.eclipse.wildwebdeveloper.xml.internal.commands.AssociateGrammarDialog;

public class AssociateGrammarHandler
extends LSPCommandHandler {
    private static final String ASSOCIATE_GRAMMAR_INSERT = "xml.associate.grammar.insert";

    public Object execute(ExecutionEvent event, Command command, IPath path) throws ExecutionException {
        String uri = (String)command.getArguments().get(0);
        AssociateGrammarDialog dialog = new AssociateGrammarDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), path);
        if (dialog.open() == 0) {
            String grammarURI = dialog.getGrammarURI();
            String bindingType = dialog.getBindingType().getCode();
            TextDocumentIdentifier identifier = new TextDocumentIdentifier(uri);
            try {
                AssociateGrammarHandler.executeServerCommand(ASSOCIATE_GRAMMAR_INSERT, identifier, grammarURI, bindingType).thenAccept(result -> {
                    Gson gson = new Gson();
                    JsonObject jsonObject = gson.toJsonTree(result).getAsJsonObject();
                    TextDocumentEdit edit = (TextDocumentEdit)gson.fromJson((JsonElement)jsonObject, TextDocumentEdit.class);
                    WorkspaceEdit workEdits = new WorkspaceEdit();
                    workEdits.setDocumentChanges(new ArrayList());
                    workEdits.getDocumentChanges().add(Either.forLeft((Object)edit));
                    LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)workEdits, (String)ASSOCIATE_GRAMMAR_INSERT);
                });
            }
            catch (Exception e) {
                Activator.getDefault().getLog().error("Error while insert grammar association", (Throwable)e);
            }
        }
        return null;
    }

    private static CompletableFuture<Object> executeServerCommand(String commandId, Object ... params) throws Exception {
        List commandHandlers = LanguageServiceAccessor.getActiveLanguageServers(AssociateGrammarHandler.handlesCommand(commandId));
        if (commandHandlers != null) {
            if (commandHandlers.size() == 1) {
                LanguageServer handler = (LanguageServer)commandHandlers.get(0);
                return handler.getWorkspaceService().executeCommand(new ExecuteCommandParams(commandId, Arrays.asList(params)));
            }
            if (commandHandlers.size() > 1) {
                throw new IllegalStateException("Multiple language servers have registered to handle command '" + commandId + "'");
            }
        }
        throw new UnsupportedOperationException("No language server has registered to handle command '" + commandId + "'");
    }

    private static Predicate<ServerCapabilities> handlesCommand(String commandId) {
        return serverCaps -> {
            ExecuteCommandOptions executeCommandProvider = serverCaps.getExecuteCommandProvider();
            if (executeCommandProvider != null) {
                return executeCommandProvider.getCommands().contains(commandId);
            }
            return false;
        };
    }
}

