/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_nl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "Arabisch";
        final String metaValue_bn = "Bengaals";
        final String metaValue_bo = "Tibetaans";
        final String metaValue_el = "Grieks";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Hebreeuws";
        final String metaValue_hy = "Armeens";
        final String metaValue_ii = "Yi";
        final String metaValue_ja = "Japans";
        final String metaValue_jv = "Javaans";
        final String metaValue_ka = "Georgisch";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Koreaans";
        final String metaValue_lo = "Laotiaans";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongools";
        final String metaValue_my = "Birmaans";
        final String metaValue_or = "Odia";
        final String metaValue_sd = "Sindhi";
        final String metaValue_si = "Singalees";
        final String metaValue_su = "Soendanees";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_th = "Thai";
        final String metaValue_tl = "Tagalog";
        final String metaValue_ban = "Balinees";
        final String metaValue_bax = "Bamoun";
        final String metaValue_bug = "Buginees";
        final String metaValue_ccp = "Chakma";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Koptisch";
        final String metaValue_got = "Gothisch";
        final String metaValue_kpe = "Kpelle";
        final String metaValue_men = "Mende";
        final String metaValue_mni = "Meitei";
        final String metaValue_new = "Newari";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_osa = "Osage";
        final String metaValue_peo = "Oudperzisch";
        final String metaValue_phn = "Foenicisch";
        final String metaValue_saz = "Saurashtra";
        final String metaValue_sog = "Sogdisch";
        final String metaValue_ssy = "Saho";
        final String metaValue_vai = "Vai";
        final String metaValue_zbl = "Blissymbolen";
        final Object[][] data = new Object[][] {
            { "ksh", "K\u00f6lsch" },
            { "Ogam", "Ogham" },
            { "mwl", "Mirandees" },
            { "Zsym", "symbolen" },
            { "cch", "Atsam" },
            { "mwr", "Marwari" },
            { "%%ARKAIKA", "Archa\u00efsch Esperanto" },
            { "type.nu.lanatham", "Tai Tham Tham cijfers" },
            { "egl", "Emiliano" },
            { "mwv", "Mentawai" },
            { "Tagb", "Tagbanwa" },
            { "Zsye", "emoji" },
            { "%%NJIVA", "Gniva/Njiva-dialect" },
            { "xmf", "Mingreels" },
            { "ccp", metaValue_ccp },
            { "egy", "Oudegyptisch" },
            { "raj", "Rajasthani" },
            { "Phag", "Phags-pa" },
            { "tem", "Timne" },
            { "Medf", "Medefaidrin" },
            { "type.nu.sind", "Khudawadi cijfers" },
            { "teo", "Teso" },
            { "rap", "Rapanui" },
            { "ter", "Tereno" },
            { "AC", "Ascension" },
            { "rar", "Rarotongan" },
            { "tet", "Tetun" },
            { "%%BARLA", "Barlavento-dialectgroep van Kabuverdianu" },
            { "type.nu.sinh", "Sinhala Lith cijfers" },
            { "AD", "Andorra" },
            { "AE", "Verenigde Arabische Emiraten" },
            { "nl_BE", "Vlaams" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua en Barbuda" },
            { "type.nu.mroo", "Mro cijfers" },
            { "type.ca.ethiopic", "Ethiopische kalender" },
            { "glk", "Gilaki" },
            { "AI", "Anguilla" },
            { "key.tz", "Tijdzone" },
            { "AL", "Albani\u00eb" },
            { "AM", "Armeni\u00eb" },
            { "Teng", "Tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentini\u00eb" },
            { "Prti", "Inscriptioneel Parthisch" },
            { "AS", "Amerikaans-Samoa" },
            { "AT", "Oostenrijk" },
            { "AU", "Australi\u00eb" },
            { "AW", "Aruba" },
            { "AX", "\u00c5land" },
            { "mye", "Myene" },
            { "AZ", "Azerbeidzjan" },
            { "%%AREVELA", "Oost-Armeens" },
            { "BA", "Bosni\u00eb en Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "Koemuks" },
            { "BE", "Belgi\u00eb" },
            { "gmh", "Middelhoogduits" },
            { "Sogo", "Oud Sogdisch" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarije" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "Kutenai" },
            { "myv", "Erzja" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Caribisch Nederland" },
            { "BR", "Brazili\u00eb" },
            { "BS", "Bahama\u2019s" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouveteiland" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "Visp", "Zichtbare spraak" },
            { "type.ca.persian", "Perzische kalender" },
            { "%%CREISS", "Creiss" },
            { "type.nu.hebr", "Hebreeuwse cijfers" },
            { "CA", "Canada" },
            { "Kits", "Kitaans kleinschrift" },
            { "CC", "Cocoseilanden" },
            { "mzn", "Mazanderani" },
            { "CD", "Congo-Kinshasa" },
            { "CF", "Centraal-Afrikaanse Republiek" },
            { "CG", "Congo-Brazzaville" },
            { "CH", "Zwitserland" },
            { "CI", "Ivoorkust" },
            { "CK", "Cookeilanden" },
            { "CL", "Chili" },
            { "Kthi", "Kaithi" },
            { "CM", "Kameroen" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Kaapverdi\u00eb" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmaseiland" },
            { "CY", "Cyprus" },
            { "type.nu.bali", "Balinese cijfers" },
            { "CZ", "Tsjechi\u00eb" },
            { "eka", "Ekajuk" },
            { "Ahom", "Ahom" },
            { "Pauc", "Pau Cin Hau" },
            { "vls", "West-Vlaams" },
            { "%%RIGIK", "Klassiek Volap\u00fck" },
            { "Sogd", metaValue_sog },
            { "DE", "Duitsland" },
            { "goh", "Oudhoogduits" },
            { "ace", "Atjehs" },
            { "cgg", "Chiga" },
            { "DG", "Diego Garcia" },
            { "gom", "Goa Konkani" },
            { "type.nu.deva", "Devanagari cijfers" },
            { "DJ", "Djibouti" },
            { "DK", "Denemarken" },
            { "ach", "Akoli" },
            { "gon", "Gondi" },
            { "Brai", "braille" },
            { "Brah", "Brahmi" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "kleine Armeense cijfers" },
            { "DO", "Dominicaanse Republiek" },
            { "gor", "Gorontalo" },
            { "got", metaValue_got },
            { "vmf", "Opperfrankisch" },
            { "Mtei", metaValue_mni },
            { "zun", "Zuni" },
            { "tig", "Tigre" },
            { "Takr", "Takri" },
            { "DZ", "Algerije" },
            { "pag", "Pangasinan" },
            { "type.d0.hwidth", "Halve breedte" },
            { "pal", "Pahlavi" },
            { "EA", "Ceuta en Melilla" },
            { "chb", "Chibcha" },
            { "pam", "Pampanga" },
            { "EC", "Ecuador" },
            { "pap", "Papiaments" },
            { "ada", "Adangme" },
            { "EE", "Estland" },
            { "tiv", "Tiv" },
            { "EG", "Egypte" },
            { "EH", "Westelijke Sahara" },
            { "chg", "Chagatai" },
            { "pau", "Palaus" },
            { "chk", "Chuukees" },
            { "chn", "Chinook Jargon" },
            { "chm", "Mari" },
            { "chp", "Chipewyan" },
            { "cho", "Choctaw" },
            { "type.nu.mathbold", "vette wiskundige cijfers" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", "Spanje" },
            { "%%TUNUMIIT", "Tunumiisiut" },
            { "ET", "Ethiopi\u00eb" },
            { "Vith", "Vithkuqi" },
            { "EU", "Europese Unie" },
            { "elx", "Elamitisch" },
            { "type.ca.gregorian", "Gregoriaanse kalender" },
            { "EZ", "eurozone" },
            { "chy", "Cheyenne" },
            { "type.nu.gujr", "Gujarati cijfers" },
            { "Inds", "Indus" },
            { "ady", "Adygees" },
            { "aeb", "Tunesisch Arabisch" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falklandeilanden" },
            { "FM", "Micronesia" },
            { "key.va", "Landvariant" },
            { "FO", "Faer\u00f6er" },
            { "Taml", metaValue_ta },
            { "FR", "Frankrijk" },
            { "Kpel", metaValue_kpe },
            { "%%SIMPLE", "Simpel" },
            { "pcd", "Picardisch" },
            { "tkl", "Tokelaus" },
            { "grb", "Grebo" },
            { "%%DAJNKO", "Dajnko-alfabet" },
            { "type.ca.indian", "Indiase nationale kalender" },
            { "rgn", "Romagnol" },
            { "grc", "Oudgrieks" },
            { "GA", "Gabon" },
            { "tkr", "Tsakhur" },
            { "vot", "Votisch" },
            { "type.nu.tnsa", "Tangsa cijfers" },
            { "GB", "Verenigd Koninkrijk" },
            { "pcm", "Nigeriaans Pidgin" },
            { "GD", "Grenada" },
            { "GE", "Georgi\u00eb" },
            { "GF", "Frans-Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "Tai Le" },
            { "GI", "Gibraltar" },
            { "afh", "Afrihili" },
            { "GL", "Groenland" },
            { "enm", "Middelengels" },
            { "GM", "Gambia" },
            { "GN", "Guinee" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatoriaal-Guinea" },
            { "GR", "Griekenland" },
            { "GS", "Zuid-Georgia en Zuidelijke Sandwicheilanden" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "Pennsylvania-Duits" },
            { "type.nu.mathmono", "niet-proportionele wiskundige cijfers" },
            { "GW", "Guinee-Bissau" },
            { "rhg", "Rohingya" },
            { "tli", "Tlingit" },
            { "tlh", "Klingon" },
            { "Talu", "Nieuw Tai Lue" },
            { "GY", "Guyana" },
            { "ckb", "Soran\u00ee" },
            { "zxx", "geen lingu\u00efstische inhoud" },
            { "Jurc", "Jurchen" },
            { "tly", "Talysh" },
            { "%%VIVARAUP", "Vivaraup" },
            { "pdt", "Plautdietsch" },
            { "Vaii", metaValue_vai },
            { "HK", "Hongkong SAR van China" },
            { "HM", "Heard en McDonaldeilanden" },
            { "HN", "Honduras" },
            { "HR", "Kroati\u00eb" },
            { "agq", "Aghem" },
            { "gsw", "Zwitserduits" },
            { "type.ca.islamic-umalqura", "Islamitische kalender (Umm al-Qura)" },
            { "HT", "Ha\u00efti" },
            { "HU", "Hongarije" },
            { "rif", "Riffijns" },
            { "tmh", "Tamashek" },
            { "IC", "Canarische Eilanden" },
            { "nan", "Minnanyu" },
            { "peo", metaValue_peo },
            { "ID", "Indonesi\u00eb" },
            { "Adlm", "Adlam" },
            { "type.nu.kali", "Kayah Li cijfers" },
            { "IE", "Ierland" },
            { "nap", "Napolitaans" },
            { "%%NDYUKA", "Ndyuka-dialect" },
            { "naq", "Nama" },
            { "type.nu.sora", "Sora Sompeng cijfers" },
            { "zza", "Zaza" },
            { "Tang", "Tangut" },
            { "IL", "Isra\u00ebl" },
            { "Nbat", "Nabateaans" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "type.co.eor", "Europese sorteerregels" },
            { "IO", "Brits Indische Oceaanterritorium" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "IJsland" },
            { "IT", "Itali\u00eb" },
            { "Zmth", "wiskundige notatie" },
            { "type.nu.thai", "Thaise cijfers" },
            { "vro", "V\u00f5ro" },
            { "guc", "Wayuu" },
            { "%%POSIX", "Computer" },
            { "type.nu.beng", "Bengaalse cijfers" },
            { "pfl", "Paltsisch" },
            { "type.nu.cyrl", "Cyrillische cijfers" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Islamitische kalender" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "%%EKAVSK", "Servisch met Ekaviaanse uitspraak" },
            { "JO", "Jordani\u00eb" },
            { "gur", "Gurune" },
            { "JP", "Japan" },
            { "%%1606NICT", "Laat Middelfrans tot 1606" },
            { "ain", "Aino" },
            { "%%KOCIEWIE", "Kociewie" },
            { "Mend", metaValue_men },
            { "guz", "Gusii" },
            { "tog", "Nyasa Tonga" },
            { "type.nu.knda", "Kannada cijfers" },
            { "Kali", "Kayah Li" },
            { "Sidd", "Siddham" },
            { "type.co.phonetic", "Fonetische sorteervolgorde" },
            { "izh", "Ingrisch" },
            { "type.ca.buddhist", "Boeddhistische kalender" },
            { "KE", "Kenia" },
            { "419", "Latijns-Amerika" },
            { "KG", "Kirgizi\u00eb" },
            { "KH", "Cambodja" },
            { "KI", "Kiribati" },
            { "KM", "Comoren" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts en Nevis" },
            { "Zinh", "Overge\u00ebrfd" },
            { "KP", "Noord-Korea" },
            { "KR", "Zuid-Korea" },
            { "Plrd", "Pollard-fonetisch" },
            { "KW", "Koeweit" },
            { "tpi", "Tok Pisin" },
            { "KY", "Kaaimaneilanden" },
            { "KZ", "Kazachstan" },
            { "Cyrl", "Cyrillisch" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "phn", metaValue_phn },
            { "LC", "Saint Lucia" },
            { "Cyrs", "Oudkerkslavisch Cyrillisch" },
            { "gwi", "Gwich\u02bcin" },
            { "%%LUNA1918", "Russische spelling van 1917" },
            { "nds", "Nedersaksisch" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "Akkadisch" },
            { "cop", metaValue_cop },
            { "Hmnp", "Nyiakeng Puachue Hmong" },
            { "LR", "Liberia" },
            { "esu", "Yupik" },
            { "LS", "Lesotho" },
            { "Phlv", "Boek Pahlavi" },
            { "LT", "Litouwen" },
            { "LU", "Luxemburg" },
            { "LV", "Letland" },
            { "Kana", "Katakana" },
            { "Sora", "Sora Sompeng" },
            { "LY", "Libi\u00eb" },
            { "lad", "Ladino" },
            { "vun", "Vunjo" },
            { "akz", "Alabama" },
            { "%%LAUKIKA", "Laukika" },
            { "lah", "Lahnda" },
            { "Mahj", "Mahajani" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldavi\u00eb" },
            { "Nshu", "N\u00fcshu" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "lam", "Lamba" },
            { "MG", "Madagaskar" },
            { "Thai", metaValue_th },
            { "MH", "Marshalleilanden" },
            { "ale", "Aleoetisch" },
            { "type.nu.vaii", "Vai-cijfers" },
            { "MK", "Noord-Macedoni\u00eb" },
            { "type.nu.mathdbl", "wiskundige cijfers met dubbele lijn" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birma)" },
            { "new", metaValue_new },
            { "MN", "Mongoli\u00eb" },
            { "MO", "Macau SAR van China" },
            { "aln", "Gegisch" },
            { "MP", "Noordelijke Marianen" },
            { "MQ", "Martinique" },
            { "MR", "Mauritani\u00eb" },
            { "MS", "Montserrat" },
            { "Chrs", "Chorasmisch" },
            { "MT", "Malta" },
            { "cps", "Capiznon" },
            { "type.m0.ungegn", "UNGEGN" },
            { "MU", "Mauritius" },
            { "alt", "Zuid-Alta\u00efsch" },
            { "MV", "Maldiven" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "type.ca.japanese", "Japanse kalender" },
            { "MY", "Maleisi\u00eb" },
            { "MZ", "Mozambique" },
            { "Phli", "Inscriptioneel Pahlavi" },
            { "NA", "Namibi\u00eb" },
            { "%%ARANES", "Aranees" },
            { "202", "Sub-Saharaans Afrika" },
            { "type.ca.hebrew", "Hebreeuwse kalender" },
            { "type.co.dictionary", "Woordenboeksorteervolgorde" },
            { "NC", "Nieuw-Caledoni\u00eb" },
            { "%%WADEGILE", "Wade-Giles-romanisering" },
            { "tru", "Turoyo" },
            { "%%UCRCOR", "Eenvormig herziene spelling" },
            { "NE", "Niger" },
            { "NF", "Norfolk" },
            { "NG", "Nigeria" },
            { "trv", "Taroko" },
            { "Phlp", "Psalmen Pahlavi" },
            { "NI", "Nicaragua" },
            { "Hmng", "Pahawh Hmong" },
            { "NL", "Nederland" },
            { "NO", "Noorwegen" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "Tsakonisch" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "tsi", "Tsimshian" },
            { "NZ", "Nieuw-Zeeland" },
            { "Merc", "Meroitisch cursief" },
            { "%%COLB1945", "Portugese-Braziliaanse spellingsverdrag van 1945" },
            { "rom", "Romani" },
            { "Mero", "Mero\u00eftisch" },
            { "crh", "Krim-Tataars" },
            { "ang", "Oudengels" },
            { "%%GRMISTR", "Grmistr" },
            { "OM", "Oman" },
            { "%%PETR1708", "Petr1708" },
            { "anp", "Angika" },
            { "crs", "Seychellencreools" },
            { "type.nu.hmnp", "Nyiakeng Puachue Hmong cijfers" },
            { "Xpeo", metaValue_peo },
            { "type.nu.hmng", "Pahawh Hmong cijfers" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Islamitische kalender (cyclisch)" },
            { "csb", "Kasjoebisch" },
            { "PE", "Peru" },
            { "ttt", "Moslim Tat" },
            { "PF", "Frans-Polynesi\u00eb" },
            { "PG", "Papoea-Nieuw-Guinea" },
            { "PH", "Filipijnen" },
            { "PK", "Pakistan" },
            { "%%NICARD", "Nicard" },
            { "PL", "Polen" },
            { "ewo", "Ewondo" },
            { "PM", "Saint-Pierre en Miquelon" },
            { "PN", "Pitcairneilanden" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Palestijnse gebieden" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "Nias" },
            { "type.nu.greklow", "kleine Griekse cijfers" },
            { "PY", "Paraguay" },
            { "tum", "Toemboeka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "Schots standaard-Engels" },
            { "jam", "Jamaicaans Creools" },
            { "pms", "Pi\u00ebmontees" },
            { "niu", "Niueaans" },
            { "QO", "overig Oceani\u00eb" },
            { "ext", "Extremeens" },
            { "lez", "Lezgisch" },
            { "type.nu.ahom", "Ahom cijfers" },
            { "%%FONUPA", "Oeralisch Fonetisch Alfabet" },
            { "type.nu.takr", "Takri cijfers" },
            { "tvl", "Tuvaluaans" },
            { "Tavt", "Tai Viet" },
            { "%%SOTAV", "Sotavento-dialectgroep van Kabuverdianu" },
            { "Maka", "Makasar" },
            { "001", "wereld" },
            { "002", "Afrika" },
            { "njo", "Ao Naga" },
            { "003", "Noord-Amerika" },
            { "RE", "R\u00e9union" },
            { "005", "Zuid-Amerika" },
            { "lfn", "Lingua Franca Nova" },
            { "jbo", "Lojban" },
            { "pnt", "Pontisch" },
            { "Rjng", "Rejang" },
            { "009", "Oceani\u00eb" },
            { "Elym", "Elymaisch" },
            { "%%SURSILV", "Sursilvan" },
            { "RO", "Roemeni\u00eb" },
            { "RS", "Servi\u00eb" },
            { "Mroo", "Mro" },
            { "RU", "Rusland" },
            { "RW", "Rwanda" },
            { "type.nu.talu", "nieuwe Tai Lue cijfers" },
            { "%%METELKO", "Metelko-alfabet" },
            { "Mani", "Manicheaans" },
            { "Ugar", "Ugaritisch" },
            { "Khar", "Kharoshthi" },
            { "SA", "Saoedi-Arabi\u00eb" },
            { "pon", "Pohnpeiaans" },
            { "Mand", "Mandaeans" },
            { "SB", "Salomonseilanden" },
            { "twq", "Tasawaq" },
            { "Tnsa", "Tangsa" },
            { "011", "West-Afrika" },
            { "SC", "Seychellen" },
            { "SD", "Soedan" },
            { "013", "Midden-Amerika" },
            { "SE", "Zweden" },
            { "014", "Oost-Afrika" },
            { "arc", "Aramees" },
            { "Loma", "Loma" },
            { "015", "Noord-Afrika" },
            { "SG", "Singapore" },
            { "SH", "Sint-Helena" },
            { "type.lb.strict", "strikte stijl regelafbreking" },
            { "017", "Centraal-Afrika" },
            { "SI", "Sloveni\u00eb" },
            { "type.nu.mymrtlng", "Myanmar Tai Laing cijfers" },
            { "018", "Zuidelijk Afrika" },
            { "SJ", "Spitsbergen en Jan Mayen" },
            { "Bamu", metaValue_bax },
            { "019", "Amerika" },
            { "SK", "Slowakije" },
            { "Wole", "Woleai" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somali\u00eb" },
            { "arn", "Mapudungun" },
            { "arp", "Arapaho" },
            { "type.nu.taml", "traditionele Tamil cijfers" },
            { "SR", "Suriname" },
            { "aro", "Araona" },
            { "SS", "Zuid-Soedan" },
            { "ST", "Sao Tom\u00e9 en Principe" },
            { "arq", "Algerijns Arabisch" },
            { "SV", "El Salvador" },
            { "ars", "Nadjdi-Arabisch" },
            { "SX", "Sint-Maarten" },
            { "SY", "Syri\u00eb" },
            { "yao", "Yao" },
            { "SZ", "Eswatini" },
            { "arw", "Arawak" },
            { "arz", "Egyptisch Arabisch" },
            { "ary", "Marokkaans Arabisch" },
            { "yap", "Yapees" },
            { "rtm", "Rotumaans" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "type.ms.ussystem", "Amerikaans imperiaal stelsel" },
            { "021", "Noordelijk Amerika" },
            { "TC", "Turks- en Caicoseilanden" },
            { "yav", "Yangben" },
            { "TD", "Tsjaad" },
            { "Qaag", "Zawgyi" },
            { "TF", "Franse Gebieden in de zuidelijke Indische Oceaan" },
            { "ase", "Amerikaanse Gebarentaal" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadzjikistan" },
            { "029", "Caribisch gebied" },
            { "TK", "Tokelau" },
            { "TL", "Oost-Timor" },
            { "ybb", "Yemba" },
            { "type.co.searchjl", "Zoeken op eerste Hangul-medeklinker" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "Boontling" },
            { "TN", "Tunesi\u00eb" },
            { "TO", "Tonga" },
            { "%%NULIK", "Modern Volap\u00fck" },
            { "TR", "Turkije" },
            { "TT", "Trinidad en Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "Asturisch" },
            { "rue", "Roetheens" },
            { "rug", "Roviana" },
            { "Orkh", "Orkhon" },
            { "TZ", "Tanzania" },
            { "nmg", "Ngumba" },
            { "Zzzz", "onbekend schriftsysteem" },
            { "Sind", metaValue_sd },
            { "UA", "Oekra\u00efne" },
            { "lij", "Ligurisch" },
            { "rup", "Aroemeens" },
            { "030", "Oost-Azi\u00eb" },
            { "tyv", "Toevaans" },
            { "034", "Zuid-Azi\u00eb" },
            { "hai", "Haida" },
            { "035", "Zuidoost-Azi\u00eb" },
            { "UG", "Oeganda" },
            { "hak", "Hakka" },
            { "type.co.pinyin", "Pinyinvolgorde" },
            { "039", "Zuid-Europa" },
            { "Sinh", metaValue_si },
            { "UM", "Kleine afgelegen eilanden van de Verenigde Staten" },
            { "liv", "Lijfs" },
            { "UN", "Verenigde Naties" },
            { "US", "Verenigde Staten" },
            { "haw", "Hawa\u00efaans" },
            { "%%1959ACAD", "Academisch" },
            { "%%IVANCHOV", "Ivanchov" },
            { "type.co.gb2312han", "Vereenvoudigd-Chinese sorteervolgorde - GB2312" },
            { "UY", "Uruguay" },
            { "prg", "Oudpruisisch" },
            { "UZ", "Oezbekistan" },
            { "tzm", "Tamazight (Centraal-Marokko)" },
            { "type.co.stroke", "Streeksorteervolgorde" },
            { "nnh", "Ngiemboon" },
            { "VA", "Vaticaanstad" },
            { "pro", "Oudproven\u00e7aals" },
            { "VC", "Saint Vincent en de Grenadines" },
            { "%%HSISTEMO", "H-sistemo" },
            { "VE", "Venezuela" },
            { "VG", "Britse Maagdeneilanden" },
            { "VI", "Amerikaanse Maagdeneilanden" },
            { "%%LEMOSIN", "Lemosin" },
            { "Soyo", "Soyombo" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "Marc", "Marchen" },
            { "nog", "Nogai" },
            { "rwk", "Rwa" },
            { "non", "Oudnoors" },
            { "053", "Australazi\u00eb" },
            { "%%AREVMDA", "West-Armeens" },
            { "054", "Melanesi\u00eb" },
            { "WF", "Wallis en Futuna" },
            { "type.co.traditional", "Traditionele sorteervolgorde" },
            { "057", "Micronesische regio" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "nov", "Novial" },
            { "type.nu.finance", "Financi\u00eble cijfers" },
            { "avk", "Kotava" },
            { "%%HEPBURN", "Hepburn-romanisering" },
            { "type.co.compat", "vorige sorteervolgorde, voor compatibiliteit" },
            { "wae", "Walser" },
            { "WS", "Samoa" },
            { "Bass", "Bassa Vah" },
            { "type.nu.mtei", "Meetei Mayek cijfers" },
            { "wal", "Wolaytta" },
            { "was", "Washo" },
            { "XA", "Pseudo-Accenten" },
            { "war", "Waray" },
            { "XB", "Pseudo-Bidi" },
            { "awa", "Awadhi" },
            { "061", "Polynesi\u00eb" },
            { "%%KSCOR", "Standaardspelling" },
            { "XK", "Kosovo" },
            { "type.nu.brah", "Brahmi cijfers" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "ongeschreven" },
            { "Olck", "Ol Chiki" },
            { "wbp", "Warlpiri" },
            { "Batk", "Batak" },
            { "Blis", metaValue_zbl },
            { "YE", "Jemen" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "standaard sorteervolgorde" },
            { "lmo", "Lombardisch" },
            { "Zanb", "vierkant Zanabazar" },
            { "fan", "Fang" },
            { "%%BALANKA", "Balanka-dialect van Anii" },
            { "%%ROZAJ", "Resiaans" },
            { "%%SUTSILV", "Sutsilvan" },
            { "fat", "Fanti" },
            { "Sgnw", "SignWriting" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "Cham cijfers" },
            { "%%NEWFOUND", "Newfound" },
            { "ZA", "Zuid-Afrika" },
            { "type.nu.sund", "Sundanese cijfers" },
            { "type.lb.loose", "losse stijl regelafbreking" },
            { "Deva", "Devanagari" },
            { "type.nu.geor", "Georgische cijfers" },
            { "type.co.zhuyin", "Zhuyinvolgorde" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "Pinyin" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "onbekend gebied" },
            { "Runr", "Runic" },
            { "type.ms.metric", "metriek stelsel" },
            { "type.ca.iso8601", "ISO-8601-kalender" },
            { "lol", "Mongo" },
            { "nso", "Noord-Sotho" },
            { "type.nu.telu", "Telugu cijfers" },
            { "lou", "Louisiana-Creools" },
            { "loz", "Lozi" },
            { "%%FONKIRSH", "Fonkirsh" },
            { "Nkgb", "Naxi Geba" },
            { "%%ASANTE", "Asante" },
            { "%%AUVERN", "Auvern" },
            { "jmc", "Machame" },
            { "hif", "Fijisch Hindi" },
            { "type.nu.hansfin", "vereenvoudigd Chinese financi\u00eble cijfers" },
            { "hil", "Hiligaynon" },
            { "type.nu.arabext", "uitgebreide Arabisch-Indische cijfers" },
            { "nus", "Nuer" },
            { "dak", "Dakota" },
            { "type.nu.fullwide", "cijfers met volledige breedte" },
            { "hit", "Hettitisch" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "Maya", "Mayahi\u00ebrogliefen" },
            { "lrc", "Noordelijk Luri" },
            { "type.co.emoji", "emojisorteervolgorde" },
            { "Copt", metaValue_cop },
            { "nwc", "Klassiek Nepalbhasa" },
            { "udm", "Oedmoerts" },
            { "Khmr", metaValue_km },
            { "%%FONNAPA", "Fonnapa" },
            { "type.ca.islamic-rgsa", "Islamitische kalender (Saudi\u2013Arabi\u00eb)" },
            { "Limb", "Limbu" },
            { "sad", "Sandawe" },
            { "type.nu.roman", "Romeinse cijfers" },
            { "sah", "Jakoets" },
            { "type.nu.shrd", "Sharada cijfers" },
            { "ltg", "Letgaals" },
            { "sam", "Samaritaans-Aramees" },
            { "Aghb", "Kaukasisch Albanees" },
            { "%%SCOUSE", "Liverpools (Scouse)" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "Tfng", "Tifinagh" },
            { "saz", metaValue_saz },
            { "jpr", "Judeo-Perzisch" },
            { "type.d0.npinyin", "Numeriek" },
            { "type.nu.native", "Binnenlandse cijfers" },
            { "sba", "Ngambay" },
            { "Guru", "Gurmukhi" },
            { "%%ALUKU", "Aloekoe-dialect" },
            { "type.nu.diak", "Dives Akuru cijfers" },
            { "lua", "Luba-Lulua" },
            { "%%BISCAYAN", "Biskajaans" },
            { "%%PEANO", "Latijn zonder flexie" },
            { "type.nu.tirh", "Tirhuta cijfers" },
            { "type.d0.fwidth", "Volledige breedte" },
            { "sbp", "Sangu" },
            { "lui", "Luiseno" },
            { "%%GRITAL", "Grital" },
            { "nyn", "Nyankole" },
            { "nym", "Nyamwezi" },
            { "lun", "Lunda" },
            { "nyo", "Nyoro" },
            { "luo", "Luo" },
            { "fil", "Filipijns" },
            { "hmn", "Hmong" },
            { "del", "Delaware" },
            { "lus", "Mizo" },
            { "bal", "Beloetsji" },
            { "den", "Slavey" },
            { "ban", metaValue_ban },
            { "uga", "Oegaritisch" },
            { "type.nu.wara", "Warang Citi cijfers" },
            { "fit", "Tornedal-Fins" },
            { "luy", "Luyia" },
            { "bar", "Beiers" },
            { "bas", "Basa" },
            { "bax", metaValue_bax },
            { "%%ABL1943", "Spellingsformulering van 1943" },
            { "jrb", "Judeo-Arabisch" },
            { "nzi", "Nzima" },
            { "sco", "Schots" },
            { "scn", "Siciliaans" },
            { "aa", "Afar" },
            { "ab", "Abchazisch" },
            { "Aran", "Nastaliq" },
            { "bbc", "Batak Toba" },
            { "ae", "Avestisch" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "type.nu.cakm", "Chakma cijfers" },
            { "bbj", "Ghomala\u2019" },
            { "am", "Amhaars" },
            { "Arab", metaValue_ar },
            { "an", "Aragonees" },
            { "%%SOLBA", "Stolvizza/Solbica-dialect" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "Katakana of Hiragana" },
            { "as", "Assamees" },
            { "sdc", "Sassarees" },
            { "Lina", "Lineair A" },
            { "av", "Avarisch" },
            { "Linb", "Lineair B" },
            { "sdh", "Pahlavani" },
            { "ay", "Aymara" },
            { "az", "Azerbeidzjaans" },
            { "Rohg", "Hanifi Rohingya" },
            { "Khoj", "Khojki" },
            { "%%CISAUP", "Cisaup" },
            { "%%OSOJS", "Oseacco/Osojane-dialect" },
            { "%%UNIFON", "Unifon fonetisch alfabet" },
            { "ba", "Basjkiers" },
            { "type.co.unihan", "Sorteervolgorde radicalen/strepen" },
            { "be", "Belarussisch" },
            { "bg", "Bulgaars" },
            { "bi", "Bislama" },
            { "type.nu.java", "Javaanse cijfers" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "Dogrib" },
            { "br", "Bretons" },
            { "bs", "Bosnisch" },
            { "Bhks", "Bhaiksuki" },
            { "see", "Seneca" },
            { "Mymr", metaValue_my },
            { "sei", "Seri" },
            { "type.nu.laoo", "Laotiaanse cijfers" },
            { "seh", "Sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "Selkoeps" },
            { "ca", "Catalaans" },
            { "ses", "Koyraboro Senni" },
            { "ce", "Tsjetsjeens" },
            { "ch", "Chamorro" },
            { "%%REVISED", "Gewijzigde spelling" },
            { "co", "Corsicaans" },
            { "Orya", metaValue_or },
            { "cr", "Cree" },
            { "cs", "Tsjechisch" },
            { "cu", "Kerkslavisch" },
            { "yrl", "Nheengatu" },
            { "cv", "Tsjoevasjisch" },
            { "cy", "Welsh" },
            { "type.nu.ethi", "Ethiopische cijfers" },
            { "Yiii", metaValue_ii },
            { "da", "Deens" },
            { "de", "Duits" },
            { "type.cf.standard", "standaard valutanotatie" },
            { "bej", "Beja" },
            { "din", "Dinka" },
            { "jut", "Jutlands" },
            { "Bugi", metaValue_bug },
            { "bem", "Bemba" },
            { "sga", "Oudiers" },
            { "type.nu.mong", "Mongoolse cijfers" },
            { "dv", "Divehi" },
            { "bew", "Betawi" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Chinese kalender" },
            { "lzh", "Klassiek Chinees" },
            { "Lisu", "Fraser" },
            { "dje", "Zarma" },
            { "sgs", "Samogitisch" },
            { "type.nu.grek", "Griekse cijfers" },
            { "ee", "Ewe" },
            { "bfd", "Bafut" },
            { "type.lb.normal", "normale stijl regelafbreking" },
            { "%%VECDRUKA", "Vec\u0101 druka" },
            { "el", metaValue_el },
            { "en", "Engels" },
            { "eo", "Esperanto" },
            { "bfq", "Badaga" },
            { "lzz", "Lazisch" },
            { "type.co.big5han", "Traditioneel-Chinese sorteervolgorde - Big5" },
            { "es", "Spaans" },
            { "et", "Estisch" },
            { "Hanb", "Han met Bopomofo" },
            { "eu", "Baskisch" },
            { "Buhd", "Buhid" },
            { "Hang", "Hangul" },
            { "Samr", "Samaritaans" },
            { "shi", "Tashelhiyt" },
            { "hsb", "Oppersorbisch" },
            { "Hani", "Han" },
            { "%%ULSTER", "Ulster" },
            { "shn", "Shan" },
            { "Hano", "Hanunoo" },
            { "fa", "Perzisch" },
            { "Hans", "vereenvoudigd" },
            { "type.nu.latn", "Westerse cijfers" },
            { "Hant", "traditioneel" },
            { "ff", "Fulah" },
            { "shu", "Tsjadisch Arabisch" },
            { "hsn", "Xiangyu" },
            { "fi", "Fins" },
            { "fj", "Fijisch" },
            { "fon", "Fon" },
            { "bgn", "Westers Beloetsji" },
            { "yue", "Kantonees" },
            { "fo", "Faer\u00f6ers" },
            { "type.m0.bgn", "BGN" },
            { "umb", "Umbundu" },
            { "fr", "Frans" },
            { "%%AKUAPEM", "Akuapem" },
            { "sid", "Sidamo" },
            { "fy", "Fries" },
            { "ga", "Iers" },
            { "Wcho", "Wancho" },
            { "gd", "Schots-Gaelisch" },
            { "Gong", "Gunjala Gondi" },
            { "gl", "Galicisch" },
            { "Gonm", "Masaram Gondi" },
            { "gn", "Guaran\u00ed" },
            { "bho", "Bhojpuri" },
            { "und", "onbekende taal" },
            { "type.ca.ethiopic-amete-alem", "Ethiopische Amete Alem-kalender" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "Islamitische kalender (epoche)" },
            { "gv", "Manx" },
            { "type.nu.osma", "Osmanya cijfers" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hup", "Hupa" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "ho", "Hiri Motu" },
            { "hr", "Kroatisch" },
            { "ht", "Ha\u00eftiaans Creools" },
            { "hu", "Hongaars" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "frc", "Cajun-Frans" },
            { "%%FONIPA", "Internationaal Fonetisch Alfabet" },
            { "ia", "Interlingua" },
            { "Jamo", "Jamo" },
            { "id", "Indonesisch" },
            { "type.nu.tibt", "Tibetaanse cijfers" },
            { "ie", "Interlingue" },
            { "%%GASCON", "Gascon" },
            { "ig", "Igbo" },
            { "ii", metaValue_ii },
            { "frm", "Middelfrans" },
            { "%%RUMGR", "Rumgr" },
            { "%%AO1990", "Portugese spellingsovereenkomst van 1990" },
            { "ik", "Inupiaq" },
            { "fro", "Oudfrans" },
            { "frp", "Arpitaans" },
            { "io", "Ido" },
            { "frs", "Oost-Fries" },
            { "bjn", "Banjar" },
            { "frr", "Noord-Fries" },
            { "is", "IJslands" },
            { "it", "Italiaans" },
            { "iu", "Inuktitut" },
            { "sli", "Silezisch Duits" },
            { "%%CORNU", "Cornu" },
            { "%%HOGNORSK", "Hoognoors" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "Oud Zuid-Arabisch" },
            { "Sara", "Sarati" },
            { "doi", "Dogri" },
            { "sly", "Selayar" },
            { "type.nu.lepc", "Lepcha cijfers" },
            { "bkm", "Kom" },
            { "sma", "Zuid-Samisch" },
            { "jv", metaValue_jv },
            { "Shaw", "Shavian" },
            { "%%BAUDDHA", "Bauddha" },
            { "mad", "Madoerees" },
            { "smj", "Lule-Samisch" },
            { "mag", "Magahi" },
            { "maf", "Mafa" },
            { "mai", "Maithili" },
            { "Ougr", "Oud Oeigoers" },
            { "smn", "Inari-Samisch" },
            { "ka", metaValue_ka },
            { "bla", "Siksika" },
            { "mak", "Makassaars" },
            { "wuu", "Wuyu" },
            { "sms", "Skolt-Samisch" },
            { "man", "Mandingo" },
            { "kg", "Kongo" },
            { "Goth", metaValue_got },
            { "ki", "Gikuyu" },
            { "mas", "Maa" },
            { "kj", "Kuanyama" },
            { "kk", "Kazachs" },
            { "kl", "Groenlands" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kasjmiri" },
            { "Cirt", "Cirth" },
            { "Lepc", "Lepcha" },
            { "Avst", "Avestaans" },
            { "ku", "Koerdisch" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kirgizisch" },
            { "snk", "Soninke" },
            { "Mult", "Multani" },
            { "la", "Latijn" },
            { "Hatr", "Hatran" },
            { "lb", "Luxemburgs" },
            { "type.nu.mlym", "Malayalam cijfers" },
            { "lg", "Luganda" },
            { "Roro", "Rongorongo" },
            { "li", "Limburgs" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "fur", "Friulisch" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "Brits imperiaal stelsel" },
            { "type.nu.lana", "Tai Tham Hora cijfers" },
            { "lt", "Litouws" },
            { "lu", "Luba-Katanga" },
            { "sog", metaValue_sog },
            { "lv", "Lets" },
            { "mg", "Malagassisch" },
            { "mh", "Marshallees" },
            { "type.co.ducet", "standaard Unicode-sorteervolgorde" },
            { "mi", "Maori" },
            { "mk", "Macedonisch" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Maleis" },
            { "mt", "Maltees" },
            { "my", metaValue_my },
            { "Saur", metaValue_saz },
            { "Armn", metaValue_hy },
            { "mdf", "Moksja" },
            { "mde", "Maba" },
            { "dsb", "Nedersorbisch" },
            { "Armi", "Keizerlijk Aramees" },
            { "na", "Nauruaans" },
            { "type.co.search", "algemeen zoeken" },
            { "nb", "Noors - Bokm\u00e5l" },
            { "nd", "Noord-Ndebele" },
            { "ne", "Nepalees" },
            { "ng", "Ndonga" },
            { "mdr", "Mandar" },
            { "nl", "Nederlands" },
            { "nn", "Noors - Nynorsk" },
            { "no", "Noors" },
            { "%%PROVENC", "Provenc" },
            { "nr", "Zuid-Ndbele" },
            { "type.nu.modi", "Modi cijfers" },
            { "Osge", metaValue_osa },
            { "nv", "Navajo" },
            { "kaa", "Karakalpaks" },
            { "ny", "Nyanja" },
            { "kac", "Kachin" },
            { "kab", "Kabylisch" },
            { "%%POLYTON", "Polytonaal" },
            { "oc", "Occitaans" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "men", metaValue_men },
            { "%%EMODENG", "Vroegmodern Engels" },
            { "oj", "Ojibwa" },
            { "mer", "Meru" },
            { "type.nu.armn", "Armeense cijfers" },
            { "om", "Afaan Oromo" },
            { "kaw", "Kawi" },
            { "dtp", "Dusun" },
            { "or", metaValue_or },
            { "Modi", "Modi" },
            { "os", "Ossetisch" },
            { "%%ALALC97", "Romanisering ALA-LC, editie 1997" },
            { "bpy", "Bishnupriya" },
            { "kbd", "Kabardisch" },
            { "mfe", "Morisyen" },
            { "srn", "Sranantongo" },
            { "pa", "Punjabi" },
            { "dua", "Duala" },
            { "srr", "Serer" },
            { "%%LIPAW", "Het Lipovaz-dialect van het Resiaans" },
            { "kbl", "Kanembu" },
            { "pi", "Pali" },
            { "bqi", "Bakhtiari" },
            { "pl", "Pools" },
            { "dum", "Middelnederlands" },
            { "%%TONGYONG", "Tongyong" },
            { "type.nu.saur", "Saurashtra cijfers" },
            { "type.ca.dangi", "Dangi-kalender" },
            { "%%VALLADER", "Vallader" },
            { "ps", "Pasjtoe" },
            { "pt", "Portugees" },
            { "mga", "Middeliers" },
            { "key.co", "sorteervolgorde" },
            { "%%BOHORIC", "Bohori\u010d-alfabet" },
            { "kcg", "Tyap" },
            { "mgh", "Makhuwa-Meetto" },
            { "key.cf", "valutanotatie" },
            { "type.nu.nkoo", "N\u2019Ko cijfers" },
            { "bra", "Braj" },
            { "key.ca", "kalender" },
            { "%%JAUER", "Jauer" },
            { "Laoo", metaValue_lo },
            { "%%SURMIRAN", "Surmiran" },
            { "mgo", "Meta\u2019" },
            { "type.hc.h23", "24-uursysteem (0-23)" },
            { "type.hc.h24", "24-uursysteem (1-24)" },
            { "ssy", metaValue_ssy },
            { "brh", "Brahui" },
            { "type.nu.mymr", "Myanmarese cijfers" },
            { "qu", "Quechua" },
            { "zap", "Zapotec" },
            { "brx", "Bodo" },
            { "Lana", "Lanna" },
            { "kde", "Makonde" },
            { "%%VAIDIKA", "Vaidika" },
            { "stq", "Saterfries" },
            { "Ethi", "Ethiopisch" },
            { "%%JYUTPING", "Jyutping" },
            { "type.hc.h12", "12-uursysteem (1-12)" },
            { "type.hc.h11", "12-uursysteem (0-11)" },
            { "rm", "Reto-Romaans" },
            { "rn", "Kirundi" },
            { "key.cu", "valuta" },
            { "ro", "Roemeens" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "Odia cijfers" },
            { "type.nu.hanidec", "Chinese decimale getallen" },
            { "ru", "Russisch" },
            { "bss", "Akoose" },
            { "zbl", metaValue_zbl },
            { "rw", "Kinyarwanda" },
            { "kea", "Kaapverdisch Creools" },
            { "mic", "Mi\u2019kmaq" },
            { "suk", "Sukuma" },
            { "Dupl", "Duployan snelschrift" },
            { "sa", "Sanskriet" },
            { "%%UCCOR", "Eenvormige spelling" },
            { "sc", "Sardijns" },
            { "sus", "Soesoe" },
            { "sd", metaValue_sd },
            { "se", "Noord-Samisch" },
            { "min", "Minangkabau" },
            { "sg", "Sango" },
            { "sh", "Servo-Kroatisch" },
            { "ken", "Kenyang" },
            { "si", metaValue_si },
            { "sux", "Soemerisch" },
            { "sk", "Slowaaks" },
            { "sl", "Sloveens" },
            { "Gran", "Grantha" },
            { "sm", "Samoaans" },
            { "%%BASICENG", "Standaard Engels" },
            { "sn", "Shona" },
            { "so", "Somalisch" },
            { "type.nu.arab", "Arabisch-Indische cijfers" },
            { "sq", "Albanees" },
            { "sr", "Servisch" },
            { "ss", "Swazi" },
            { "type.cf.account", "financi\u00eble valutanotatie" },
            { "Java", metaValue_jv },
            { "st", "Zuid-Sotho" },
            { "su", metaValue_su },
            { "%%NEDIS", "Natisone-dialect" },
            { "sv", "Zweeds" },
            { "sw", "Swahili" },
            { "type.nu.wcho", "Wancho cijfers" },
            { "type.nu.hantfin", "traditioneel Chinese financi\u00eble cijfers" },
            { "ibb", "Ibibio" },
            { "iba", "Iban" },
            { "ta", metaValue_ta },
            { "142", "Azi\u00eb" },
            { "bua", "Boerjatisch" },
            { "143", "Centraal-Azi\u00eb" },
            { "te", metaValue_te },
            { "Toto", "Totoschrift" },
            { "145", "West-Azi\u00eb" },
            { "tg", "Tadzjieks" },
            { "th", metaValue_th },
            { "%%SPANGLIS", "Spanglis" },
            { "bug", metaValue_bug },
            { "ti", "Tigrinya" },
            { "kfo", "Koro" },
            { "tk", "Turkmeens" },
            { "tl", metaValue_tl },
            { "tn", "Tswana" },
            { "to", "Tongaans" },
            { "bum", "Bulu" },
            { "dyo", "Jola-Fonyi" },
            { "type.nu.jpan", "Japanse cijfers" },
            { "tr", "Turks" },
            { "Cakm", metaValue_ccp },
            { "ts", "Tsonga" },
            { "swb", "Shimaore" },
            { "tt", "Tataars" },
            { "%%XSISTEMO", "X-sistemo" },
            { "dyu", "Dyula" },
            { "tw", "Twi" },
            { "ty", "Tahitiaans" },
            { "%%BISKE", "San Giorgio/Bila-dialect" },
            { "150", "Europa" },
            { "151", "Oost-Europa" },
            { "type.nu.rohg", "Hanifi Rohingya cijfers" },
            { "type.nu.mathsanb", "schreefloze vette wiskundige cijfers" },
            { "154", "Noord-Europa" },
            { "dzg", "Dazaga" },
            { "155", "West-Europa" },
            { "ug", "Oeigoers" },
            { "Kore", metaValue_ko },
            { "Ital", "Oud-italisch" },
            { "kgp", "Kaingang" },
            { "Zyyy", "algemeen" },
            { "uk", "Oekra\u00efens" },
            { "zea", "Zeeuws" },
            { "type.ca.coptic", "Koptische kalender" },
            { "ur", "Urdu" },
            { "%%1994", "Gestandaardiseerde Resiaanse spelling" },
            { "xal", "Kalmuks" },
            { "zen", "Zenaga" },
            { "uz", "Oezbeeks" },
            { "kha", "Khasi" },
            { "%%1996", "Duitse spelling van 1996" },
            { "nds_NL", "Nederduits" },
            { "Sylo", "Syloti Nagri" },
            { "ve", "Venda" },
            { "Wara", "Varang Kshiti" },
            { "type.ca.roc", "Kalender van de Chinese Republiek" },
            { "vi", "Vietnamees" },
            { "kho", "Khotanees" },
            { "khq", "Koyra Chiini" },
            { "key.hc", "uursysteem (12 of 24)" },
            { "%%TARASK", "Taraskievica-spelling" },
            { "vo", "Volap\u00fck" },
            { "khw", "Khowar" },
            { "syc", "Klassiek Syrisch" },
            { "type.nu.mathsans", "schreefloze wiskundige cijfers" },
            { "Osma", "Osmanya" },
            { "quc", "K\u2019iche\u2019" },
            { "type.nu.gonm", "Masaram Gondi cijfers" },
            { "qug", "Kichwa" },
            { "Newa", metaValue_new },
            { "gaa", "Ga" },
            { "wa", "Waals" },
            { "gag", "Gagaoezisch" },
            { "syr", "Syrisch" },
            { "Cpmn", "Cypro-Mino\u00efsch" },
            { "type.nu.gong", "Gunjala Gondi cijfers" },
            { "Grek", metaValue_el },
            { "gan", "Ganyu" },
            { "kiu", "Kirmanck\u00ee" },
            { "Lydi", "Lydisch" },
            { "Xsux", "Sumero-Akkadian Cuneiform" },
            { "wo", "Wolof" },
            { "zgh", "Standaard Marokkaanse Tamazight" },
            { "ar_001", "modern standaard Arabisch" },
            { "Cans", "Verenigde Canadese Aboriginal-symbolen" },
            { "%%FONXSAMP", "Transcriptie volgens X-SAMPA" },
            { "gay", "Gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "Mantsjoe" },
            { "Latf", "Gotisch Latijns" },
            { "szl", "Silezisch" },
            { "Hluw", "Anatolische hi\u00ebrogliefen" },
            { "gba", "Gbaya" },
            { "mni", metaValue_mni },
            { "Latn", "Latijns" },
            { "Latg", "Gaelisch Latijns" },
            { "Nand", "Nandinagari" },
            { "type.nu.hans", "vereenvoudigd Chinese cijfers" },
            { "type.nu.hant", "traditioneel Chinese cijfers" },
            { "xh", "Xhosa" },
            { "type.nu.romanlow", "kleine Romeinse cijfers" },
            { "byn", "Blin" },
            { "Dogr", "Dogra" },
            { "%%PAMAKA", "Pamaka" },
            { "Lyci", "Lycisch" },
            { "osa", metaValue_osa },
            { "byv", "Medumba" },
            { "gbz", "Zoroastrisch Dari" },
            { "Moon", "Moon" },
            { "moh", "Mohawk" },
            { "kkj", "Kako" },
            { "%%1694ACAD", "Vroeg modern Frans" },
            { "yi", "Jiddisch" },
            { "mos", "Mossi" },
            { "Syrc", "Syriac" },
            { "Dsrt", "Deseret" },
            { "yo", "Yoruba" },
            { "type.nu.traditional", "Traditionele cijfers" },
            { "Syrj", "West-Aramees" },
            { "ota", "Ottomaans-Turks" },
            { "Syre", "Estrangelo Aramees" },
            { "vai", metaValue_vai },
            { "za", "Zhuang" },
            { "Cari", "Carisch" },
            { "kln", "Kalenjin" },
            { "zh", "Chinees" },
            { "Afak", "Defaka" },
            { "Bopo", "Bopomofo" },
            { "Perm", "Oudpermisch" },
            { "key.lb", "stijl regelafbreking" },
            { "zu", "Zoeloe" },
            { "type.co.phonebook", "Telefoonboeksorteervolgorde" },
            { "%%MONOTON", "Monotonaal" },
            { "Geor", metaValue_ka },
            { "Shrd", "Sharada" },
            { "%%LENGADOC", "Lengadoc" },
            { "kmb", "Kimbundu" },
            { "type.nu.jpanfin", "Japanse financi\u00eble cijfers" },
            { "Cham", "Cham" },
            { "gez", "Ge\u2019ez" },
            { "mrj", "West-Mari" },
            { "Syrn", "Oost-Aramees" },
            { "type.nu.mymrshan", "Myanmarese Shan cijfers" },
            { "Elba", "Elbasan" },
            { "Narb", "Oud Noord-Arabisch" },
            { "type.nu.olck", "Ol Chiki cijfers" },
            { "type.co.reformed", "Herziene sorteervolgorde" },
            { "Tglg", metaValue_tl },
            { "Egyd", "Egyptisch demotisch" },
            { "Egyh", "Egyptisch hi\u00ebratisch" },
            { "Yezi", "Jezidi" },
            { "%%ITIHASA", "Episch Sanskriet" },
            { "Palm", "Palmyreens" },
            { "ebu", "Embu" },
            { "Egyp", "Egyptische hi\u00ebrogliefen" },
            { "Geok", "Georgisch Khutsuri" },
            { "koi", "Komi-Permjaaks" },
            { "Hung", "Oudhongaars" },
            { "kok", "Konkani" },
            { "%%1901", "Traditionele Duitse spelling" },
            { "kos", "Kosraeaans" },
            { "vec", "Venetiaans" },
            { "%%PAHAWH2", "Pahawh2" },
            { "%%PAHAWH3", "Pahawh3" },
            { "%%PAHAWH4", "Pahawh4" },
            { "type.nu.limb", "Limbu cijfers" },
            { "Sund", metaValue_su },
            { "vep", "Wepsisch" },
            { "kpe", metaValue_kpe },
            { "%%GRCLASS", "Grclass" },
            { "type.nu.khmr", "Khmer cijfers" },
            { "Tirh", "Tirhuta" },
            { "ilo", "Iloko" },
            { "%%VALENCIA", "Valenciaans" },
            { "Cprt", "Cyprisch" },
            { "Diak", "Dives Akuru" },
            { "%%BAKU1926", "Eenvormig Turkse Latijnse alfabet" },
            { "%%IJEKAVSK", "Servisch met Ijekaviaanse uitspraak" },
            { "mua", "Mundang" },
            { "type.nu.guru", "Gurmukhi cijfers" },
            { "%%BORNHOLM", "Bornholms" },
            { "mul", "meerdere talen" },
            { "%%PUTER", "Puter" },
            { "cad", "Caddo" },
            { "key.ms", "maatsysteem" },
            { "mus", "Creek" },
            { "Glag", "Glagolitisch" },
            { "gil", "Gilbertees" },
            { "%%KKCOR", "Algemene spelling" },
            { "Cher", metaValue_chr },
            { "car", "Caribisch" },
            { "cay", "Cayuga" },
            { "type.nu.tamldec", "Tamil cijfers" },
            { "krc", "Karatsjaj-Balkarisch" },
            { "inh", "Ingoesjetisch" },
            { "krj", "Kinaray-a" },
            { "kri", "Krio" },
            { "fa_AF", "Dari" },
            { "krl", "Karelisch" },
            { "%%OXENDICT", "Spelling volgens het Oxford English Dictionary" },
            { "efi", "Efik" },
            { "tcy", "Tulu" },
            { "key.nu", "cijfers" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
