/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.completion;

import com.google.common.base.Strings;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposalComparator;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemDefaults;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSContentAssistProcessor
implements IContentAssistProcessor {
    private static final long TRIGGERS_TIMEOUT = 50L;
    private static final long CONTEXT_INFORMATION_TIMEOUT = 1000L;
    private IDocument currentDocument;
    private String errorMessage;
    private final boolean errorAsCompletionItem;
    private CompletableFuture<@NonNull List<@NonNull Void>> completionLanguageServersFuture;
    private final Object completionTriggerCharsSemaphore = new Object();
    private char[] completionTriggerChars = new char[0];
    private CompletableFuture<@NonNull List<@NonNull Void>> contextInformationLanguageServersFuture;
    private final Object contextTriggerCharsSemaphore = new Object();
    private char[] contextTriggerChars = new char[0];
    private final Comparator<LSCompletionProposal> proposalComparator = new LSCompletionProposalComparator();

    public LSContentAssistProcessor() {
        this(true);
    }

    public LSContentAssistProcessor(boolean errorAsCompletionItem) {
        this.errorAsCompletionItem = errorAsCompletionItem;
    }

    /*
     * WARNING - void declaration
     */
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        CompletionParams param;
        IDocument document = viewer.getDocument();
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return new LSCompletionProposal[0];
        }
        this.initiateLanguageServers(document);
        try {
            param = LSPEclipseUtils.toCompletionParams(uri, offset, document);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            this.errorMessage = this.createErrorMessage(offset, (Exception)((Object)e));
            return this.createErrorProposal(offset, (Exception)((Object)e));
        }
        List<ICompletionProposal> proposals = Collections.synchronizedList(new ArrayList());
        try {
            this.completionLanguageServersFuture = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withFilter(capabilities -> capabilities.getCompletionProvider() != null)).collectAll((w, ls) -> ls.getTextDocumentService().completion(param).thenAccept(completion -> {
                boolean bl = proposals.addAll(LSContentAssistProcessor.toProposals(document, offset, (Either<List<CompletionItem>, CompletionList>)completion, w));
            }));
            this.completionLanguageServersFuture.get();
        }
        catch (ExecutionException e) {
            LanguageServerPlugin.logError(e);
            this.errorMessage = this.createErrorMessage(offset, e);
            return this.createErrorProposal(offset, e);
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            this.errorMessage = this.createErrorMessage(offset, e);
            Thread.currentThread().interrupt();
            return this.createErrorProposal(offset, e);
        }
        ICompletionProposal[] completeProposals = new LSCompletionProposal[proposals.size()];
        int i = 0;
        for (ICompletionProposal proposal : proposals) {
            ICompletionProposal iCompletionProposal = proposal;
            if (iCompletionProposal instanceof LSCompletionProposal) {
                void completeProposal;
                LSCompletionProposal cfr_ignored_0 = (LSCompletionProposal)iCompletionProposal;
                LSCompletionProposal cfr_ignored_1 = (LSCompletionProposal)iCompletionProposal;
                completeProposals[i] = completeProposal;
                ++i;
                continue;
            }
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        Arrays.sort(completeProposals, this.proposalComparator);
        return completeProposals;
    }

    private ICompletionProposal[] createErrorProposal(int offset, Exception ex) {
        if (this.errorAsCompletionItem) {
            return new ICompletionProposal[]{new CompletionProposal("", offset, 0, 0, null, Messages.completionError, null, ex.getMessage())};
        }
        return new ICompletionProposal[0];
    }

    private String createErrorMessage(int offset, Exception ex) {
        return String.valueOf(Messages.completionError) + " : " + ex.getMessage();
    }

    private void initiateLanguageServers(@NonNull IDocument document) {
        if (this.currentDocument != document) {
            this.currentDocument = document;
            if (this.completionLanguageServersFuture != null) {
                try {
                    this.completionLanguageServersFuture.cancel(true);
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
            }
            if (this.contextInformationLanguageServersFuture != null) {
                try {
                    this.contextInformationLanguageServersFuture.cancel(true);
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
            }
            this.completionTriggerChars = new char[0];
            this.contextTriggerChars = new char[0];
            this.completionLanguageServersFuture = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withFilter(capabilities -> capabilities.getCompletionProvider() != null)).collectAll((w, ls) -> {
                CompletionOptions provider = w.getServerCapabilities().getCompletionProvider();
                Object object = this.completionTriggerCharsSemaphore;
                synchronized (object) {
                    this.completionTriggerChars = LSContentAssistProcessor.mergeTriggers(this.completionTriggerChars, provider.getTriggerCharacters());
                }
                return CompletableFuture.completedFuture(null);
            });
            this.contextInformationLanguageServersFuture = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withFilter(capabilities -> capabilities.getSignatureHelpProvider() != null)).collectAll((w, ls) -> {
                SignatureHelpOptions provider = w.getServerCapabilities().getSignatureHelpProvider();
                Object object = this.contextTriggerCharsSemaphore;
                synchronized (object) {
                    this.contextTriggerChars = LSContentAssistProcessor.mergeTriggers(this.contextTriggerChars, provider.getTriggerCharacters());
                }
                return CompletableFuture.completedFuture(null);
            });
        }
    }

    private void initiateLanguageServers() {
        IDocument document;
        ITextEditor textEditor = UI.getActiveTextEditor();
        if (textEditor != null && (document = LSPEclipseUtils.getDocument(textEditor)) != null) {
            this.initiateLanguageServers(document);
        }
    }

    private static List<ICompletionProposal> toProposals(IDocument document, int offset, Either<List<CompletionItem>, CompletionList> completionList, LanguageServerWrapper languageServerWrapper) {
        if (completionList == null) {
            return Collections.emptyList();
        }
        CompletionItemDefaults defaults = (CompletionItemDefaults)completionList.map(o -> null, CompletionList::getItemDefaults);
        List items = completionList.isLeft() ? (List)completionList.getLeft() : ((CompletionList)completionList.getRight()).getItems();
        boolean isIncomplete = completionList.isRight() ? ((CompletionList)completionList.getRight()).isIncomplete() : false;
        return items.stream().filter(Objects::nonNull).map(item -> new LSCompletionProposal(document, offset, (CompletionItem)item, defaults, languageServerWrapper, isIncomplete)).filter(proposal -> proposal.validate(document, offset, null)).map(ICompletionProposal.class::cast).toList();
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        SignatureHelpParams param;
        IDocument document = viewer.getDocument();
        if (document == null) {
            return new IContextInformation[0];
        }
        this.initiateLanguageServers(document);
        try {
            param = LSPEclipseUtils.toSignatureHelpParams(offset, document);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return new IContextInformation[0];
        }
        List contextInformations = Collections.synchronizedList(new ArrayList());
        try {
            this.contextInformationLanguageServersFuture = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withFilter(capabilities -> capabilities.getSignatureHelpProvider() != null)).collectAll(ls -> ls.getTextDocumentService().signatureHelp(param).thenAccept(signatureHelp -> {
                if (signatureHelp != null) {
                    signatureHelp.getSignatures().stream().map(LSContentAssistProcessor::toContextInformation).forEach(contextInformations::add);
                }
            }));
            this.contextInformationLanguageServersFuture.get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            LanguageServerPlugin.logError(e);
            return new IContextInformation[0];
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
            return new IContextInformation[0];
        }
        catch (TimeoutException e) {
            LanguageServerPlugin.logWarning("Could not compute  context information due to timeout after 1000 miliseconds", e);
            return new IContextInformation[0];
        }
        return contextInformations.toArray(new IContextInformation[0]);
    }

    private static IContextInformation toContextInformation(SignatureInformation information) {
        StringBuilder signature = new StringBuilder(information.getLabel());
        String docString = LSPEclipseUtils.getDocString((Either<String, MarkupContent>)information.getDocumentation());
        if (docString != null && !docString.isEmpty()) {
            signature.append('\n').append(docString);
        }
        ContextInformation contextInformation = new ContextInformation(information.getLabel(), signature.toString());
        return contextInformation;
    }

    private void getFuture(CompletableFuture<@NonNull List<@NonNull Void>> future) {
        if (future == null) {
            return;
        }
        try {
            future.get(50L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | OperationCanceledException e) {
            LanguageServerPlugin.logError(e);
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            LanguageServerPlugin.logWarning("Could not get trigger characters due to timeout after 50 miliseconds", e);
        }
    }

    private static char[] mergeTriggers(char[] initialArray, Collection<String> additionalTriggers) {
        if (initialArray == null) {
            initialArray = new char[]{};
        }
        if (additionalTriggers == null) {
            additionalTriggers = Collections.emptySet();
        }
        HashSet<Character> triggers = new HashSet<Character>(initialArray.length);
        char[] cArray = initialArray;
        int n = initialArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            triggers.add(Character.valueOf(c));
            ++n2;
        }
        additionalTriggers.stream().filter(s -> !Strings.isNullOrEmpty((String)s)).map(triggerChar -> Character.valueOf(triggerChar.charAt(0))).forEach(triggers::add);
        char[] res = new char[triggers.size()];
        int i = 0;
        for (Character c : triggers) {
            res[i] = c.charValue();
            ++i;
        }
        return res;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        this.initiateLanguageServers();
        this.getFuture(this.completionLanguageServersFuture);
        return this.completionTriggerChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        this.initiateLanguageServers();
        this.getFuture(this.contextInformationLanguageServersFuture);
        return this.contextTriggerChars;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator((IContentAssistProcessor)this);
    }
}

