/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.synchronize.filesystem;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.team.ResourceRuleFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.internal.importexport.files.Utilities;
import org.eclipse.rse.internal.synchronize.RSESyncUtils;
import org.eclipse.rse.internal.synchronize.filesystem.FileModificationValidator;
import org.eclipse.rse.internal.synchronize.filesystem.FileSystemOperations;
import org.eclipse.rse.internal.synchronize.filesystem.FileSystemPlugin;
import org.eclipse.rse.internal.synchronize.filesystem.Policy;
import org.eclipse.rse.internal.synchronize.filesystem.subscriber.FileSystemResourceVariant;
import org.eclipse.rse.internal.synchronize.filesystem.subscriber.FileSystemSubscriber;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.core.variants.IResourceVariant;

public class FileSystemProvider
extends RepositoryProvider {
    private static final ResourceRuleFactory RESOURCE_RULE_FACTORY = new ResourceRuleFactory(){};
    private IPath remoteRootPath;
    private IPath localRootPath;
    private UniFilePlus remoteRoot;
    private Map _resourceMap = new HashMap();
    private static QualifiedName FILESYSTEM_REPO_LOC = new QualifiedName("org.eclipse.rse.internal.synchronize", "disk_location");

    public void reset() {
        this._resourceMap.clear();
    }

    public void configureProject() throws CoreException {
        FileSystemSubscriber.getInstance().handleRootChanged((IResource)this.getProject(), true);
    }

    public void deconfigure() throws CoreException {
        this.getProject().setPersistentProperty(FILESYSTEM_REPO_LOC, null);
        FileSystemSubscriber.getInstance().handleRootChanged((IResource)this.getProject(), false);
    }

    public String getID() {
        return RSESyncUtils.PROVIDER_ID;
    }

    public void setRemoteLocation(String location) throws TeamException {
        this.remoteRootPath = new Path(location);
        File file = new File(location);
        if (file.exists() && !file.isDirectory()) {
            throw new TeamException(Policy.bind("FileSystemProvider.mustBeFolder", location));
        }
        try {
            this.getProject().setPersistentProperty(FILESYSTEM_REPO_LOC, location);
        }
        catch (CoreException e) {
            throw FileSystemPlugin.wrapException(e);
        }
    }

    public void setLocalLocation(IPath location) {
        this.localRootPath = location;
    }

    public IPath getRemoteRoot() {
        if (this.remoteRootPath == null) {
            String location;
            block4: {
                try {
                    location = this.getProject().getPersistentProperty(FILESYSTEM_REPO_LOC);
                    if (location != null) break block4;
                    return null;
                }
                catch (CoreException e) {
                    FileSystemPlugin.log(e);
                    return null;
                }
            }
            this.remoteRootPath = new Path(location);
        }
        return this.remoteRootPath;
    }

    public FileSystemOperations getOperations() {
        return new FileSystemOperations(this);
    }

    public IFileModificationValidator getFileModificationValidator() {
        return this.getFileModificationValidator2();
    }

    public org.eclipse.core.resources.team.FileModificationValidator getFileModificationValidator2() {
        return new FileModificationValidator(this);
    }

    public IResourceVariant getResourceVariant(IResource resource, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        UniFilePlus file = (UniFilePlus)this.getExportFile(resource);
        if (file == null) {
            return null;
        }
        return new FileSystemResourceVariant(file, bytes);
    }

    public IResourceVariant getExportResourceVariant(IResource resource) {
        UniFilePlus file = (UniFilePlus)this.getExportFile(resource);
        if (file == null || !file.exists()) {
            return null;
        }
        return new FileSystemResourceVariant(file);
    }

    public IResourceVariant getImportResourcevariant(IResource resource) {
        UniFilePlus file = (UniFilePlus)this.getImportFile(resource);
        if (file == null || !file.exists()) {
            return null;
        }
        return new FileSystemResourceVariant(file);
    }

    public File getExportFile(IResource resource) {
        UniFilePlus file = (UniFilePlus)this._resourceMap.get(resource);
        try {
            if (resource.getProject().equals((Object)this.getProject())) {
                UniFilePlus root = this.getRemoteRootFolder();
                String relativePath = this.transformInDependency(root.getRemoteFile().getHost(), resource.getFullPath().toString());
                String path = String.valueOf(root.getRemoteFile().getAbsolutePath()) + relativePath;
                IRemoteFile remoteFile = root.getRemoteFile().getParentRemoteFileSubSystem().getRemoteFileObject(path, null);
                file = new UniFilePlus(remoteFile);
                this._resourceMap.put(resource, file);
            }
        }
        catch (SystemMessageException e) {
            e.printStackTrace();
        }
        return file;
    }

    public File getImportFile(IResource resource) {
        UniFilePlus file = (UniFilePlus)this._resourceMap.get(resource);
        try {
            if (resource.getProject().equals((Object)this.getProject())) {
                UniFilePlus root = this.getRemoteRootFolder();
                String relativePath = this.transformInDependency(root.getRemoteFile().getHost(), resource.getFullPath().toString());
                String path = String.valueOf(root.getRemoteFile().getAbsolutePath()) + relativePath;
                IRemoteFile remoteFile = root.getRemoteFile().getParentRemoteFileSubSystem().getRemoteFileObject(path, null);
                file = new UniFilePlus(remoteFile);
                this._resourceMap.put(resource, file);
            }
        }
        catch (SystemMessageException e) {
            e.printStackTrace();
        }
        return file;
    }

    private boolean isFile(IResource resource) {
        return new File(this.transformRSEtoNormal(resource.getLocation().toString())).isFile();
    }

    public IResourceRuleFactory getRuleFactory() {
        return RESOURCE_RULE_FACTORY;
    }

    public IFileHistoryProvider getFileHistoryProvider() {
        return null;
    }

    private String transformRSEtoNormal(String original) {
        if (original.indexOf(":") == -1) {
            return original;
        }
        String transformed = "";
        String[] str = original.split(":");
        transformed = str.length > 2 ? String.valueOf(transformed) + str[1] + ":" + str[2] : String.valueOf(transformed) + str[1];
        return transformed;
    }

    public UniFilePlus getRemoteRootFolder() {
        if (this.remoteRoot == null) {
            IPath remoteRootDir = this.getRemoteRoot();
            String remoteRootDirString = this.transformRSEtoNormal(remoteRootDir.toString());
            IHost conn = Utilities.parseForSystemConnection(remoteRootDir.toString());
            String absolutePath = this.transformInDependency(conn, remoteRootDirString);
            return new UniFilePlus(Utilities.getIRemoteFile(conn, absolutePath));
        }
        return this.remoteRoot;
    }

    private String transformInDependency(IHost host, String original) {
        String ret = "";
        IRSESystemType type = host.getSystemType();
        ret = host.getSystemType().isWindows() ? original.replace("/", "\\") : original.replace("\\", "/");
        if (this.localRootPath != null) {
            String[] lsegs = this.localRootPath.segments();
            String[] rsegs = ret.substring(1).split("/");
            StringBuffer newPath = new StringBuffer();
            int i = 0;
            while (i < rsegs.length) {
                if (lsegs.length > i) {
                    if (!lsegs[i].equals(rsegs[i])) {
                        newPath.append("/");
                        newPath.append(rsegs[i]);
                    }
                } else {
                    newPath.append("/");
                    newPath.append(rsegs[i]);
                }
                ++i;
            }
            ret = newPath.toString();
        }
        return ret;
    }
}

