/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.components;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.model.ObserveTypeContainer;
import org.eclipse.wb.internal.core.databinding.parser.IModelResolver;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.databinding.model.ObserveCreationType;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanSupport;
import org.eclipse.wb.internal.swing.databinding.model.components.ComponentObserveInfo;

public final class ComponentsObserveTypeContainer
extends ObserveTypeContainer {
    private List<IObserveInfo> m_observes = Collections.emptyList();

    public ComponentsObserveTypeContainer() {
        super(ObserveType.WIDGETS, true, false);
    }

    public List<IObserveInfo> getObservables() {
        return this.m_observes;
    }

    public void synchronizeObserves(JavaInfo root, AstEditor editor, TypeDeclaration rootNode) throws Exception {
        int count = this.m_observes.size();
        int i = 0;
        while (i < count) {
            ComponentObserveInfo observe = (ComponentObserveInfo)this.m_observes.get(i);
            observe.update();
            ++i;
        }
    }

    public void createObservables(JavaInfo root, IModelResolver resolver, AstEditor editor, TypeDeclaration rootNode) throws Exception {
        this.m_observes = Lists.newArrayList();
        this.m_observes.add(new ComponentObserveInfo(new BeanSupport(), root));
    }

    public AstObjectInfo parseExpression(AstEditor editor, String signature, ClassInstanceCreation creation, Expression[] arguments, IModelResolver resolver, IDatabindingsProvider provider) throws Exception {
        return null;
    }

    public AstObjectInfo parseExpression(AstEditor editor, String signature, MethodInvocation invocation, Expression[] arguments, IModelResolver resolver) throws Exception {
        return null;
    }

    public ObserveInfo resolve(Expression expression) throws Exception {
        for (IObserveInfo iobserve : this.m_observes) {
            ComponentObserveInfo observe = (ComponentObserveInfo)iobserve;
            ComponentObserveInfo resultInfo = observe.resolve(expression);
            if (resultInfo == null) continue;
            return resultInfo;
        }
        return null;
    }

    public ObserveInfo resolve(JavaInfo javaInfo) throws Exception {
        for (IObserveInfo iobserve : this.m_observes) {
            ComponentObserveInfo observe = (ComponentObserveInfo)iobserve;
            ComponentObserveInfo resultInfo = observe.resolve(javaInfo);
            if (resultInfo == null) continue;
            return resultInfo;
        }
        return null;
    }

    public ObserveInfo resolve(String reference) throws Exception {
        for (IObserveInfo iobserve : this.m_observes) {
            ComponentObserveInfo observe = (ComponentObserveInfo)iobserve;
            ComponentObserveInfo resultInfo = observe.resolve(reference);
            if (resultInfo == null) continue;
            return resultInfo;
        }
        return null;
    }

    public static ObserveCreationType getCreationType(Class<?> objectType) {
        if (JList.class.isAssignableFrom(objectType)) {
            return ObserveCreationType.JListBinding;
        }
        if (JTable.class.isAssignableFrom(objectType)) {
            return ObserveCreationType.JTableBinding;
        }
        if (JComboBox.class.isAssignableFrom(objectType)) {
            return ObserveCreationType.JComboBoxBinding;
        }
        return ObserveCreationType.AutoBinding;
    }
}

