/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.xml.parser;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.parser.ParseState;
import org.eclipse.wb.internal.core.databinding.xml.model.IDatabindingFactory;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.xml.model.IRootProcessor;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;

public final class DatabindingRootProcessor
implements IRootProcessor {
    public static final IRootProcessor INSTANCE = new DatabindingRootProcessor();
    public static final Map<IDocument, ParseState> STATES = Maps.newHashMap();
    private List<IDatabindingFactory> m_factories;

    public void process(final XmlObjectInfo root) throws Exception {
        if (this.m_factories == null) {
            this.m_factories = ExternalFactoriesHelper.getElementsInstances(IDatabindingFactory.class, (String)"org.eclipse.wb.core.databinding.xml.databindingFactories", (String)"factory");
        }
        for (IDatabindingFactory factory : this.m_factories) {
            IDatabindingsProvider databindingsProvider = factory.createProvider(root);
            if (databindingsProvider == null) continue;
            STATES.put(root.getContext().getDocument(), new ParseState(databindingsProvider, factory.getPlugin()));
            root.addBroadcastListener((Object)new ObjectEventListener(){

                public void dispose() throws Exception {
                    STATES.remove(root.getContext().getDocument());
                }
            });
            return;
        }
    }
}

