/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.problems;

import java.util.List;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.metadata.IProperty;
import org.eclipse.xwt.tools.ui.designer.core.problems.Problem;
import org.eclipse.xwt.tools.ui.designer.core.util.DomHelper;
import org.eclipse.xwt.tools.ui.designer.editor.problems.XWTAbstractNodeChecker;
import org.eclipse.xwt.tools.ui.designer.utils.XWTUtility;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XWTAttributeChecker
extends XWTAbstractNodeChecker {
    @Override
    protected void checkNode(Node node, List<Problem> problems) {
        if (node == null || 3 == node.getNodeType()) {
            return;
        }
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null) {
            int i = 0;
            while (i < childNodes.getLength()) {
                this.checkNode(childNodes.item(i), problems);
                ++i;
            }
        }
        String nodeName = node.getNodeName();
        String prefix = node.getPrefix();
        String ns = DomHelper.lookupNamespaceURI((Node)node, (String)prefix);
        int index = nodeName.indexOf(":");
        if (index != -1) {
            nodeName = nodeName.substring(index + 1);
        }
        String attrName = null;
        index = nodeName.indexOf(".");
        if (index != -1) {
            attrName = nodeName.substring(index + 1);
            nodeName = nodeName.substring(0, index);
        }
        IMetaclass metaclass = XWTUtility.getMetaclass(nodeName, ns);
        if (attrName != null) {
            index = attrName.indexOf(".");
            while (index != -1) {
                String newAttr = attrName.substring(0, index);
                attrName = attrName.substring(index + 1);
                index = attrName.indexOf(".");
                if (newAttr == null || "Resources".equalsIgnoreCase(newAttr) || "DataContext".equalsIgnoreCase(newAttr)) continue;
                IProperty p = metaclass.findProperty(newAttr);
                if (p == null && metaclass.findEvent(attrName) == null) {
                    problems.add(this.createError(node, "\"" + newAttr + "\" can not be resolved to a property of \"" + nodeName + "\""));
                }
                if (p == null) continue;
                metaclass = XWT.getMetaclass((Object)p.getType());
            }
            if (metaclass != null && attrName != null && !"Resources".equalsIgnoreCase(attrName) && !"DataContext".equalsIgnoreCase(attrName)) {
                IProperty p = metaclass.findProperty(attrName);
                if (p == null && metaclass.findEvent(attrName) == null) {
                    problems.add(this.createError(node, "\"" + attrName + "\" can not be resolved to a property of \"" + nodeName + "\""));
                }
                if (p != null) {
                    metaclass = XWT.getMetaclass((Object)p.getType());
                }
            }
        }
        NamedNodeMap attributes = node.getAttributes();
        if (metaclass == null || attributes == null || attributes.getLength() == 0) {
            return;
        }
        int i = 0;
        while (i < attributes.getLength()) {
            Node item = attributes.item(i);
            attrName = item.getNodeName();
            if (!attrName.startsWith("xmlns")) {
                if (attrName.indexOf(":") != -1) {
                    attrName = attrName.substring(attrName.indexOf(":") + 1);
                }
                if (!("Key".equalsIgnoreCase(attrName) || "Name".equalsIgnoreCase(attrName) || "Class".equalsIgnoreCase(attrName) || "style".equalsIgnoreCase(attrName))) {
                    IMetaclass attachedMetaclass = null;
                    index = attrName.indexOf(".");
                    while (index != -1) {
                        String attachedName = attrName.substring(0, index);
                        attrName = attrName.substring(index + 1);
                        index = attrName.indexOf(".");
                        if (attachedName == null) continue;
                        attachedMetaclass = XWTUtility.getMetaclass(attachedName, ns);
                    }
                    if (metaclass.findProperty(attrName) == null && metaclass.findEvent(attrName) == null && attachedMetaclass != null && attachedMetaclass.findProperty(attrName) == null && attachedMetaclass.findEvent(attrName) == null) {
                        problems.add(this.createError(node, "\"" + attrName + "\" can not be resolved to a property of \"" + nodeName + "\""));
                    }
                }
            }
            ++i;
        }
    }
}

