/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.policies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xwt.tools.ui.designer.commands.ApplyAttributeSettingCommand;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class ElementDirectEditPolicy
extends DirectEditPolicy {
    private boolean setting = false;

    protected Command getDirectEditCommand(DirectEditRequest request) {
        String value = (String)request.getCellEditor().getValue();
        XamlElement element = (XamlElement)this.getHost().getModel();
        return new ApplyAttributeSettingCommand((XamlNode)element, "text", "http://www.eclipse.org/xwt/presentation", value);
    }

    protected void eraseDirectEditFeedback(DirectEditRequest request) {
        super.eraseDirectEditFeedback(request);
        this.setting = false;
    }

    protected void showCurrentEditValue(DirectEditRequest request) {
    }

    protected void showDirectEditFeedback(DirectEditRequest request) {
        CellEditor cellEditor = request.getCellEditor();
        if (cellEditor == null) {
            return;
        }
        if (!this.setting) {
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)this.getHost();
            IFigure figure = graphicalEditPart.getFigure();
            XamlElement element = (XamlElement)this.getHost().getModel();
            XamlAttribute attribute = element.getAttribute("text", "http://www.eclipse.org/xwt/presentation");
            if (attribute == null) {
                return;
            }
            String value = attribute.getValue();
            cellEditor.setValue((Object)value);
            Control control = request.getCellEditor().getControl();
            if (control instanceof Text) {
                Rectangle rectangle = figure.getBounds();
                Text text = (Text)control;
                text.setLocation(rectangle.x, rectangle.y);
                text.selectAll();
            }
        }
        this.setting = true;
    }

    public boolean understandsRequest(Request request) {
        if (request instanceof DirectEditRequest) {
            DirectEditRequest directEditRequest = (DirectEditRequest)request;
            XamlElement element = (XamlElement)this.getHost().getModel();
            XamlAttribute attribute = element.getAttribute("text", "http://www.eclipse.org/xwt/presentation");
            if (directEditRequest.getCellEditor() == null || attribute == null) {
                return false;
            }
        }
        return super.understandsRequest(request);
    }
}

