// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test.proto

#include "generator/integration_tests/golden/v1/internal/golden_thing_admin_metadata_decorator.h"
#include "google/cloud/common_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/absl_str_join_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/routing_matcher.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <generator/integration_tests/test.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace golden_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GoldenThingAdminMetadata::GoldenThingAdminMetadata(
    std::shared_ptr<GoldenThingAdminStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::test::admin::database::v1::ListDatabasesResponse>
GoldenThingAdminMetadata::ListDatabases(
    grpc::ClientContext& context,
    google::test::admin::database::v1::ListDatabasesRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(), absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListDatabases(context, request);
}

future<StatusOr<google::longrunning::Operation>>
GoldenThingAdminMetadata::AsyncCreateDatabase(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    Options const& options,
    google::test::admin::database::v1::CreateDatabaseRequest const& request) {
  SetMetadata(*context, options, absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateDatabase(cq, std::move(context), options, request);
}

StatusOr<google::test::admin::database::v1::Database>
GoldenThingAdminMetadata::GetDatabase(
    grpc::ClientContext& context,
    google::test::admin::database::v1::GetDatabaseRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(), absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetDatabase(context, request);
}

future<StatusOr<google::longrunning::Operation>>
GoldenThingAdminMetadata::AsyncUpdateDatabaseDdl(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    Options const& options,
    google::test::admin::database::v1::UpdateDatabaseDdlRequest const& request) {
  SetMetadata(*context, options, absl::StrCat("database=", internal::UrlEncode(request.database())));
  return child_->AsyncUpdateDatabaseDdl(cq, std::move(context), options, request);
}

Status
GoldenThingAdminMetadata::DropDatabase(
    grpc::ClientContext& context,
    google::test::admin::database::v1::DropDatabaseRequest const& request) {
  std::vector<std::string> params;
  params.reserve(3);

  static auto* project_matcher = []{
    return new google::cloud::internal::RoutingMatcher<google::test::admin::database::v1::DropDatabaseRequest>{
      "project=", {
      {[](google::test::admin::database::v1::DropDatabaseRequest const& request) -> std::string const& {
        return request.database();
      },
      std::regex{"(projects/[^/]+)/instances/[^/]+/databases/[^/]+", std::regex::optimize}},
      }};
  }();
  project_matcher->AppendParam(request, params);

  static auto* instance_matcher = []{
    return new google::cloud::internal::RoutingMatcher<google::test::admin::database::v1::DropDatabaseRequest>{
      "instance=", {
      {[](google::test::admin::database::v1::DropDatabaseRequest const& request) -> std::string const& {
        return request.database();
      },
      std::regex{"projects/[^/]+/(instances/[^/]+)/databases/[^/]+", std::regex::optimize}},
      }};
  }();
  instance_matcher->AppendParam(request, params);

  static auto* database_matcher = []{
    return new google::cloud::internal::RoutingMatcher<google::test::admin::database::v1::DropDatabaseRequest>{
      "database=", {
      {[](google::test::admin::database::v1::DropDatabaseRequest const& request) -> std::string const& {
        return request.database();
      },
      std::regex{"projects/[^/]+/instances/[^/]+/(databases/[^/]+)", std::regex::optimize}},
      }};
  }();
  database_matcher->AppendParam(request, params);

  if (params.empty()) {
    SetMetadata(context, internal::CurrentOptions());
  } else {
    SetMetadata(context, internal::CurrentOptions(), absl::StrJoin(params, "&"));
  }
  return child_->DropDatabase(context, request);
}

StatusOr<google::test::admin::database::v1::GetDatabaseDdlResponse>
GoldenThingAdminMetadata::GetDatabaseDdl(
    grpc::ClientContext& context,
    google::test::admin::database::v1::GetDatabaseDdlRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(), absl::StrCat("database=", internal::UrlEncode(request.database())));
  return child_->GetDatabaseDdl(context, request);
}

StatusOr<google::iam::v1::Policy>
GoldenThingAdminMetadata::SetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::SetIamPolicyRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(), absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->SetIamPolicy(context, request);
}

StatusOr<google::iam::v1::Policy>
GoldenThingAdminMetadata::GetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::GetIamPolicyRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(), absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->GetIamPolicy(context, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
GoldenThingAdminMetadata::TestIamPermissions(
    grpc::ClientContext& context,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(), absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->TestIamPermissions(context, request);
}

future<StatusOr<google::longrunning::Operation>>
GoldenThingAdminMetadata::AsyncCreateBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    Options const& options,
    google::test::admin::database::v1::CreateBackupRequest const& request) {
  SetMetadata(*context, options, absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateBackup(cq, std::move(context), options, request);
}

StatusOr<google::test::admin::database::v1::Backup>
GoldenThingAdminMetadata::GetBackup(
    grpc::ClientContext& context,
    google::test::admin::database::v1::GetBackupRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(), absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetBackup(context, request);
}

StatusOr<google::test::admin::database::v1::Backup>
GoldenThingAdminMetadata::UpdateBackup(
    grpc::ClientContext& context,
    google::test::admin::database::v1::UpdateBackupRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(), absl::StrCat("backup.name=", internal::UrlEncode(request.backup().name())));
  return child_->UpdateBackup(context, request);
}

Status
GoldenThingAdminMetadata::DeleteBackup(
    grpc::ClientContext& context,
    google::test::admin::database::v1::DeleteBackupRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(), absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteBackup(context, request);
}

StatusOr<google::test::admin::database::v1::ListBackupsResponse>
GoldenThingAdminMetadata::ListBackups(
    grpc::ClientContext& context,
    google::test::admin::database::v1::ListBackupsRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(), absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListBackups(context, request);
}

future<StatusOr<google::longrunning::Operation>>
GoldenThingAdminMetadata::AsyncRestoreDatabase(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    Options const& options,
    google::test::admin::database::v1::RestoreDatabaseRequest const& request) {
  SetMetadata(*context, options, absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncRestoreDatabase(cq, std::move(context), options, request);
}

StatusOr<google::test::admin::database::v1::ListDatabaseOperationsResponse>
GoldenThingAdminMetadata::ListDatabaseOperations(
    grpc::ClientContext& context,
    google::test::admin::database::v1::ListDatabaseOperationsRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(), absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListDatabaseOperations(context, request);
}

StatusOr<google::test::admin::database::v1::ListBackupOperationsResponse>
GoldenThingAdminMetadata::ListBackupOperations(
    grpc::ClientContext& context,
    google::test::admin::database::v1::ListBackupOperationsRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(), absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListBackupOperations(context, request);
}

future<StatusOr<google::longrunning::Operation>>
GoldenThingAdminMetadata::AsyncLongRunningWithoutRouting(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    Options const& options,
    google::test::admin::database::v1::RestoreDatabaseRequest const& request) {
  SetMetadata(*context, options);
  return child_->AsyncLongRunningWithoutRouting(cq, std::move(context), options, request);
}

future<StatusOr<google::test::admin::database::v1::Database>>
GoldenThingAdminMetadata::AsyncGetDatabase(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::test::admin::database::v1::GetDatabaseRequest const& request) {
  SetMetadata(*context, internal::CurrentOptions(), absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetDatabase(cq, std::move(context), request);
}

future<Status>
GoldenThingAdminMetadata::AsyncDropDatabase(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::test::admin::database::v1::DropDatabaseRequest const& request) {
  std::vector<std::string> params;
  params.reserve(3);

  static auto* project_matcher = []{
    return new google::cloud::internal::RoutingMatcher<google::test::admin::database::v1::DropDatabaseRequest>{
      "project=", {
      {[](google::test::admin::database::v1::DropDatabaseRequest const& request) -> std::string const& {
        return request.database();
      },
      std::regex{"(projects/[^/]+)/instances/[^/]+/databases/[^/]+", std::regex::optimize}},
      }};
  }();
  project_matcher->AppendParam(request, params);

  static auto* instance_matcher = []{
    return new google::cloud::internal::RoutingMatcher<google::test::admin::database::v1::DropDatabaseRequest>{
      "instance=", {
      {[](google::test::admin::database::v1::DropDatabaseRequest const& request) -> std::string const& {
        return request.database();
      },
      std::regex{"projects/[^/]+/(instances/[^/]+)/databases/[^/]+", std::regex::optimize}},
      }};
  }();
  instance_matcher->AppendParam(request, params);

  static auto* database_matcher = []{
    return new google::cloud::internal::RoutingMatcher<google::test::admin::database::v1::DropDatabaseRequest>{
      "database=", {
      {[](google::test::admin::database::v1::DropDatabaseRequest const& request) -> std::string const& {
        return request.database();
      },
      std::regex{"projects/[^/]+/instances/[^/]+/(databases/[^/]+)", std::regex::optimize}},
      }};
  }();
  database_matcher->AppendParam(request, params);

  if (params.empty()) {
    SetMetadata(*context, internal::CurrentOptions());
  } else {
    SetMetadata(*context, internal::CurrentOptions(), absl::StrJoin(params, "&"));
  }
  return child_->AsyncDropDatabase(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
GoldenThingAdminMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), options, request);
}

future<Status> GoldenThingAdminMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
   SetMetadata(*context, options,
               absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context), options, request);
}

void GoldenThingAdminMetadata::SetMetadata(grpc::ClientContext& context,
                                        Options const& options,
                                        std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void GoldenThingAdminMetadata::SetMetadata(grpc::ClientContext& context,
                                        Options const& options) {
  for (auto const& kv : fixed_metadata_) {
    context.AddMetadata(kv.first, kv.second);
  }
  context.AddMetadata("x-goog-api-client", api_client_header_);
  if (options.has<UserProjectOption>()) {
    context.AddMetadata(
        "x-goog-user-project", options.get<UserProjectOption>());
  }
  auto const& authority = options.get<AuthorityOption>();
  if (!authority.empty()) context.set_authority(authority);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1_internal
}  // namespace cloud
}  // namespace google
