// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/biglake/v1/metastore.proto

#include "google/cloud/bigquery/biglake/v1/metastore_connection.h"
#include "google/cloud/bigquery/biglake/v1/internal/metastore_connection_impl.h"
#include "google/cloud/bigquery/biglake/v1/internal/metastore_option_defaults.h"
#include "google/cloud/bigquery/biglake/v1/internal/metastore_stub_factory.h"
#include "google/cloud/bigquery/biglake/v1/internal/metastore_tracing_connection.h"
#include "google/cloud/bigquery/biglake/v1/metastore_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_biglake_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MetastoreServiceConnection::~MetastoreServiceConnection() = default;

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceConnection::CreateCatalog(
    google::cloud::bigquery::biglake::v1::CreateCatalogRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceConnection::DeleteCatalog(
    google::cloud::bigquery::biglake::v1::DeleteCatalogRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceConnection::GetCatalog(
    google::cloud::bigquery::biglake::v1::GetCatalogRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceConnection::ListCatalogs(
    google::cloud::bigquery::biglake::v1::
        ListCatalogsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::bigquery::biglake::v1::Catalog>>();
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceConnection::CreateDatabase(
    google::cloud::bigquery::biglake::v1::CreateDatabaseRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceConnection::DeleteDatabase(
    google::cloud::bigquery::biglake::v1::DeleteDatabaseRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceConnection::UpdateDatabase(
    google::cloud::bigquery::biglake::v1::UpdateDatabaseRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceConnection::GetDatabase(
    google::cloud::bigquery::biglake::v1::GetDatabaseRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceConnection::ListDatabases(
    google::cloud::bigquery::biglake::v1::
        ListDatabasesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::bigquery::biglake::v1::Database>>();
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceConnection::CreateTable(
    google::cloud::bigquery::biglake::v1::CreateTableRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceConnection::DeleteTable(
    google::cloud::bigquery::biglake::v1::DeleteTableRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceConnection::UpdateTable(
    google::cloud::bigquery::biglake::v1::UpdateTableRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceConnection::RenameTable(
    google::cloud::bigquery::biglake::v1::RenameTableRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceConnection::GetTable(
    google::cloud::bigquery::biglake::v1::GetTableRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceConnection::ListTables(
    google::cloud::bigquery::biglake::v1::
        ListTablesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::bigquery::biglake::v1::Table>>();
}

std::shared_ptr<MetastoreServiceConnection> MakeMetastoreServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 MetastoreServicePolicyOptionList>(options,
                                                                   __func__);
  options = bigquery_biglake_v1_internal::MetastoreServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = bigquery_biglake_v1_internal::CreateDefaultMetastoreServiceStub(
      background->cq(), options);
  return bigquery_biglake_v1_internal::MakeMetastoreServiceTracingConnection(
      std::make_shared<
          bigquery_biglake_v1_internal::MetastoreServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_biglake_v1
}  // namespace cloud
}  // namespace google
