// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/reservation/v1/reservation.proto

#include "google/cloud/bigquery/reservation/v1/internal/reservation_connection_impl.h"
#include "google/cloud/bigquery/reservation/v1/internal/reservation_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_reservation_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<bigquery_reservation_v1::ReservationServiceRetryPolicy>
retry_policy(Options const& options) {
  return options
      .get<bigquery_reservation_v1::ReservationServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<bigquery_reservation_v1::ReservationServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    bigquery_reservation_v1::ReservationServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<bigquery_reservation_v1::
               ReservationServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

ReservationServiceConnectionImpl::ReservationServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<bigquery_reservation_v1_internal::ReservationServiceStub>
        stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), ReservationServiceConnection::options())) {}

StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
ReservationServiceConnectionImpl::CreateReservation(
    google::cloud::bigquery::reservation::v1::CreateReservationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateReservation(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::reservation::v1::
                 CreateReservationRequest const& request) {
        return stub_->CreateReservation(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::bigquery::reservation::v1::Reservation>
ReservationServiceConnectionImpl::ListReservations(
    google::cloud::bigquery::reservation::v1::ListReservationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListReservations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::bigquery::reservation::v1::Reservation>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           bigquery_reservation_v1::ReservationServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::bigquery::reservation::v1::
              ListReservationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::bigquery::reservation::v1::
                       ListReservationsRequest const& request) {
              return stub->ListReservations(context, request);
            },
            r, function_name);
      },
      [](google::cloud::bigquery::reservation::v1::ListReservationsResponse r) {
        std::vector<google::cloud::bigquery::reservation::v1::Reservation>
            result(r.reservations().size());
        auto& messages = *r.mutable_reservations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
ReservationServiceConnectionImpl::GetReservation(
    google::cloud::bigquery::reservation::v1::GetReservationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetReservation(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::bigquery::reservation::v1::GetReservationRequest const&
              request) { return stub_->GetReservation(context, request); },
      request, __func__);
}

Status ReservationServiceConnectionImpl::DeleteReservation(
    google::cloud::bigquery::reservation::v1::DeleteReservationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteReservation(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::reservation::v1::
                 DeleteReservationRequest const& request) {
        return stub_->DeleteReservation(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
ReservationServiceConnectionImpl::UpdateReservation(
    google::cloud::bigquery::reservation::v1::UpdateReservationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateReservation(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::reservation::v1::
                 UpdateReservationRequest const& request) {
        return stub_->UpdateReservation(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceConnectionImpl::CreateCapacityCommitment(
    google::cloud::bigquery::reservation::v1::
        CreateCapacityCommitmentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateCapacityCommitment(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::reservation::v1::
                 CreateCapacityCommitmentRequest const& request) {
        return stub_->CreateCapacityCommitment(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceConnectionImpl::ListCapacityCommitments(
    google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListCapacityCommitments(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<
      google::cloud::bigquery::reservation::v1::CapacityCommitment>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           bigquery_reservation_v1::ReservationServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::bigquery::reservation::v1::
              ListCapacityCommitmentsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::bigquery::reservation::v1::
                       ListCapacityCommitmentsRequest const& request) {
              return stub->ListCapacityCommitments(context, request);
            },
            r, function_name);
      },
      [](google::cloud::bigquery::reservation::v1::
             ListCapacityCommitmentsResponse r) {
        std::vector<
            google::cloud::bigquery::reservation::v1::CapacityCommitment>
            result(r.capacity_commitments().size());
        auto& messages = *r.mutable_capacity_commitments();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceConnectionImpl::GetCapacityCommitment(
    google::cloud::bigquery::reservation::v1::
        GetCapacityCommitmentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetCapacityCommitment(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::reservation::v1::
                 GetCapacityCommitmentRequest const& request) {
        return stub_->GetCapacityCommitment(context, request);
      },
      request, __func__);
}

Status ReservationServiceConnectionImpl::DeleteCapacityCommitment(
    google::cloud::bigquery::reservation::v1::
        DeleteCapacityCommitmentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteCapacityCommitment(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::reservation::v1::
                 DeleteCapacityCommitmentRequest const& request) {
        return stub_->DeleteCapacityCommitment(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceConnectionImpl::UpdateCapacityCommitment(
    google::cloud::bigquery::reservation::v1::
        UpdateCapacityCommitmentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateCapacityCommitment(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::reservation::v1::
                 UpdateCapacityCommitmentRequest const& request) {
        return stub_->UpdateCapacityCommitment(context, request);
      },
      request, __func__);
}

StatusOr<
    google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>
ReservationServiceConnectionImpl::SplitCapacityCommitment(
    google::cloud::bigquery::reservation::v1::
        SplitCapacityCommitmentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SplitCapacityCommitment(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::reservation::v1::
                 SplitCapacityCommitmentRequest const& request) {
        return stub_->SplitCapacityCommitment(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceConnectionImpl::MergeCapacityCommitments(
    google::cloud::bigquery::reservation::v1::
        MergeCapacityCommitmentsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->MergeCapacityCommitments(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::reservation::v1::
                 MergeCapacityCommitmentsRequest const& request) {
        return stub_->MergeCapacityCommitments(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceConnectionImpl::CreateAssignment(
    google::cloud::bigquery::reservation::v1::CreateAssignmentRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateAssignment(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::reservation::v1::
                 CreateAssignmentRequest const& request) {
        return stub_->CreateAssignment(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceConnectionImpl::ListAssignments(
    google::cloud::bigquery::reservation::v1::ListAssignmentsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListAssignments(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::bigquery::reservation::v1::Assignment>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           bigquery_reservation_v1::ReservationServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::bigquery::reservation::v1::
              ListAssignmentsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::bigquery::reservation::v1::
                       ListAssignmentsRequest const& request) {
              return stub->ListAssignments(context, request);
            },
            r, function_name);
      },
      [](google::cloud::bigquery::reservation::v1::ListAssignmentsResponse r) {
        std::vector<google::cloud::bigquery::reservation::v1::Assignment>
            result(r.assignments().size());
        auto& messages = *r.mutable_assignments();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status ReservationServiceConnectionImpl::DeleteAssignment(
    google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteAssignment(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::reservation::v1::
                 DeleteAssignmentRequest const& request) {
        return stub_->DeleteAssignment(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceConnectionImpl::SearchAssignments(
    google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->SearchAssignments(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::bigquery::reservation::v1::Assignment>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           bigquery_reservation_v1::ReservationServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::bigquery::reservation::v1::
              SearchAssignmentsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::bigquery::reservation::v1::
                       SearchAssignmentsRequest const& request) {
              return stub->SearchAssignments(context, request);
            },
            r, function_name);
      },
      [](google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse
             r) {
        std::vector<google::cloud::bigquery::reservation::v1::Assignment>
            result(r.assignments().size());
        auto& messages = *r.mutable_assignments();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceConnectionImpl::SearchAllAssignments(
    google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->SearchAllAssignments(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::bigquery::reservation::v1::Assignment>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           bigquery_reservation_v1::ReservationServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::bigquery::reservation::v1::
              SearchAllAssignmentsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::bigquery::reservation::v1::
                       SearchAllAssignmentsRequest const& request) {
              return stub->SearchAllAssignments(context, request);
            },
            r, function_name);
      },
      [](google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse
             r) {
        std::vector<google::cloud::bigquery::reservation::v1::Assignment>
            result(r.assignments().size());
        auto& messages = *r.mutable_assignments();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceConnectionImpl::MoveAssignment(
    google::cloud::bigquery::reservation::v1::MoveAssignmentRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->MoveAssignment(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::bigquery::reservation::v1::MoveAssignmentRequest const&
              request) { return stub_->MoveAssignment(context, request); },
      request, __func__);
}

StatusOr<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceConnectionImpl::UpdateAssignment(
    google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateAssignment(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::reservation::v1::
                 UpdateAssignmentRequest const& request) {
        return stub_->UpdateAssignment(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::bigquery::reservation::v1::BiReservation>
ReservationServiceConnectionImpl::GetBiReservation(
    google::cloud::bigquery::reservation::v1::GetBiReservationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetBiReservation(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::reservation::v1::
                 GetBiReservationRequest const& request) {
        return stub_->GetBiReservation(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::bigquery::reservation::v1::BiReservation>
ReservationServiceConnectionImpl::UpdateBiReservation(
    google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateBiReservation(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::reservation::v1::
                 UpdateBiReservationRequest const& request) {
        return stub_->UpdateBiReservation(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_reservation_v1_internal
}  // namespace cloud
}  // namespace google
