// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/certificatemanager/v1/certificate_manager.proto

#include "google/cloud/certificatemanager/v1/internal/certificate_manager_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace certificatemanager_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

CertificateManagerTracingStub::CertificateManagerTracingStub(
    std::shared_ptr<CertificateManagerStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::certificatemanager::v1::ListCertificatesResponse>
CertificateManagerTracingStub::ListCertificates(
    grpc::ClientContext& context,
    google::cloud::certificatemanager::v1::ListCertificatesRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "ListCertificates");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListCertificates(context, request));
}

StatusOr<google::cloud::certificatemanager::v1::Certificate>
CertificateManagerTracingStub::GetCertificate(
    grpc::ClientContext& context,
    google::cloud::certificatemanager::v1::GetCertificateRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "GetCertificate");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetCertificate(context, request));
}

future<StatusOr<google::longrunning::Operation>>
CertificateManagerTracingStub::AsyncCreateCertificate(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::certificatemanager::v1::CreateCertificateRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "CreateCertificate");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateCertificate(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
CertificateManagerTracingStub::AsyncUpdateCertificate(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::certificatemanager::v1::UpdateCertificateRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "UpdateCertificate");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateCertificate(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
CertificateManagerTracingStub::AsyncDeleteCertificate(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::certificatemanager::v1::DeleteCertificateRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "DeleteCertificate");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteCertificate(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::certificatemanager::v1::ListCertificateMapsResponse>
CertificateManagerTracingStub::ListCertificateMaps(
    grpc::ClientContext& context,
    google::cloud::certificatemanager::v1::ListCertificateMapsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "ListCertificateMaps");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListCertificateMaps(context, request));
}

StatusOr<google::cloud::certificatemanager::v1::CertificateMap>
CertificateManagerTracingStub::GetCertificateMap(
    grpc::ClientContext& context,
    google::cloud::certificatemanager::v1::GetCertificateMapRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "GetCertificateMap");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetCertificateMap(context, request));
}

future<StatusOr<google::longrunning::Operation>>
CertificateManagerTracingStub::AsyncCreateCertificateMap(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::certificatemanager::v1::CreateCertificateMapRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "CreateCertificateMap");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateCertificateMap(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
CertificateManagerTracingStub::AsyncUpdateCertificateMap(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::certificatemanager::v1::UpdateCertificateMapRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "UpdateCertificateMap");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateCertificateMap(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
CertificateManagerTracingStub::AsyncDeleteCertificateMap(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::certificatemanager::v1::DeleteCertificateMapRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "DeleteCertificateMap");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteCertificateMap(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<
    google::cloud::certificatemanager::v1::ListCertificateMapEntriesResponse>
CertificateManagerTracingStub::ListCertificateMapEntries(
    grpc::ClientContext& context,
    google::cloud::certificatemanager::v1::
        ListCertificateMapEntriesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "ListCertificateMapEntries");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListCertificateMapEntries(context, request));
}

StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>
CertificateManagerTracingStub::GetCertificateMapEntry(
    grpc::ClientContext& context,
    google::cloud::certificatemanager::v1::GetCertificateMapEntryRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "GetCertificateMapEntry");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetCertificateMapEntry(context, request));
}

future<StatusOr<google::longrunning::Operation>>
CertificateManagerTracingStub::AsyncCreateCertificateMapEntry(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::certificatemanager::v1::
        CreateCertificateMapEntryRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "CreateCertificateMapEntry");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateCertificateMapEntry(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
CertificateManagerTracingStub::AsyncUpdateCertificateMapEntry(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::certificatemanager::v1::
        UpdateCertificateMapEntryRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "UpdateCertificateMapEntry");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateCertificateMapEntry(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
CertificateManagerTracingStub::AsyncDeleteCertificateMapEntry(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::certificatemanager::v1::
        DeleteCertificateMapEntryRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "DeleteCertificateMapEntry");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteCertificateMapEntry(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::certificatemanager::v1::ListDnsAuthorizationsResponse>
CertificateManagerTracingStub::ListDnsAuthorizations(
    grpc::ClientContext& context,
    google::cloud::certificatemanager::v1::ListDnsAuthorizationsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "ListDnsAuthorizations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListDnsAuthorizations(context, request));
}

StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>
CertificateManagerTracingStub::GetDnsAuthorization(
    grpc::ClientContext& context,
    google::cloud::certificatemanager::v1::GetDnsAuthorizationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "GetDnsAuthorization");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetDnsAuthorization(context, request));
}

future<StatusOr<google::longrunning::Operation>>
CertificateManagerTracingStub::AsyncCreateDnsAuthorization(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::certificatemanager::v1::CreateDnsAuthorizationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "CreateDnsAuthorization");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateDnsAuthorization(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
CertificateManagerTracingStub::AsyncUpdateDnsAuthorization(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::certificatemanager::v1::UpdateDnsAuthorizationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "UpdateDnsAuthorization");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateDnsAuthorization(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
CertificateManagerTracingStub::AsyncDeleteDnsAuthorization(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::certificatemanager::v1::DeleteDnsAuthorizationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "DeleteDnsAuthorization");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteDnsAuthorization(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::certificatemanager::v1::
             ListCertificateIssuanceConfigsResponse>
CertificateManagerTracingStub::ListCertificateIssuanceConfigs(
    grpc::ClientContext& context,
    google::cloud::certificatemanager::v1::
        ListCertificateIssuanceConfigsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "ListCertificateIssuanceConfigs");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListCertificateIssuanceConfigs(context, request));
}

StatusOr<google::cloud::certificatemanager::v1::CertificateIssuanceConfig>
CertificateManagerTracingStub::GetCertificateIssuanceConfig(
    grpc::ClientContext& context,
    google::cloud::certificatemanager::v1::
        GetCertificateIssuanceConfigRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "GetCertificateIssuanceConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetCertificateIssuanceConfig(context, request));
}

future<StatusOr<google::longrunning::Operation>>
CertificateManagerTracingStub::AsyncCreateCertificateIssuanceConfig(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::certificatemanager::v1::
        CreateCertificateIssuanceConfigRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "CreateCertificateIssuanceConfig");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateCertificateIssuanceConfig(cq, context, options,
                                                        request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
CertificateManagerTracingStub::AsyncDeleteCertificateIssuanceConfig(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::certificatemanager::v1::
        DeleteCertificateIssuanceConfigRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.certificatemanager.v1.CertificateManager",
      "DeleteCertificateIssuanceConfig");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteCertificateIssuanceConfig(cq, context, options,
                                                        request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
CertificateManagerTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> CertificateManagerTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCancelOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<CertificateManagerStub> MakeCertificateManagerTracingStub(
    std::shared_ptr<CertificateManagerStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<CertificateManagerTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace certificatemanager_v1_internal
}  // namespace cloud
}  // namespace google
