// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/instance_group_managers/v1/instance_group_managers.proto

#include "google/cloud/compute/instance_group_managers/v1/instance_group_managers_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_instance_group_managers_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

InstanceGroupManagersConnectionIdempotencyPolicy::
    ~InstanceGroupManagersConnectionIdempotencyPolicy() = default;

std::unique_ptr<InstanceGroupManagersConnectionIdempotencyPolicy>
InstanceGroupManagersConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<InstanceGroupManagersConnectionIdempotencyPolicy>(
      *this);
}

Idempotency InstanceGroupManagersConnectionIdempotencyPolicy::AbandonInstances(
    google::cloud::cpp::compute::instance_group_managers::v1::
        AbandonInstancesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency InstanceGroupManagersConnectionIdempotencyPolicy::
    AggregatedListInstanceGroupManagers(
        google::cloud::cpp::compute::instance_group_managers::v1::
            AggregatedListInstanceGroupManagersRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
InstanceGroupManagersConnectionIdempotencyPolicy::ApplyUpdatesToInstances(
    google::cloud::cpp::compute::instance_group_managers::v1::
        ApplyUpdatesToInstancesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency InstanceGroupManagersConnectionIdempotencyPolicy::CreateInstances(
    google::cloud::cpp::compute::instance_group_managers::v1::
        CreateInstancesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
InstanceGroupManagersConnectionIdempotencyPolicy::DeleteInstanceGroupManager(
    google::cloud::cpp::compute::instance_group_managers::v1::
        DeleteInstanceGroupManagerRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency InstanceGroupManagersConnectionIdempotencyPolicy::DeleteInstances(
    google::cloud::cpp::compute::instance_group_managers::v1::
        DeleteInstancesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
InstanceGroupManagersConnectionIdempotencyPolicy::DeletePerInstanceConfigs(
    google::cloud::cpp::compute::instance_group_managers::v1::
        DeletePerInstanceConfigsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
InstanceGroupManagersConnectionIdempotencyPolicy::GetInstanceGroupManager(
    google::cloud::cpp::compute::instance_group_managers::v1::
        GetInstanceGroupManagerRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
InstanceGroupManagersConnectionIdempotencyPolicy::InsertInstanceGroupManager(
    google::cloud::cpp::compute::instance_group_managers::v1::
        InsertInstanceGroupManagerRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
InstanceGroupManagersConnectionIdempotencyPolicy::ListInstanceGroupManagers(
    google::cloud::cpp::compute::instance_group_managers::v1::
        ListInstanceGroupManagersRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency InstanceGroupManagersConnectionIdempotencyPolicy::ListErrors(
    google::cloud::cpp::compute::instance_group_managers::v1::
        ListErrorsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
InstanceGroupManagersConnectionIdempotencyPolicy::ListManagedInstances(
    google::cloud::cpp::compute::instance_group_managers::v1::
        ListManagedInstancesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
InstanceGroupManagersConnectionIdempotencyPolicy::ListPerInstanceConfigs(
    google::cloud::cpp::compute::instance_group_managers::v1::
        ListPerInstanceConfigsRequest) {  // NOLINT
  return Idempotency::kNonIdempotent;
}

Idempotency
InstanceGroupManagersConnectionIdempotencyPolicy::PatchInstanceGroupManager(
    google::cloud::cpp::compute::instance_group_managers::v1::
        PatchInstanceGroupManagerRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
InstanceGroupManagersConnectionIdempotencyPolicy::PatchPerInstanceConfigs(
    google::cloud::cpp::compute::instance_group_managers::v1::
        PatchPerInstanceConfigsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency InstanceGroupManagersConnectionIdempotencyPolicy::RecreateInstances(
    google::cloud::cpp::compute::instance_group_managers::v1::
        RecreateInstancesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency InstanceGroupManagersConnectionIdempotencyPolicy::Resize(
    google::cloud::cpp::compute::instance_group_managers::v1::
        ResizeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
InstanceGroupManagersConnectionIdempotencyPolicy::SetInstanceTemplate(
    google::cloud::cpp::compute::instance_group_managers::v1::
        SetInstanceTemplateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency InstanceGroupManagersConnectionIdempotencyPolicy::SetTargetPools(
    google::cloud::cpp::compute::instance_group_managers::v1::
        SetTargetPoolsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
InstanceGroupManagersConnectionIdempotencyPolicy::UpdatePerInstanceConfigs(
    google::cloud::cpp::compute::instance_group_managers::v1::
        UpdatePerInstanceConfigsRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<InstanceGroupManagersConnectionIdempotencyPolicy>
MakeDefaultInstanceGroupManagersConnectionIdempotencyPolicy() {
  return std::make_unique<InstanceGroupManagersConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_instance_group_managers_v1
}  // namespace cloud
}  // namespace google
