// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/vpn_gateways/v1/vpn_gateways.proto

#include "google/cloud/compute/vpn_gateways/v1/vpn_gateways_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_vpn_gateways_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

VpnGatewaysClient::VpnGatewaysClient(
    std::shared_ptr<VpnGatewaysConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
VpnGatewaysClient::~VpnGatewaysClient() = default;

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::VpnGatewaysScopedList>>
VpnGatewaysClient::AggregatedListVpnGateways(std::string const& project,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::vpn_gateways::v1::
      AggregatedListVpnGatewaysRequest request;
  request.set_project(project);
  return connection_->AggregatedListVpnGateways(request);
}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::VpnGatewaysScopedList>>
VpnGatewaysClient::AggregatedListVpnGateways(
    google::cloud::cpp::compute::vpn_gateways::v1::
        AggregatedListVpnGatewaysRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListVpnGateways(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
VpnGatewaysClient::DeleteVpnGateway(std::string const& project,
                                    std::string const& region,
                                    std::string const& vpn_gateway,
                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::vpn_gateways::v1::DeleteVpnGatewayRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_vpn_gateway(vpn_gateway);
  return connection_->DeleteVpnGateway(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
VpnGatewaysClient::DeleteVpnGateway(
    google::cloud::cpp::compute::vpn_gateways::v1::
        DeleteVpnGatewayRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteVpnGateway(request);
}

StatusOr<google::cloud::cpp::compute::v1::VpnGateway>
VpnGatewaysClient::GetVpnGateway(std::string const& project,
                                 std::string const& region,
                                 std::string const& vpn_gateway, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::vpn_gateways::v1::GetVpnGatewayRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_vpn_gateway(vpn_gateway);
  return connection_->GetVpnGateway(request);
}

StatusOr<google::cloud::cpp::compute::v1::VpnGateway>
VpnGatewaysClient::GetVpnGateway(
    google::cloud::cpp::compute::vpn_gateways::v1::GetVpnGatewayRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetVpnGateway(request);
}

StatusOr<google::cloud::cpp::compute::v1::VpnGatewaysGetStatusResponse>
VpnGatewaysClient::GetStatus(std::string const& project,
                             std::string const& region,
                             std::string const& vpn_gateway, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::vpn_gateways::v1::GetStatusRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_vpn_gateway(vpn_gateway);
  return connection_->GetStatus(request);
}

StatusOr<google::cloud::cpp::compute::v1::VpnGatewaysGetStatusResponse>
VpnGatewaysClient::GetStatus(
    google::cloud::cpp::compute::vpn_gateways::v1::GetStatusRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetStatus(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
VpnGatewaysClient::InsertVpnGateway(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::VpnGateway const& vpn_gateway_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::vpn_gateways::v1::InsertVpnGatewayRequest
      request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_vpn_gateway_resource() = vpn_gateway_resource;
  return connection_->InsertVpnGateway(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
VpnGatewaysClient::InsertVpnGateway(
    google::cloud::cpp::compute::vpn_gateways::v1::
        InsertVpnGatewayRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertVpnGateway(request);
}

StreamRange<google::cloud::cpp::compute::v1::VpnGateway>
VpnGatewaysClient::ListVpnGateways(std::string const& project,
                                   std::string const& region, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::vpn_gateways::v1::ListVpnGatewaysRequest request;
  request.set_project(project);
  request.set_region(region);
  return connection_->ListVpnGateways(request);
}

StreamRange<google::cloud::cpp::compute::v1::VpnGateway>
VpnGatewaysClient::ListVpnGateways(
    google::cloud::cpp::compute::vpn_gateways::v1::ListVpnGatewaysRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListVpnGateways(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
VpnGatewaysClient::SetLabels(
    std::string const& project, std::string const& region,
    std::string const& resource,
    google::cloud::cpp::compute::v1::RegionSetLabelsRequest const&
        region_set_labels_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::vpn_gateways::v1::SetLabelsRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  *request.mutable_region_set_labels_request_resource() =
      region_set_labels_request_resource;
  return connection_->SetLabels(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
VpnGatewaysClient::SetLabels(
    google::cloud::cpp::compute::vpn_gateways::v1::SetLabelsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetLabels(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
VpnGatewaysClient::TestIamPermissions(
    std::string const& project, std::string const& region,
    std::string const& resource,
    google::cloud::cpp::compute::v1::TestPermissionsRequest const&
        test_permissions_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::vpn_gateways::v1::TestIamPermissionsRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  *request.mutable_test_permissions_request_resource() =
      test_permissions_request_resource;
  return connection_->TestIamPermissions(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
VpnGatewaysClient::TestIamPermissions(
    google::cloud::cpp::compute::vpn_gateways::v1::
        TestIamPermissionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_vpn_gateways_v1
}  // namespace cloud
}  // namespace google
