// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/privacy/dlp/v2/dlp.proto

#include "google/cloud/dlp/v2/internal/dlp_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace dlp_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DlpServiceTracingConnection::DlpServiceTracingConnection(
    std::shared_ptr<dlp_v2::DlpServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::privacy::dlp::v2::InspectContentResponse>
DlpServiceTracingConnection::InspectContent(
    google::privacy::dlp::v2::InspectContentRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::InspectContent");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->InspectContent(request));
}

StatusOr<google::privacy::dlp::v2::RedactImageResponse>
DlpServiceTracingConnection::RedactImage(
    google::privacy::dlp::v2::RedactImageRequest const& request) {
  auto span = internal::MakeSpan("dlp_v2::DlpServiceConnection::RedactImage");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->RedactImage(request));
}

StatusOr<google::privacy::dlp::v2::DeidentifyContentResponse>
DlpServiceTracingConnection::DeidentifyContent(
    google::privacy::dlp::v2::DeidentifyContentRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::DeidentifyContent");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeidentifyContent(request));
}

StatusOr<google::privacy::dlp::v2::ReidentifyContentResponse>
DlpServiceTracingConnection::ReidentifyContent(
    google::privacy::dlp::v2::ReidentifyContentRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::ReidentifyContent");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ReidentifyContent(request));
}

StatusOr<google::privacy::dlp::v2::ListInfoTypesResponse>
DlpServiceTracingConnection::ListInfoTypes(
    google::privacy::dlp::v2::ListInfoTypesRequest const& request) {
  auto span = internal::MakeSpan("dlp_v2::DlpServiceConnection::ListInfoTypes");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ListInfoTypes(request));
}

StatusOr<google::privacy::dlp::v2::InspectTemplate>
DlpServiceTracingConnection::CreateInspectTemplate(
    google::privacy::dlp::v2::CreateInspectTemplateRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::CreateInspectTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateInspectTemplate(request));
}

StatusOr<google::privacy::dlp::v2::InspectTemplate>
DlpServiceTracingConnection::UpdateInspectTemplate(
    google::privacy::dlp::v2::UpdateInspectTemplateRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::UpdateInspectTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateInspectTemplate(request));
}

StatusOr<google::privacy::dlp::v2::InspectTemplate>
DlpServiceTracingConnection::GetInspectTemplate(
    google::privacy::dlp::v2::GetInspectTemplateRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::GetInspectTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetInspectTemplate(request));
}

StreamRange<google::privacy::dlp::v2::InspectTemplate>
DlpServiceTracingConnection::ListInspectTemplates(
    google::privacy::dlp::v2::ListInspectTemplatesRequest request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::ListInspectTemplates");
  internal::OTelScope scope(span);
  auto sr = child_->ListInspectTemplates(std::move(request));
  return internal::MakeTracedStreamRange<
      google::privacy::dlp::v2::InspectTemplate>(std::move(span),
                                                 std::move(sr));
}

Status DlpServiceTracingConnection::DeleteInspectTemplate(
    google::privacy::dlp::v2::DeleteInspectTemplateRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::DeleteInspectTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteInspectTemplate(request));
}

StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceTracingConnection::CreateDeidentifyTemplate(
    google::privacy::dlp::v2::CreateDeidentifyTemplateRequest const& request) {
  auto span = internal::MakeSpan(
      "dlp_v2::DlpServiceConnection::CreateDeidentifyTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateDeidentifyTemplate(request));
}

StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceTracingConnection::UpdateDeidentifyTemplate(
    google::privacy::dlp::v2::UpdateDeidentifyTemplateRequest const& request) {
  auto span = internal::MakeSpan(
      "dlp_v2::DlpServiceConnection::UpdateDeidentifyTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateDeidentifyTemplate(request));
}

StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceTracingConnection::GetDeidentifyTemplate(
    google::privacy::dlp::v2::GetDeidentifyTemplateRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::GetDeidentifyTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDeidentifyTemplate(request));
}

StreamRange<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceTracingConnection::ListDeidentifyTemplates(
    google::privacy::dlp::v2::ListDeidentifyTemplatesRequest request) {
  auto span = internal::MakeSpan(
      "dlp_v2::DlpServiceConnection::ListDeidentifyTemplates");
  internal::OTelScope scope(span);
  auto sr = child_->ListDeidentifyTemplates(std::move(request));
  return internal::MakeTracedStreamRange<
      google::privacy::dlp::v2::DeidentifyTemplate>(std::move(span),
                                                    std::move(sr));
}

Status DlpServiceTracingConnection::DeleteDeidentifyTemplate(
    google::privacy::dlp::v2::DeleteDeidentifyTemplateRequest const& request) {
  auto span = internal::MakeSpan(
      "dlp_v2::DlpServiceConnection::DeleteDeidentifyTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteDeidentifyTemplate(request));
}

StatusOr<google::privacy::dlp::v2::JobTrigger>
DlpServiceTracingConnection::CreateJobTrigger(
    google::privacy::dlp::v2::CreateJobTriggerRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::CreateJobTrigger");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateJobTrigger(request));
}

StatusOr<google::privacy::dlp::v2::JobTrigger>
DlpServiceTracingConnection::UpdateJobTrigger(
    google::privacy::dlp::v2::UpdateJobTriggerRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::UpdateJobTrigger");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateJobTrigger(request));
}

StatusOr<google::privacy::dlp::v2::HybridInspectResponse>
DlpServiceTracingConnection::HybridInspectJobTrigger(
    google::privacy::dlp::v2::HybridInspectJobTriggerRequest const& request) {
  auto span = internal::MakeSpan(
      "dlp_v2::DlpServiceConnection::HybridInspectJobTrigger");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->HybridInspectJobTrigger(request));
}

StatusOr<google::privacy::dlp::v2::JobTrigger>
DlpServiceTracingConnection::GetJobTrigger(
    google::privacy::dlp::v2::GetJobTriggerRequest const& request) {
  auto span = internal::MakeSpan("dlp_v2::DlpServiceConnection::GetJobTrigger");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetJobTrigger(request));
}

StreamRange<google::privacy::dlp::v2::JobTrigger>
DlpServiceTracingConnection::ListJobTriggers(
    google::privacy::dlp::v2::ListJobTriggersRequest request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::ListJobTriggers");
  internal::OTelScope scope(span);
  auto sr = child_->ListJobTriggers(std::move(request));
  return internal::MakeTracedStreamRange<google::privacy::dlp::v2::JobTrigger>(
      std::move(span), std::move(sr));
}

Status DlpServiceTracingConnection::DeleteJobTrigger(
    google::privacy::dlp::v2::DeleteJobTriggerRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::DeleteJobTrigger");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteJobTrigger(request));
}

StatusOr<google::privacy::dlp::v2::DlpJob>
DlpServiceTracingConnection::ActivateJobTrigger(
    google::privacy::dlp::v2::ActivateJobTriggerRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::ActivateJobTrigger");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ActivateJobTrigger(request));
}

StatusOr<google::privacy::dlp::v2::DiscoveryConfig>
DlpServiceTracingConnection::CreateDiscoveryConfig(
    google::privacy::dlp::v2::CreateDiscoveryConfigRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::CreateDiscoveryConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateDiscoveryConfig(request));
}

StatusOr<google::privacy::dlp::v2::DiscoveryConfig>
DlpServiceTracingConnection::UpdateDiscoveryConfig(
    google::privacy::dlp::v2::UpdateDiscoveryConfigRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::UpdateDiscoveryConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateDiscoveryConfig(request));
}

StatusOr<google::privacy::dlp::v2::DiscoveryConfig>
DlpServiceTracingConnection::GetDiscoveryConfig(
    google::privacy::dlp::v2::GetDiscoveryConfigRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::GetDiscoveryConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDiscoveryConfig(request));
}

StreamRange<google::privacy::dlp::v2::DiscoveryConfig>
DlpServiceTracingConnection::ListDiscoveryConfigs(
    google::privacy::dlp::v2::ListDiscoveryConfigsRequest request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::ListDiscoveryConfigs");
  internal::OTelScope scope(span);
  auto sr = child_->ListDiscoveryConfigs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::privacy::dlp::v2::DiscoveryConfig>(std::move(span),
                                                 std::move(sr));
}

Status DlpServiceTracingConnection::DeleteDiscoveryConfig(
    google::privacy::dlp::v2::DeleteDiscoveryConfigRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::DeleteDiscoveryConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteDiscoveryConfig(request));
}

StatusOr<google::privacy::dlp::v2::DlpJob>
DlpServiceTracingConnection::CreateDlpJob(
    google::privacy::dlp::v2::CreateDlpJobRequest const& request) {
  auto span = internal::MakeSpan("dlp_v2::DlpServiceConnection::CreateDlpJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateDlpJob(request));
}

StreamRange<google::privacy::dlp::v2::DlpJob>
DlpServiceTracingConnection::ListDlpJobs(
    google::privacy::dlp::v2::ListDlpJobsRequest request) {
  auto span = internal::MakeSpan("dlp_v2::DlpServiceConnection::ListDlpJobs");
  internal::OTelScope scope(span);
  auto sr = child_->ListDlpJobs(std::move(request));
  return internal::MakeTracedStreamRange<google::privacy::dlp::v2::DlpJob>(
      std::move(span), std::move(sr));
}

StatusOr<google::privacy::dlp::v2::DlpJob>
DlpServiceTracingConnection::GetDlpJob(
    google::privacy::dlp::v2::GetDlpJobRequest const& request) {
  auto span = internal::MakeSpan("dlp_v2::DlpServiceConnection::GetDlpJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDlpJob(request));
}

Status DlpServiceTracingConnection::DeleteDlpJob(
    google::privacy::dlp::v2::DeleteDlpJobRequest const& request) {
  auto span = internal::MakeSpan("dlp_v2::DlpServiceConnection::DeleteDlpJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteDlpJob(request));
}

Status DlpServiceTracingConnection::CancelDlpJob(
    google::privacy::dlp::v2::CancelDlpJobRequest const& request) {
  auto span = internal::MakeSpan("dlp_v2::DlpServiceConnection::CancelDlpJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelDlpJob(request));
}

StatusOr<google::privacy::dlp::v2::StoredInfoType>
DlpServiceTracingConnection::CreateStoredInfoType(
    google::privacy::dlp::v2::CreateStoredInfoTypeRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::CreateStoredInfoType");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateStoredInfoType(request));
}

StatusOr<google::privacy::dlp::v2::StoredInfoType>
DlpServiceTracingConnection::UpdateStoredInfoType(
    google::privacy::dlp::v2::UpdateStoredInfoTypeRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::UpdateStoredInfoType");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateStoredInfoType(request));
}

StatusOr<google::privacy::dlp::v2::StoredInfoType>
DlpServiceTracingConnection::GetStoredInfoType(
    google::privacy::dlp::v2::GetStoredInfoTypeRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::GetStoredInfoType");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetStoredInfoType(request));
}

StreamRange<google::privacy::dlp::v2::StoredInfoType>
DlpServiceTracingConnection::ListStoredInfoTypes(
    google::privacy::dlp::v2::ListStoredInfoTypesRequest request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::ListStoredInfoTypes");
  internal::OTelScope scope(span);
  auto sr = child_->ListStoredInfoTypes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::privacy::dlp::v2::StoredInfoType>(std::move(span), std::move(sr));
}

Status DlpServiceTracingConnection::DeleteStoredInfoType(
    google::privacy::dlp::v2::DeleteStoredInfoTypeRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::DeleteStoredInfoType");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteStoredInfoType(request));
}

StatusOr<google::privacy::dlp::v2::HybridInspectResponse>
DlpServiceTracingConnection::HybridInspectDlpJob(
    google::privacy::dlp::v2::HybridInspectDlpJobRequest const& request) {
  auto span =
      internal::MakeSpan("dlp_v2::DlpServiceConnection::HybridInspectDlpJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->HybridInspectDlpJob(request));
}

Status DlpServiceTracingConnection::FinishDlpJob(
    google::privacy::dlp::v2::FinishDlpJobRequest const& request) {
  auto span = internal::MakeSpan("dlp_v2::DlpServiceConnection::FinishDlpJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->FinishDlpJob(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<dlp_v2::DlpServiceConnection> MakeDlpServiceTracingConnection(
    std::shared_ptr<dlp_v2::DlpServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<DlpServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dlp_v2_internal
}  // namespace cloud
}  // namespace google
