// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkebackup/v1/gkebackup.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEBACKUP_V1_BACKUP_FOR_GKE_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEBACKUP_V1_BACKUP_FOR_GKE_CLIENT_H

#include "google/cloud/gkebackup/v1/backup_for_gke_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace gkebackup_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// BackupForGKE allows Kubernetes administrators to configure, execute, and
/// manage backup and restore operations for their GKE clusters.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class BackupForGKEClient {
 public:
  explicit BackupForGKEClient(
      std::shared_ptr<BackupForGKEConnection> connection, Options opts = {});
  ~BackupForGKEClient();

  ///@{
  /// @name Copy and move support
  BackupForGKEClient(BackupForGKEClient const&) = default;
  BackupForGKEClient& operator=(BackupForGKEClient const&) = default;
  BackupForGKEClient(BackupForGKEClient&&) = default;
  BackupForGKEClient& operator=(BackupForGKEClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(BackupForGKEClient const& a,
                         BackupForGKEClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(BackupForGKEClient const& a,
                         BackupForGKEClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a new BackupPlan in a given location.
  ///
  /// @param parent  Required. The location within which to create the BackupPlan.
  ///  Format: `projects/*/locations/*`
  /// @param backup_plan  Required. The BackupPlan resource object to create.
  /// @param backup_plan_id  Required. The client-provided short name for the BackupPlan resource.
  ///  This name must:
  ///  @n
  ///  - be between 1 and 63 characters long (inclusive)
  ///  - consist of only lower-case ASCII letters, numbers, and dashes
  ///  - start with a lower-case letter
  ///  - end with a lower-case letter or number
  ///  - be unique within the set of BackupPlans in this location
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.BackupPlan] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.BackupPlan]: @googleapis_reference_link{google/cloud/gkebackup/v1/backup_plan.proto#L33}
  /// [google.cloud.gkebackup.v1.CreateBackupPlanRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L350}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::BackupPlan>> CreateBackupPlan(
      std::string const& parent,
      google::cloud::gkebackup::v1::BackupPlan const& backup_plan,
      std::string const& backup_plan_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new BackupPlan in a given location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.CreateBackupPlanRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.BackupPlan] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.BackupPlan]: @googleapis_reference_link{google/cloud/gkebackup/v1/backup_plan.proto#L33}
  /// [google.cloud.gkebackup.v1.CreateBackupPlanRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L350}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::BackupPlan>> CreateBackupPlan(
      google::cloud::gkebackup::v1::CreateBackupPlanRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists BackupPlans in a given location.
  ///
  /// @param parent  Required. The location that contains the BackupPlans to list.
  ///  Format: `projects/*/locations/*`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkebackup.v1.BackupPlan], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.BackupPlan]: @googleapis_reference_link{google/cloud/gkebackup/v1/backup_plan.proto#L33}
  /// [google.cloud.gkebackup.v1.ListBackupPlansRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L375}
  ///
  // clang-format on
  StreamRange<google::cloud::gkebackup::v1::BackupPlan> ListBackupPlans(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists BackupPlans in a given location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.ListBackupPlansRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkebackup.v1.BackupPlan], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.BackupPlan]: @googleapis_reference_link{google/cloud/gkebackup/v1/backup_plan.proto#L33}
  /// [google.cloud.gkebackup.v1.ListBackupPlansRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L375}
  ///
  // clang-format on
  StreamRange<google::cloud::gkebackup::v1::BackupPlan> ListBackupPlans(
      google::cloud::gkebackup::v1::ListBackupPlansRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieve the details of a single BackupPlan.
  ///
  /// @param name  Required. Fully qualified BackupPlan name.
  ///  Format: `projects/*/locations/*/backupPlans/*`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkebackup.v1.BackupPlan])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.BackupPlan]: @googleapis_reference_link{google/cloud/gkebackup/v1/backup_plan.proto#L33}
  /// [google.cloud.gkebackup.v1.GetBackupPlanRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L425}
  ///
  // clang-format on
  StatusOr<google::cloud::gkebackup::v1::BackupPlan> GetBackupPlan(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieve the details of a single BackupPlan.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.GetBackupPlanRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkebackup.v1.BackupPlan])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.BackupPlan]: @googleapis_reference_link{google/cloud/gkebackup/v1/backup_plan.proto#L33}
  /// [google.cloud.gkebackup.v1.GetBackupPlanRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L425}
  ///
  // clang-format on
  StatusOr<google::cloud::gkebackup::v1::BackupPlan> GetBackupPlan(
      google::cloud::gkebackup::v1::GetBackupPlanRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Update a BackupPlan.
  ///
  /// @param backup_plan  Required. A new version of the BackupPlan resource that contains updated
  ///  fields. This may be sparsely populated if an `update_mask` is provided.
  /// @param update_mask  This is used to specify the fields to be overwritten in the
  ///  BackupPlan targeted for update. The values for each of these
  ///  updated fields will be taken from the `backup_plan` provided
  ///  with this request. Field names are relative to the root of the resource
  ///  (e.g., `description`, `backup_config.include_volume_data`, etc.)
  ///  If no `update_mask` is provided, all fields in `backup_plan` will be
  ///  written to the target BackupPlan resource.
  ///  Note that OUTPUT_ONLY and IMMUTABLE fields in `backup_plan` are ignored
  ///  and are not used to update the target BackupPlan.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.BackupPlan] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.BackupPlan]: @googleapis_reference_link{google/cloud/gkebackup/v1/backup_plan.proto#L33}
  /// [google.cloud.gkebackup.v1.UpdateBackupPlanRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L437}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::BackupPlan>> UpdateBackupPlan(
      google::cloud::gkebackup::v1::BackupPlan const& backup_plan,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update a BackupPlan.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.UpdateBackupPlanRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.BackupPlan] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.BackupPlan]: @googleapis_reference_link{google/cloud/gkebackup/v1/backup_plan.proto#L33}
  /// [google.cloud.gkebackup.v1.UpdateBackupPlanRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L437}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::BackupPlan>> UpdateBackupPlan(
      google::cloud::gkebackup::v1::UpdateBackupPlanRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes an existing BackupPlan.
  ///
  /// @param name  Required. Fully qualified BackupPlan name.
  ///  Format: `projects/*/locations/*/backupPlans/*`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.DeleteBackupPlanRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L455}
  /// [google.cloud.gkebackup.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L320}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
  DeleteBackupPlan(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an existing BackupPlan.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.DeleteBackupPlanRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.DeleteBackupPlanRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L455}
  /// [google.cloud.gkebackup.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L320}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
  DeleteBackupPlan(
      google::cloud::gkebackup::v1::DeleteBackupPlanRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a Backup for the given BackupPlan.
  ///
  /// @param parent  Required. The BackupPlan within which to create the Backup.
  ///  Format: `projects/*/locations/*/backupPlans/*`
  /// @param backup  The Backup resource to create.
  /// @param backup_id  The client-provided short name for the Backup resource.
  ///  This name must:
  ///  @n
  ///  - be between 1 and 63 characters long (inclusive)
  ///  - consist of only lower-case ASCII letters, numbers, and dashes
  ///  - start with a lower-case letter
  ///  - end with a lower-case letter or number
  ///  - be unique within the set of Backups in this BackupPlan
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.Backup] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.Backup]: @googleapis_reference_link{google/cloud/gkebackup/v1/backup.proto#L37}
  /// [google.cloud.gkebackup.v1.CreateBackupRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L472}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::Backup>> CreateBackup(
      std::string const& parent,
      google::cloud::gkebackup::v1::Backup const& backup,
      std::string const& backup_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a Backup for the given BackupPlan.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.CreateBackupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.Backup] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.Backup]: @googleapis_reference_link{google/cloud/gkebackup/v1/backup.proto#L37}
  /// [google.cloud.gkebackup.v1.CreateBackupRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L472}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::Backup>> CreateBackup(
      google::cloud::gkebackup::v1::CreateBackupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the Backups for a given BackupPlan.
  ///
  /// @param parent  Required. The BackupPlan that contains the Backups to list.
  ///  Format: `projects/*/locations/*/backupPlans/*`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkebackup.v1.Backup], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.Backup]: @googleapis_reference_link{google/cloud/gkebackup/v1/backup.proto#L37}
  /// [google.cloud.gkebackup.v1.ListBackupsRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L497}
  ///
  // clang-format on
  StreamRange<google::cloud::gkebackup::v1::Backup> ListBackups(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the Backups for a given BackupPlan.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.ListBackupsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkebackup.v1.Backup], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.Backup]: @googleapis_reference_link{google/cloud/gkebackup/v1/backup.proto#L37}
  /// [google.cloud.gkebackup.v1.ListBackupsRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L497}
  ///
  // clang-format on
  StreamRange<google::cloud::gkebackup::v1::Backup> ListBackups(
      google::cloud::gkebackup::v1::ListBackupsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieve the details of a single Backup.
  ///
  /// @param name  Required. Full name of the Backup resource.
  ///  Format: `projects/*/locations/*/backupPlans/*/backups/*`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkebackup.v1.Backup])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.Backup]: @googleapis_reference_link{google/cloud/gkebackup/v1/backup.proto#L37}
  /// [google.cloud.gkebackup.v1.GetBackupRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L543}
  ///
  // clang-format on
  StatusOr<google::cloud::gkebackup::v1::Backup> GetBackup(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieve the details of a single Backup.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.GetBackupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkebackup.v1.Backup])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.Backup]: @googleapis_reference_link{google/cloud/gkebackup/v1/backup.proto#L37}
  /// [google.cloud.gkebackup.v1.GetBackupRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L543}
  ///
  // clang-format on
  StatusOr<google::cloud::gkebackup::v1::Backup> GetBackup(
      google::cloud::gkebackup::v1::GetBackupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Update a Backup.
  ///
  /// @param backup  Required. A new version of the Backup resource that contains updated
  ///  fields. This may be sparsely populated if an `update_mask` is provided.
  /// @param update_mask  This is used to specify the fields to be overwritten in the
  ///  Backup targeted for update. The values for each of these
  ///  updated fields will be taken from the `backup_plan` provided
  ///  with this request. Field names are relative to the root of the resource.
  ///  If no `update_mask` is provided, all fields in `backup` will be
  ///  written to the target Backup resource.
  ///  Note that OUTPUT_ONLY and IMMUTABLE fields in `backup` are ignored
  ///  and are not used to update the target Backup.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.Backup] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.Backup]: @googleapis_reference_link{google/cloud/gkebackup/v1/backup.proto#L37}
  /// [google.cloud.gkebackup.v1.UpdateBackupRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L555}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::Backup>> UpdateBackup(
      google::cloud::gkebackup::v1::Backup const& backup,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update a Backup.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.UpdateBackupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.Backup] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.Backup]: @googleapis_reference_link{google/cloud/gkebackup/v1/backup.proto#L37}
  /// [google.cloud.gkebackup.v1.UpdateBackupRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L555}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::Backup>> UpdateBackup(
      google::cloud::gkebackup::v1::UpdateBackupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes an existing Backup.
  ///
  /// @param name  Required. Name of the Backup resource.
  ///  Format: `projects/*/locations/*/backupPlans/*/backups/*`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.DeleteBackupRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L572}
  /// [google.cloud.gkebackup.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L320}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
  DeleteBackup(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an existing Backup.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.DeleteBackupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.DeleteBackupRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L572}
  /// [google.cloud.gkebackup.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L320}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
  DeleteBackup(google::cloud::gkebackup::v1::DeleteBackupRequest const& request,
               Options opts = {});

  // clang-format off
  ///
  /// Lists the VolumeBackups for a given Backup.
  ///
  /// @param parent  Required. The Backup that contains the VolumeBackups to list.
  ///  Format: `projects/*/locations/*/backupPlans/*/backups/*`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkebackup.v1.VolumeBackup], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.ListVolumeBackupsRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L594}
  /// [google.cloud.gkebackup.v1.VolumeBackup]: @googleapis_reference_link{google/cloud/gkebackup/v1/volume.proto#L36}
  ///
  // clang-format on
  StreamRange<google::cloud::gkebackup::v1::VolumeBackup> ListVolumeBackups(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the VolumeBackups for a given Backup.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.ListVolumeBackupsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkebackup.v1.VolumeBackup], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.ListVolumeBackupsRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L594}
  /// [google.cloud.gkebackup.v1.VolumeBackup]: @googleapis_reference_link{google/cloud/gkebackup/v1/volume.proto#L36}
  ///
  // clang-format on
  StreamRange<google::cloud::gkebackup::v1::VolumeBackup> ListVolumeBackups(
      google::cloud::gkebackup::v1::ListVolumeBackupsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieve the details of a single VolumeBackup.
  ///
  /// @param name  Required. Full name of the VolumeBackup resource.
  ///  Format: `projects/*/locations/*/backupPlans/*/backups/*/volumeBackups/*`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkebackup.v1.VolumeBackup])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.GetVolumeBackupRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L641}
  /// [google.cloud.gkebackup.v1.VolumeBackup]: @googleapis_reference_link{google/cloud/gkebackup/v1/volume.proto#L36}
  ///
  // clang-format on
  StatusOr<google::cloud::gkebackup::v1::VolumeBackup> GetVolumeBackup(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieve the details of a single VolumeBackup.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.GetVolumeBackupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkebackup.v1.VolumeBackup])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.GetVolumeBackupRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L641}
  /// [google.cloud.gkebackup.v1.VolumeBackup]: @googleapis_reference_link{google/cloud/gkebackup/v1/volume.proto#L36}
  ///
  // clang-format on
  StatusOr<google::cloud::gkebackup::v1::VolumeBackup> GetVolumeBackup(
      google::cloud::gkebackup::v1::GetVolumeBackupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new RestorePlan in a given location.
  ///
  /// @param parent  Required. The location within which to create the RestorePlan.
  ///  Format: `projects/*/locations/*`
  /// @param restore_plan  Required. The RestorePlan resource object to create.
  /// @param restore_plan_id  Required. The client-provided short name for the RestorePlan resource.
  ///  This name must:
  ///  @n
  ///  - be between 1 and 63 characters long (inclusive)
  ///  - consist of only lower-case ASCII letters, numbers, and dashes
  ///  - start with a lower-case letter
  ///  - end with a lower-case letter or number
  ///  - be unique within the set of RestorePlans in this location
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.RestorePlan] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.CreateRestorePlanRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L653}
  /// [google.cloud.gkebackup.v1.RestorePlan]: @googleapis_reference_link{google/cloud/gkebackup/v1/restore_plan.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::RestorePlan>> CreateRestorePlan(
      std::string const& parent,
      google::cloud::gkebackup::v1::RestorePlan const& restore_plan,
      std::string const& restore_plan_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new RestorePlan in a given location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.CreateRestorePlanRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.RestorePlan] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.CreateRestorePlanRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L653}
  /// [google.cloud.gkebackup.v1.RestorePlan]: @googleapis_reference_link{google/cloud/gkebackup/v1/restore_plan.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::RestorePlan>> CreateRestorePlan(
      google::cloud::gkebackup::v1::CreateRestorePlanRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists RestorePlans in a given location.
  ///
  /// @param parent  Required. The location that contains the RestorePlans to list.
  ///  Format: `projects/*/locations/*`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkebackup.v1.RestorePlan], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.ListRestorePlansRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L678}
  /// [google.cloud.gkebackup.v1.RestorePlan]: @googleapis_reference_link{google/cloud/gkebackup/v1/restore_plan.proto#L35}
  ///
  // clang-format on
  StreamRange<google::cloud::gkebackup::v1::RestorePlan> ListRestorePlans(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists RestorePlans in a given location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.ListRestorePlansRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkebackup.v1.RestorePlan], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.ListRestorePlansRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L678}
  /// [google.cloud.gkebackup.v1.RestorePlan]: @googleapis_reference_link{google/cloud/gkebackup/v1/restore_plan.proto#L35}
  ///
  // clang-format on
  StreamRange<google::cloud::gkebackup::v1::RestorePlan> ListRestorePlans(
      google::cloud::gkebackup::v1::ListRestorePlansRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieve the details of a single RestorePlan.
  ///
  /// @param name  Required. Fully qualified RestorePlan name.
  ///  Format: `projects/*/locations/*/restorePlans/*`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkebackup.v1.RestorePlan])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.GetRestorePlanRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L728}
  /// [google.cloud.gkebackup.v1.RestorePlan]: @googleapis_reference_link{google/cloud/gkebackup/v1/restore_plan.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::gkebackup::v1::RestorePlan> GetRestorePlan(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieve the details of a single RestorePlan.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.GetRestorePlanRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkebackup.v1.RestorePlan])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.GetRestorePlanRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L728}
  /// [google.cloud.gkebackup.v1.RestorePlan]: @googleapis_reference_link{google/cloud/gkebackup/v1/restore_plan.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::gkebackup::v1::RestorePlan> GetRestorePlan(
      google::cloud::gkebackup::v1::GetRestorePlanRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Update a RestorePlan.
  ///
  /// @param restore_plan  Required. A new version of the RestorePlan resource that contains updated
  ///  fields. This may be sparsely populated if an `update_mask` is provided.
  /// @param update_mask  This is used to specify the fields to be overwritten in the
  ///  RestorePlan targeted for update. The values for each of these
  ///  updated fields will be taken from the `restore_plan` provided
  ///  with this request. Field names are relative to the root of the resource.
  ///  If no `update_mask` is provided, all fields in `restore_plan` will be
  ///  written to the target RestorePlan resource.
  ///  Note that OUTPUT_ONLY and IMMUTABLE fields in `restore_plan` are ignored
  ///  and are not used to update the target RestorePlan.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.RestorePlan] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.RestorePlan]: @googleapis_reference_link{google/cloud/gkebackup/v1/restore_plan.proto#L35}
  /// [google.cloud.gkebackup.v1.UpdateRestorePlanRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L740}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::RestorePlan>> UpdateRestorePlan(
      google::cloud::gkebackup::v1::RestorePlan const& restore_plan,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update a RestorePlan.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.UpdateRestorePlanRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.RestorePlan] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.RestorePlan]: @googleapis_reference_link{google/cloud/gkebackup/v1/restore_plan.proto#L35}
  /// [google.cloud.gkebackup.v1.UpdateRestorePlanRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L740}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::RestorePlan>> UpdateRestorePlan(
      google::cloud::gkebackup::v1::UpdateRestorePlanRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes an existing RestorePlan.
  ///
  /// @param name  Required. Fully qualified RestorePlan name.
  ///  Format: `projects/*/locations/*/restorePlans/*`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.DeleteRestorePlanRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L757}
  /// [google.cloud.gkebackup.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L320}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
  DeleteRestorePlan(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an existing RestorePlan.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.DeleteRestorePlanRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.DeleteRestorePlanRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L757}
  /// [google.cloud.gkebackup.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L320}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
  DeleteRestorePlan(
      google::cloud::gkebackup::v1::DeleteRestorePlanRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Restore for the given RestorePlan.
  ///
  /// @param parent  Required. The RestorePlan within which to create the Restore.
  ///  Format: `projects/*/locations/*/restorePlans/*`
  /// @param restore  Required. The restore resource to create.
  /// @param restore_id  Required. The client-provided short name for the Restore resource.
  ///  This name must:
  ///  @n
  ///  - be between 1 and 63 characters long (inclusive)
  ///  - consist of only lower-case ASCII letters, numbers, and dashes
  ///  - start with a lower-case letter
  ///  - end with a lower-case letter or number
  ///  - be unique within the set of Restores in this RestorePlan.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.Restore] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.CreateRestoreRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L779}
  /// [google.cloud.gkebackup.v1.Restore]: @googleapis_reference_link{google/cloud/gkebackup/v1/restore.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::Restore>> CreateRestore(
      std::string const& parent,
      google::cloud::gkebackup::v1::Restore const& restore,
      std::string const& restore_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new Restore for the given RestorePlan.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.CreateRestoreRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.Restore] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.CreateRestoreRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L779}
  /// [google.cloud.gkebackup.v1.Restore]: @googleapis_reference_link{google/cloud/gkebackup/v1/restore.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::Restore>> CreateRestore(
      google::cloud::gkebackup::v1::CreateRestoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the Restores for a given RestorePlan.
  ///
  /// @param parent  Required. The RestorePlan that contains the Restores to list.
  ///  Format: `projects/*/locations/*/restorePlans/*`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkebackup.v1.Restore], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.ListRestoresRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L804}
  /// [google.cloud.gkebackup.v1.Restore]: @googleapis_reference_link{google/cloud/gkebackup/v1/restore.proto#L35}
  ///
  // clang-format on
  StreamRange<google::cloud::gkebackup::v1::Restore> ListRestores(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the Restores for a given RestorePlan.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.ListRestoresRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkebackup.v1.Restore], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.ListRestoresRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L804}
  /// [google.cloud.gkebackup.v1.Restore]: @googleapis_reference_link{google/cloud/gkebackup/v1/restore.proto#L35}
  ///
  // clang-format on
  StreamRange<google::cloud::gkebackup::v1::Restore> ListRestores(
      google::cloud::gkebackup::v1::ListRestoresRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves the details of a single Restore.
  ///
  /// @param name  Required. Name of the restore resource.
  ///  Format: `projects/*/locations/*/restorePlans/*/restores/*`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkebackup.v1.Restore])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.GetRestoreRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L853}
  /// [google.cloud.gkebackup.v1.Restore]: @googleapis_reference_link{google/cloud/gkebackup/v1/restore.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::gkebackup::v1::Restore> GetRestore(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves the details of a single Restore.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.GetRestoreRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkebackup.v1.Restore])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.GetRestoreRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L853}
  /// [google.cloud.gkebackup.v1.Restore]: @googleapis_reference_link{google/cloud/gkebackup/v1/restore.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::gkebackup::v1::Restore> GetRestore(
      google::cloud::gkebackup::v1::GetRestoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Update a Restore.
  ///
  /// @param restore  Required. A new version of the Restore resource that contains updated
  ///  fields. This may be sparsely populated if an `update_mask` is provided.
  /// @param update_mask  This is used to specify the fields to be overwritten in the
  ///  Restore targeted for update. The values for each of these
  ///  updated fields will be taken from the `restore` provided
  ///  with this request. Field names are relative to the root of the resource.
  ///  If no `update_mask` is provided, all fields in `restore` will be
  ///  written to the target Restore resource.
  ///  Note that OUTPUT_ONLY and IMMUTABLE fields in `restore` are ignored
  ///  and are not used to update the target Restore.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.Restore] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.Restore]: @googleapis_reference_link{google/cloud/gkebackup/v1/restore.proto#L35}
  /// [google.cloud.gkebackup.v1.UpdateRestoreRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L865}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::Restore>> UpdateRestore(
      google::cloud::gkebackup::v1::Restore const& restore,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update a Restore.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.UpdateRestoreRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.Restore] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.Restore]: @googleapis_reference_link{google/cloud/gkebackup/v1/restore.proto#L35}
  /// [google.cloud.gkebackup.v1.UpdateRestoreRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L865}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::Restore>> UpdateRestore(
      google::cloud::gkebackup::v1::UpdateRestoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes an existing Restore.
  ///
  /// @param name  Required. Full name of the Restore
  ///  Format: `projects/*/locations/*/restorePlans/*/restores/*`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.DeleteRestoreRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L882}
  /// [google.cloud.gkebackup.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L320}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
  DeleteRestore(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an existing Restore.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.DeleteRestoreRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkebackup.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.DeleteRestoreRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L882}
  /// [google.cloud.gkebackup.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L320}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>
  DeleteRestore(
      google::cloud::gkebackup::v1::DeleteRestoreRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the VolumeRestores for a given Restore.
  ///
  /// @param parent  Required. The Restore that contains the VolumeRestores to list.
  ///  Format: `projects/*/locations/*/restorePlans/*/restores/*`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkebackup.v1.VolumeRestore], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.ListVolumeRestoresRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L904}
  /// [google.cloud.gkebackup.v1.VolumeRestore]: @googleapis_reference_link{google/cloud/gkebackup/v1/volume.proto#L143}
  ///
  // clang-format on
  StreamRange<google::cloud::gkebackup::v1::VolumeRestore> ListVolumeRestores(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the VolumeRestores for a given Restore.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.ListVolumeRestoresRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkebackup.v1.VolumeRestore], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.ListVolumeRestoresRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L904}
  /// [google.cloud.gkebackup.v1.VolumeRestore]: @googleapis_reference_link{google/cloud/gkebackup/v1/volume.proto#L143}
  ///
  // clang-format on
  StreamRange<google::cloud::gkebackup::v1::VolumeRestore> ListVolumeRestores(
      google::cloud::gkebackup::v1::ListVolumeRestoresRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieve the details of a single VolumeRestore.
  ///
  /// @param name  Required. Full name of the VolumeRestore resource.
  ///  Format: `projects/*/locations/*/restorePlans/*/restores/*/volumeRestores/*`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkebackup.v1.VolumeRestore])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.GetVolumeRestoreRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L951}
  /// [google.cloud.gkebackup.v1.VolumeRestore]: @googleapis_reference_link{google/cloud/gkebackup/v1/volume.proto#L143}
  ///
  // clang-format on
  StatusOr<google::cloud::gkebackup::v1::VolumeRestore> GetVolumeRestore(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieve the details of a single VolumeRestore.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkebackup.v1.GetVolumeRestoreRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkebackup.v1.VolumeRestore])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkebackup.v1.GetVolumeRestoreRequest]: @googleapis_reference_link{google/cloud/gkebackup/v1/gkebackup.proto#L951}
  /// [google.cloud.gkebackup.v1.VolumeRestore]: @googleapis_reference_link{google/cloud/gkebackup/v1/volume.proto#L143}
  ///
  // clang-format on
  StatusOr<google::cloud::gkebackup::v1::VolumeRestore> GetVolumeRestore(
      google::cloud::gkebackup::v1::GetVolumeRestoreRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<BackupForGKEConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkebackup_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEBACKUP_V1_BACKUP_FOR_GKE_CLIENT_H
